import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Properties for KubernetesPatch.
 *
 * @experimental
 */
export interface KubernetesPatchProps {
    /**
     * (experimental) The cluster to apply the patch to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The JSON object to pass to `kubectl patch` when the resource is created/updated.
     *
     * @experimental
     */
    readonly applyPatch: {
        [key: string]: any;
    };
    /**
     * (experimental) The JSON object to pass to `kubectl patch` when the resource is removed.
     *
     * @experimental
     */
    readonly restorePatch: {
        [key: string]: any;
    };
    /**
     * (experimental) The full name of the resource to patch (e.g. `deployment/coredns`).
     *
     * @experimental
     */
    readonly resourceName: string;
    /**
     * (experimental) The kubernetes API namespace.
     *
     * @default "default"
     * @experimental
     */
    readonly resourceNamespace?: string;
    /**
     * (experimental) The patch type to pass to `kubectl patch`.
     *
     * The default type used by `kubectl patch` is "strategic".
     *
     * @default PatchType.STRATEGIC
     * @experimental
     */
    readonly patchType?: PatchType;
}
/**
 * (experimental) Values for `kubectl patch` --type argument.
 *
 * @experimental
 */
export declare enum PatchType {
    /**
     * (experimental) JSON Patch, RFC 6902.
     *
     * @experimental
     */
    JSON = "json",
    /**
     * (experimental) JSON Merge patch.
     *
     * @experimental
     */
    MERGE = "merge",
    /**
     * (experimental) Strategic merge patch.
     *
     * @experimental
     */
    STRATEGIC = "strategic"
}
/**
 * (experimental) A CloudFormation resource which applies/restores a JSON patch into a Kubernetes resource.
 *
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 * @experimental
 */
export declare class KubernetesPatch extends CoreConstruct {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubernetesPatchProps);
}
