import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Properties for KubernetesManifest.
 *
 * @experimental
 */
export interface KubernetesManifestProps {
    /**
     * (experimental) The EKS cluster to apply this manifest to.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The manifest to apply.
     *
     * Consists of any number of child resources.
     *
     * When the resources are created/updated, this manifest will be applied to the
     * cluster through `kubectl apply` and when the resources or the stack is
     * deleted, the resources in the manifest will be deleted through `kubectl delete`.
     *
     * @experimental
     * @example
     *
     * [{
     *   apiVersion: 'v1',
     *   kind: 'Pod',
     *   metadata: { name: 'mypod' },
     *   spec: {
     *     containers: [ { name: 'hello', image: 'paulbouwer/hello-kubernetes:1.5', ports: [ { containerPort: 8080 } ] } ]
     *   }
     * }]
     */
    readonly manifest: any[];
}
/**
 * (experimental) Represents a manifest within the Kubernetes system.
 *
 * Alternatively, you can use `cluster.addManifest(resource[, resource, ...])`
 * to define resources on this cluster.
 *
 * Applies/deletes the manifest using `kubectl`.
 *
 * @experimental
 */
export declare class KubernetesManifest extends CoreConstruct {
    /**
     * (experimental) The CloudFormation reosurce type.
     *
     * @experimental
     */
    static readonly RESOURCE_TYPE = "Custom::AWSCDK-EKS-KubernetesResource";
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: KubernetesManifestProps);
}
