"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const cluster_1 = require("./cluster");
/**
 * (experimental) Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 *
 * @experimental
 */
class FargateCluster extends cluster_1.Cluster {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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