"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterResourceProvider = void 0;
const path = require("path");
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cr = require("../../custom-resources"); // Automatically re-written from '@aws-cdk/custom-resources'
const HANDLER_DIR = path.join(__dirname, 'cluster-resource-handler');
const HANDLER_RUNTIME = lambda.Runtime.NODEJS_12_X;
/**
 * A custom resource provider that handles cluster operations. It serves
 * multiple custom resources such as the cluster resource and the fargate
 * resource.
 *
 * @internal
 */
class ClusterResourceProvider extends core_1.NestedStack {
    constructor(scope, id, props) {
        super(scope, id);
        const onEvent = new lambda.Function(this, 'OnEventHandler', {
            code: lambda.Code.fromAsset(HANDLER_DIR),
            description: 'onEvent handler for EKS cluster resource provider',
            runtime: HANDLER_RUNTIME,
            handler: 'index.onEvent',
            timeout: core_1.Duration.minutes(1),
        });
        const isComplete = new lambda.Function(this, 'IsCompleteHandler', {
            code: lambda.Code.fromAsset(HANDLER_DIR),
            description: 'isComplete handler for EKS cluster resource provider',
            runtime: HANDLER_RUNTIME,
            handler: 'index.isComplete',
            timeout: core_1.Duration.minutes(1),
        });
        this.provider = new cr.Provider(this, 'Provider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            totalTimeout: core_1.Duration.hours(1),
            queryInterval: core_1.Duration.minutes(1),
        });
        props.adminRole.grant(onEvent.role, 'sts:AssumeRole');
        props.adminRole.grant(isComplete.role, 'sts:AssumeRole');
    }
    static getOrCreate(scope, props) {
        var _a;
        const stack = core_1.Stack.of(scope);
        const uid = '@aws-cdk/aws-eks.ClusterResourceProvider';
        return (_a = stack.node.tryFindChild(uid)) !== null && _a !== void 0 ? _a : new ClusterResourceProvider(stack, uid, props);
    }
    /**
     * The custom resource service token for this provider.
     */
    get serviceToken() { return this.provider.serviceToken; }
}
exports.ClusterResourceProvider = ClusterResourceProvider;
//# sourceMappingURL=data:application/json;base64,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