"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderUserData = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const spot_interrupt_handler_1 = require("./spot-interrupt-handler");
function renderUserData(clusterName, autoScalingGroup, options = {}) {
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${options.useMaxPods === undefined ? true : options.useMaxPods}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? spot_interrupt_handler_1.LifecycleLabel.SPOT : spot_interrupt_handler_1.LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderUserData = renderUserData;
//# sourceMappingURL=data:application/json;base64,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