import * as ec2 from "../../aws-ec2";
import * as kms from "../../aws-kms";
import { IDependable, IResource, RemovalPolicy, Resource, Size } from "../../core";
import { Construct } from 'constructs';
import { AccessPoint, AccessPointOptions } from './access-point';
/**
 * (experimental) EFS Lifecycle Policy, if a file is not accessed for given days, it will move to EFS Infrequent Access.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-elasticfilesystem-filesystem-lifecyclepolicies
 * @experimental
 */
export declare enum LifecyclePolicy {
    /**
     * (experimental) After 7 days of not being accessed.
     *
     * @experimental
     */
    AFTER_7_DAYS = "AFTER_7_DAYS",
    /**
     * (experimental) After 14 days of not being accessed.
     *
     * @experimental
     */
    AFTER_14_DAYS = "AFTER_14_DAYS",
    /**
     * (experimental) After 30 days of not being accessed.
     *
     * @experimental
     */
    AFTER_30_DAYS = "AFTER_30_DAYS",
    /**
     * (experimental) After 60 days of not being accessed.
     *
     * @experimental
     */
    AFTER_60_DAYS = "AFTER_60_DAYS",
    /**
     * (experimental) After 90 days of not being accessed.
     *
     * @experimental
     */
    AFTER_90_DAYS = "AFTER_90_DAYS"
}
/**
 * (experimental) EFS Performance mode.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
 * @experimental
 */
export declare enum PerformanceMode {
    /**
     * (experimental) This is the general purpose performance mode for most file systems.
     *
     * @experimental
     */
    GENERAL_PURPOSE = "generalPurpose",
    /**
     * (experimental) This performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies.
     *
     * @experimental
     */
    MAX_IO = "maxIO"
}
/**
 * (experimental) EFS Throughput mode.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-elasticfilesystem-filesystem-throughputmode
 * @experimental
 */
export declare enum ThroughputMode {
    /**
     * (experimental) This mode on Amazon EFS scales as the size of the file system in the standard storage class grows.
     *
     * @experimental
     */
    BURSTING = "bursting",
    /**
     * (experimental) This mode can instantly provision the throughput of the file system (in MiB/s) independent of the amount of data stored.
     *
     * @experimental
     */
    PROVISIONED = "provisioned"
}
/**
 * (experimental) Interface to implement AWS File Systems.
 *
 * @experimental
 */
export interface IFileSystem extends ec2.IConnectable, IResource {
    /**
     * (experimental) The ID of the file system, assigned by Amazon EFS.
     *
     * @experimental
     * @attribute true
     */
    readonly fileSystemId: string;
    /**
     * (experimental) Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
     *
     * @experimental
     */
    readonly mountTargetsAvailable: IDependable;
}
/**
 * (experimental) Properties of EFS FileSystem.
 *
 * @experimental
 */
export interface FileSystemProps {
    /**
     * (experimental) VPC to launch the file system in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Security Group to assign to this file system.
     *
     * @default - creates new security group which allow all out bound traffic
     * @experimental
     */
    readonly securityGroup?: ec2.ISecurityGroup;
    /**
     * (experimental) Which subnets to place the mount target in the VPC.
     *
     * @default - the Vpc default strategy if not specified
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Defines if the data at rest in the file system is encrypted or not.
     *
     * @default - false
     * @experimental
     */
    readonly encrypted?: boolean;
    /**
     * (experimental) The filesystem's name.
     *
     * @default - CDK generated name
     * @experimental
     */
    readonly fileSystemName?: string;
    /**
     * (experimental) The KMS key used for encryption.
     *
     * This is required to encrypt the data at rest if @encrypted is set to true.
     *
     * @default - if
     * @experimental
     * @encrypted is true, the default key for EFS (/aws/elasticfilesystem) is used
     */
    readonly kmsKey?: kms.IKey;
    /**
     * (experimental) A policy used by EFS lifecycle management to transition files to the Infrequent Access (IA) storage class.
     *
     * @default - none
     * @experimental
     */
    readonly lifecyclePolicy?: LifecyclePolicy;
    /**
     * (experimental) Enum to mention the performance mode of the file system.
     *
     * @default - GENERAL_PURPOSE
     * @experimental
     */
    readonly performanceMode?: PerformanceMode;
    /**
     * (experimental) Enum to mention the throughput mode of the file system.
     *
     * @default - BURSTING
     * @experimental
     */
    readonly throughputMode?: ThroughputMode;
    /**
     * (experimental) Provisioned throughput for the file system.
     *
     * This is a required property if the throughput mode is set to PROVISIONED.
     * Must be at least 1MiB/s.
     *
     * @default - none, errors out
     * @experimental
     */
    readonly provisionedThroughputPerSecond?: Size;
    /**
     * (experimental) The removal policy to apply to the file system.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Whether to enable automatic backups for the file system.
     *
     * @default false
     * @experimental
     */
    readonly enableAutomaticBackups?: boolean;
}
/**
 * (experimental) Properties that describe an existing EFS file system.
 *
 * @experimental
 */
export interface FileSystemAttributes {
    /**
     * (experimental) The security group of the file system.
     *
     * @experimental
     */
    readonly securityGroup: ec2.ISecurityGroup;
    /**
     * (experimental) The File System's ID.
     *
     * @experimental
     */
    readonly fileSystemId: string;
}
/**
 * (experimental) The Elastic File System implementation of IFileSystem.
 *
 * It creates a new, empty file system in Amazon Elastic File System (Amazon EFS).
 * It also creates mount target (AWS::EFS::MountTarget) implicitly to mount the
 * EFS file system on an Amazon Elastic Compute Cloud (Amazon EC2) instance or another resource.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 * @experimental
 * @resource AWS::EFS::FileSystem
 */
export declare class FileSystem extends Resource implements IFileSystem {
    /**
     * (experimental) Import an existing File System from the given properties.
     *
     * @experimental
     */
    static fromFileSystemAttributes(scope: Construct, id: string, attrs: FileSystemAttributes): IFileSystem;
    /**
     * The default port File System listens on.
     */
    private static readonly DEFAULT_PORT;
    /**
     * (experimental) The security groups/rules used to allow network connections to the file system.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The ID of the file system, assigned by Amazon EFS.
     *
     * @experimental
     * @attribute true
     */
    readonly fileSystemId: string;
    /**
     * (experimental) Dependable that can be depended upon to ensure the mount targets of the filesystem are ready.
     *
     * @experimental
     */
    readonly mountTargetsAvailable: IDependable;
    private readonly _mountTargetsAvailable;
    /**
     * (experimental) Constructor for creating a new EFS FileSystem.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: FileSystemProps);
    /**
     * (experimental) create access point from this filesystem.
     *
     * @experimental
     */
    addAccessPoint(id: string, accessPointOptions?: AccessPointOptions): AccessPoint;
}
