import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Specifies the syslog log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/syslog/)
 *
 * @experimental
 */
export interface SyslogLogDriverProps extends BaseLogDriverProps {
    /**
     * (experimental) The address of an external syslog server.
     *
     * The URI specifier may be
     * [tcp|udp|tcp+tls]://host:port, unix://path, or unixgram://path.
     *
     * @default - If the transport is tcp, udp, or tcp+tls, the default port is 514.
     * @experimental
     */
    readonly address?: string;
    /**
     * (experimental) The syslog facility to use.
     *
     * Can be the number or name for any valid
     * syslog facility. See the syslog documentation:
     * https://tools.ietf.org/html/rfc5424#section-6.2.1.
     *
     * @default - facility not set
     * @experimental
     */
    readonly facility?: string;
    /**
     * (experimental) The absolute path to the trust certificates signed by the CA.
     *
     * Ignored
     * if the address protocol is not tcp+tls.
     *
     * @default - tlsCaCert not set
     * @experimental
     */
    readonly tlsCaCert?: string;
    /**
     * (experimental) The absolute path to the TLS certificate file.
     *
     * Ignored if the address
     * protocol is not tcp+tls.
     *
     * @default - tlsCert not set
     * @experimental
     */
    readonly tlsCert?: string;
    /**
     * (experimental) The absolute path to the TLS key file.
     *
     * Ignored if the address protocol
     * is not tcp+tls.
     *
     * @default - tlsKey not set
     * @experimental
     */
    readonly tlsKey?: string;
    /**
     * (experimental) If set to true, TLS verification is skipped when connecting to the syslog daemon.
     *
     * Ignored if the address protocol is not tcp+tls.
     *
     * @default - false
     * @experimental
     */
    readonly tlsSkipVerify?: boolean;
    /**
     * (experimental) The syslog message format to use.
     *
     * If not specified the local UNIX syslog
     * format is used, without a specified hostname. Specify rfc3164 for the RFC-3164
     * compatible format, rfc5424 for RFC-5424 compatible format, or rfc5424micro
     * for RFC-5424 compatible format with microsecond timestamp resolution.
     *
     * @default - format not set
     * @experimental
     */
    readonly format?: string;
}
/**
 * (experimental) A log driver that sends log information to syslog Logs.
 *
 * @experimental
 */
export declare class SyslogLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the SyslogLogDriver class.
     *
     * @param props the syslog log driver configuration options.
     * @experimental
     */
    constructor(props?: SyslogLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
