"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplunkLogDriver = exports.SplunkLogFormat = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * (experimental) Log Message Format.
 *
 * @experimental
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * (experimental) A log driver that sends log information to splunk Logs.
 *
 * @experimental
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * (experimental) Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     * @experimental
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'splunk',
            options: utils_1.stringifyOptions({
                'splunk-token': this.props.token,
                'splunk-url': this.props.url,
                'splunk-source': this.props.source,
                'splunk-sourcetype': this.props.sourceType,
                'splunk-index': this.props.index,
                'splunk-capath': this.props.caPath,
                'splunk-caname': this.props.caName,
                'splunk-insecureskipverify': this.props.insecureSkipVerify,
                'splunk-format': this.props.format,
                'splunk-verify-connection': this.props.verifyConnection,
                'splunk-gzip': this.props.gzip,
                'splunk-gzip-level': this.props.gzipLevel,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
//# sourceMappingURL=data:application/json;base64,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