import { SecretValue } from "../../../core";
import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Log Message Format.
 *
 * @experimental
 */
export declare enum SplunkLogFormat {
    /**
     * @experimental
     */
    INLINE = "inline",
    /**
     * @experimental
     */
    JSON = "json",
    /**
     * @experimental
     */
    RAW = "raw"
}
/**
 * (experimental) Specifies the splunk log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/splunk/)
 *
 * @experimental
 */
export interface SplunkLogDriverProps extends BaseLogDriverProps {
    /**
     * (experimental) Splunk HTTP Event Collector token.
     *
     * @experimental
     */
    readonly token: SecretValue;
    /**
     * (experimental) Path to your Splunk Enterprise, self-service Splunk Cloud instance, or Splunk Cloud managed cluster (including port and scheme used by HTTP Event Collector) in one of the following formats: https://your_splunk_instance:8088 or https://input-prd-p-XXXXXXX.cloud.splunk.com:8088 or https://http-inputs-XXXXXXXX.splunkcloud.com.
     *
     * @experimental
     */
    readonly url: string;
    /**
     * (experimental) Event source.
     *
     * @default - source not set.
     * @experimental
     */
    readonly source?: string;
    /**
     * (experimental) Event source type.
     *
     * @default - sourceType not set.
     * @experimental
     */
    readonly sourceType?: string;
    /**
     * (experimental) Event index.
     *
     * @default - index not set.
     * @experimental
     */
    readonly index?: string;
    /**
     * (experimental) Path to root certificate.
     *
     * @default - caPath not set.
     * @experimental
     */
    readonly caPath?: string;
    /**
     * (experimental) Name to use for validating server certificate.
     *
     * @default - The hostname of the splunk-url
     * @experimental
     */
    readonly caName?: string;
    /**
     * (experimental) Ignore server certificate validation.
     *
     * @default - insecureSkipVerify not set.
     * @experimental
     */
    readonly insecureSkipVerify?: string;
    /**
     * (experimental) Message format.
     *
     * Can be inline, json or raw.
     *
     * @default - inline
     * @experimental
     */
    readonly format?: SplunkLogFormat;
    /**
     * (experimental) Verify on start, that docker can connect to Splunk server.
     *
     * @default - true
     * @experimental
     */
    readonly verifyConnection?: boolean;
    /**
     * (experimental) Enable/disable gzip compression to send events to Splunk Enterprise or Splunk Cloud instance.
     *
     * @default - false
     * @experimental
     */
    readonly gzip?: boolean;
    /**
     * (experimental) Set compression level for gzip.
     *
     * Valid values are -1 (default), 0 (no compression),
     * 1 (best speed) ... 9 (best compression).
     *
     * @default - -1 (Default Compression)
     * @experimental
     */
    readonly gzipLevel?: number;
}
/**
 * (experimental) A log driver that sends log information to splunk Logs.
 *
 * @experimental
 */
export declare class SplunkLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     * @experimental
     */
    constructor(props: SplunkLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
