"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentdLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * (experimental) A log driver that sends log information to journald Logs.
 *
 * @experimental
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * (experimental) Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     * @experimental
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions({
                'fluentd-address': this.props.address,
                'fluentd-async-connect': this.props.asyncConnect,
                'fluentd-buffer-limit': this.props.bufferLimit,
                'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(),
                'fluentd-max-retries': this.props.maxRetries,
                'fluentd-sub-second-precision': this.props.subSecondPrecision,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
//# sourceMappingURL=data:application/json;base64,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