import { Duration } from "../../../core";
import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Specifies the fluentd log driver configuration options.
 *
 * [Source](https://docs.docker.com/config/containers/logging/fluentd/)
 *
 * @experimental
 */
export interface FluentdLogDriverProps extends BaseLogDriverProps {
    /**
     * (experimental) By default, the logging driver connects to localhost:24224.
     *
     * Supply the
     * address option to connect to a different address. tcp(default) and unix
     * sockets are supported.
     *
     * @default - address not set.
     * @experimental
     */
    readonly address?: string;
    /**
     * (experimental) Docker connects to Fluentd in the background.
     *
     * Messages are buffered until
     * the connection is established.
     *
     * @default - false
     * @experimental
     */
    readonly asyncConnect?: boolean;
    /**
     * (experimental) The amount of data to buffer before flushing to disk.
     *
     * @default - The amount of RAM available to the container.
     * @experimental
     */
    readonly bufferLimit?: number;
    /**
     * (experimental) How long to wait between retries.
     *
     * @default - 1 second
     * @experimental
     */
    readonly retryWait?: Duration;
    /**
     * (experimental) The maximum number of retries.
     *
     * @default - 4294967295 (2**32 - 1).
     * @experimental
     */
    readonly maxRetries?: number;
    /**
     * (experimental) Generates event logs in nanosecond resolution.
     *
     * @default - false
     * @experimental
     */
    readonly subSecondPrecision?: boolean;
}
/**
 * (experimental) A log driver that sends log information to journald Logs.
 *
 * @experimental
 */
export declare class FluentdLogDriver extends LogDriver {
    private readonly props;
    /**
     * (experimental) Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     * @experimental
     */
    constructor(props?: FluentdLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
