import { ContainerDefinition } from '../container-definition';
import { BaseLogDriverProps } from './base-log-driver';
import { LogDriver, LogDriverConfig } from './log-driver';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) Specifies the firelens log driver configuration options.
 *
 * @experimental
 */
export interface FireLensLogDriverProps extends BaseLogDriverProps {
    /**
     * (experimental) The configuration options to send to the log driver.
     *
     * @default - the log driver options
     * @experimental
     */
    readonly options?: {
        [key: string]: string;
    };
}
/**
 * (experimental) FireLens enables you to use task definition parameters to route logs to an AWS service   or AWS Partner Network (APN) destination for log storage and analytics.
 *
 * @experimental
 */
export declare class FireLensLogDriver extends LogDriver {
    /**
     * The configuration options to send to the log driver.
     * @default - the log driver options
     */
    private options?;
    /**
     * (experimental) Constructs a new instance of the FireLensLogDriver class.
     *
     * @param props the awsfirelens log driver configuration options.
     * @experimental
     */
    constructor(props: FireLensLogDriverProps);
    /**
     * (experimental) Called when the log driver is configured on a container.
     *
     * @experimental
     */
    bind(_scope: CoreConstruct, _containerDefinition: ContainerDefinition): LogDriverConfig;
}
