import { Construct } from 'constructs';
import { CommonTaskDefinitionProps, IpcMode, ITaskDefinition, NetworkMode, PidMode, TaskDefinition } from '../base/task-definition';
import { PlacementConstraint } from '../placement';
/**
 * (experimental) The properties for a task definition run on an EC2 cluster.
 *
 * @experimental
 */
export interface Ec2TaskDefinitionProps extends CommonTaskDefinitionProps {
    /**
     * (experimental) The Docker networking mode to use for the containers in the task.
     *
     * The valid values are none, bridge, awsvpc, and host.
     *
     * @default - NetworkMode.Bridge for EC2 tasks, AwsVpc for Fargate tasks.
     * @experimental
     */
    readonly networkMode?: NetworkMode;
    /**
     * (experimental) An array of placement constraint objects to use for the task.
     *
     * You can
     * specify a maximum of 10 constraints per task (this limit includes
     * constraints in the task definition and those specified at run time).
     *
     * @default - No placement constraints.
     * @experimental
     */
    readonly placementConstraints?: PlacementConstraint[];
    /**
     * (experimental) The IPC resource namespace to use for the containers in the task.
     *
     * Not supported in Fargate and Windows containers.
     *
     * @default - IpcMode used by the task is not specified
     * @experimental
     */
    readonly ipcMode?: IpcMode;
    /**
     * (experimental) The process namespace to use for the containers in the task.
     *
     * Not supported in Fargate and Windows containers.
     *
     * @default - PidMode used by the task is not specified
     * @experimental
     */
    readonly pidMode?: PidMode;
}
/**
 * (experimental) The interface of a task definition run on an EC2 cluster.
 *
 * @experimental
 */
export interface IEc2TaskDefinition extends ITaskDefinition {
}
/**
 * (experimental) The details of a task definition run on an EC2 cluster.
 *
 * @experimental
 * @resource AWS::ECS::TaskDefinition
 */
export declare class Ec2TaskDefinition extends TaskDefinition implements IEc2TaskDefinition {
    /**
     * (experimental) Imports a task definition from the specified task definition ARN.
     *
     * @experimental
     */
    static fromEc2TaskDefinitionArn(scope: Construct, id: string, ec2TaskDefinitionArn: string): IEc2TaskDefinition;
    /**
     * (experimental) Constructs a new instance of the Ec2TaskDefinition class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: Ec2TaskDefinitionProps);
}
