import * as autoscaling from "../../aws-autoscaling";
import * as cloudwatch from "../../aws-cloudwatch";
import * as ec2 from "../../aws-ec2";
import * as kms from "../../aws-kms";
import * as cloudmap from "../../aws-servicediscovery";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) The properties used to define an ECS cluster.
 *
 * @experimental
 */
export interface ClusterProps {
    /**
     * (experimental) The name for the cluster.
     *
     * @default CloudFormation-generated name
     * @experimental
     */
    readonly clusterName?: string;
    /**
     * (experimental) The VPC where your ECS instances will be running or your ENIs will be deployed.
     *
     * @default - creates a new VPC with two AZs
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
    /**
     * (experimental) The service discovery namespace created in this cluster.
     *
     * @default - no service discovery namespace created, you can use `addDefaultCloudMapNamespace` to add a
     * default service discovery namespace later.
     * @experimental
     */
    readonly defaultCloudMapNamespace?: CloudMapNamespaceOptions;
    /**
     * (experimental) The ec2 capacity to add to the cluster.
     *
     * @default - no EC2 capacity will be added, you can use `addCapacity` to add capacity later.
     * @experimental
     */
    readonly capacity?: AddCapacityOptions;
    /**
     * (experimental) If true CloudWatch Container Insights will be enabled for the cluster.
     *
     * @default - Container Insights will be disabled for this cluser.
     * @experimental
     */
    readonly containerInsights?: boolean;
}
/**
 * (experimental) The machine image type.
 *
 * @experimental
 */
export declare enum MachineImageType {
    /**
     * (experimental) Amazon ECS-optimized Amazon Linux 2 AMI.
     *
     * @experimental
     */
    AMAZON_LINUX_2 = 0,
    /**
     * (experimental) Bottlerocket AMI.
     *
     * @experimental
     */
    BOTTLEROCKET = 1
}
/**
 * (experimental) A regional grouping of one or more container instances on which you can run tasks and services.
 *
 * @experimental
 */
export declare class Cluster extends Resource implements ICluster {
    /**
     * (experimental) Import an existing cluster to the stack from its attributes.
     *
     * @experimental
     */
    static fromClusterAttributes(scope: Construct, id: string, attrs: ClusterAttributes): ICluster;
    /**
     * (experimental) Manage the allowed network connections for the cluster with Security Groups.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The VPC associated with the cluster.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The Amazon Resource Name (ARN) that identifies the cluster.
     *
     * @experimental
     */
    readonly clusterArn: string;
    /**
     * (experimental) The name of the cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * The AWS Cloud Map namespace to associate with the cluster.
     */
    private _defaultCloudMapNamespace?;
    /**
     * Specifies whether the cluster has EC2 instance capacity.
     */
    private _hasEc2Capacity;
    /**
     * The autoscaling group for added Ec2 capacity
     */
    private _autoscalingGroup?;
    /**
     * (experimental) Constructs a new instance of the Cluster class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ClusterProps);
    /**
     * (experimental) Add an AWS Cloud Map DNS namespace for this cluster.
     *
     * NOTE: HttpNamespaces are not supported, as ECS always requires a DNSConfig when registering an instance to a Cloud
     * Map service.
     *
     * @experimental
     */
    addDefaultCloudMapNamespace(options: CloudMapNamespaceOptions): cloudmap.INamespace;
    /**
     * (experimental) Getter for namespace added to cluster.
     *
     * @experimental
     */
    get defaultCloudMapNamespace(): cloudmap.INamespace | undefined;
    /**
     * (experimental) This method adds compute capacity to a cluster by creating an AutoScalingGroup with the specified options.
     *
     * Returns the AutoScalingGroup so you can add autoscaling settings to it.
     *
     * @experimental
     */
    addCapacity(id: string, options: AddCapacityOptions): autoscaling.AutoScalingGroup;
    /**
     * (experimental) This method adds compute capacity to a cluster using the specified AutoScalingGroup.
     *
     * @param autoScalingGroup the ASG to add to this cluster.
     * @experimental
     */
    addAutoScalingGroup(autoScalingGroup: autoscaling.AutoScalingGroup, options?: AddAutoScalingGroupCapacityOptions): void;
    /**
     * (experimental) Getter for autoscaling group added to cluster.
     *
     * @experimental
     */
    get autoscalingGroup(): autoscaling.IAutoScalingGroup | undefined;
    /**
     * (experimental) Whether the cluster has EC2 capacity associated with it.
     *
     * @experimental
     */
    get hasEc2Capacity(): boolean;
    /**
     * (experimental) This method returns the CloudWatch metric for this clusters CPU reservation.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricCpuReservation(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) This method returns the CloudWatch metric for this clusters memory reservation.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricMemoryReservation(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) This method returns the specifed CloudWatch metric for this cluster.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * (experimental) ECS-optimized Windows version list.
 *
 * @experimental
 */
export declare enum WindowsOptimizedVersion {
    /**
     * @experimental
     */
    SERVER_2019 = "2019",
    /**
     * @experimental
     */
    SERVER_2016 = "2016"
}
/**
 * (deprecated) The properties that define which ECS-optimized AMI is used.
 *
 * @deprecated see {@link EcsOptimizedImage}
 */
export interface EcsOptimizedAmiProps {
    /**
     * (deprecated) The Amazon Linux generation to use.
     *
     * @default AmazonLinuxGeneration.AmazonLinux2
     * @deprecated
     */
    readonly generation?: ec2.AmazonLinuxGeneration;
    /**
     * (deprecated) The Windows Server version to use.
     *
     * @default none, uses Linux generation
     * @deprecated
     */
    readonly windowsVersion?: WindowsOptimizedVersion;
    /**
     * (deprecated) The ECS-optimized AMI variant to use.
     *
     * @default AmiHardwareType.Standard
     * @deprecated
     */
    readonly hardwareType?: AmiHardwareType;
}
/**
 * (deprecated) Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM.
 *
 * @deprecated see {@link EcsOptimizedImage#amazonLinux}, {@link EcsOptimizedImage#amazonLinux} and {@link EcsOptimizedImage#windows}
 */
export declare class EcsOptimizedAmi implements ec2.IMachineImage {
    private readonly generation?;
    private readonly windowsVersion?;
    private readonly hwType;
    private readonly amiParameterName;
    /**
     * (deprecated) Constructs a new instance of the EcsOptimizedAmi class.
     *
     * @deprecated
     */
    constructor(props?: EcsOptimizedAmiProps);
    /**
     * (deprecated) Return the correct image.
     *
     * @deprecated
     */
    getImage(scope: CoreConstruct): ec2.MachineImageConfig;
}
/**
 * (experimental) Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM.
 *
 * @experimental
 */
export declare class EcsOptimizedImage implements ec2.IMachineImage {
    /**
     * (experimental) Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM.
     *
     * @param hardwareType ECS-optimized AMI variant to use.
     * @experimental
     */
    static amazonLinux2(hardwareType?: AmiHardwareType): EcsOptimizedImage;
    /**
     * (experimental) Construct an Amazon Linux AMI image from the latest ECS Optimized AMI published in SSM.
     *
     * @experimental
     */
    static amazonLinux(): EcsOptimizedImage;
    /**
     * (experimental) Construct a Windows image from the latest ECS Optimized AMI published in SSM.
     *
     * @param windowsVersion Windows Version to use.
     * @experimental
     */
    static windows(windowsVersion: WindowsOptimizedVersion): EcsOptimizedImage;
    private readonly generation?;
    private readonly windowsVersion?;
    private readonly hwType?;
    private readonly amiParameterName;
    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     */
    private constructor();
    /**
     * (experimental) Return the correct image.
     *
     * @experimental
     */
    getImage(scope: CoreConstruct): ec2.MachineImageConfig;
}
/**
 * Amazon ECS variant
 */
export declare enum BottlerocketEcsVariant {
    /**
     * (experimental) Amazon ECS variant.
     *
     * @experimental
     */
    AWS_ECS_1 = "aws-ecs-1"
}
/**
 * (experimental) Properties for BottleRocketImage.
 *
 * @experimental
 */
export interface BottleRocketImageProps {
    /**
     * (experimental) The Amazon ECS variant to use.
     *
     * Only `aws-ecs-1` is currently available
     *
     * @default - BottlerocketEcsVariant.AWS_ECS_1
     * @experimental
     */
    readonly variant?: BottlerocketEcsVariant;
}
/**
 * (experimental) Construct an Bottlerocket image from the latest AMI published in SSM.
 *
 * @experimental
 */
export declare class BottleRocketImage implements ec2.IMachineImage {
    private readonly amiParameterName;
    /**
     * Amazon ECS variant for Bottlerocket AMI
     */
    private readonly variant;
    /**
     * (experimental) Constructs a new instance of the BottleRocketImage class.
     *
     * @experimental
     */
    constructor(props?: BottleRocketImageProps);
    /**
     * (experimental) Return the correct image.
     *
     * @experimental
     */
    getImage(scope: CoreConstruct): ec2.MachineImageConfig;
}
/**
 * (experimental) A regional grouping of one or more container instances on which you can run tasks and services.
 *
 * @experimental
 */
export interface ICluster extends IResource {
    /**
     * (experimental) The name of the cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) that identifies the cluster.
     *
     * @experimental
     * @attribute true
     */
    readonly clusterArn: string;
    /**
     * (experimental) The VPC associated with the cluster.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Manage the allowed network connections for the cluster with Security Groups.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) Specifies whether the cluster has EC2 instance capacity.
     *
     * @experimental
     */
    readonly hasEc2Capacity: boolean;
    /**
     * (experimental) The AWS Cloud Map namespace to associate with the cluster.
     *
     * @experimental
     */
    readonly defaultCloudMapNamespace?: cloudmap.INamespace;
    /**
     * (experimental) The autoscaling group added to the cluster if capacity is associated to the cluster.
     *
     * @experimental
     */
    readonly autoscalingGroup?: autoscaling.IAutoScalingGroup;
}
/**
 * (experimental) The properties to import from the ECS cluster.
 *
 * @experimental
 */
export interface ClusterAttributes {
    /**
     * (experimental) The name of the cluster.
     *
     * @experimental
     */
    readonly clusterName: string;
    /**
     * (experimental) The Amazon Resource Name (ARN) that identifies the cluster.
     *
     * @default Derived from clusterName
     * @experimental
     */
    readonly clusterArn?: string;
    /**
     * (experimental) The VPC associated with the cluster.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) The security groups associated with the container instances registered to the cluster.
     *
     * @experimental
     */
    readonly securityGroups: ec2.ISecurityGroup[];
    /**
     * (experimental) Specifies whether the cluster has EC2 instance capacity.
     *
     * @default true
     * @experimental
     */
    readonly hasEc2Capacity?: boolean;
    /**
     * (experimental) The AWS Cloud Map namespace to associate with the cluster.
     *
     * @default - No default namespace
     * @experimental
     */
    readonly defaultCloudMapNamespace?: cloudmap.INamespace;
    /**
     * (experimental) Autoscaling group added to the cluster if capacity is added.
     *
     * @default - No default autoscaling group
     * @experimental
     */
    readonly autoscalingGroup?: autoscaling.IAutoScalingGroup;
}
/**
 * (experimental) The properties for adding an AutoScalingGroup.
 *
 * @experimental
 */
export interface AddAutoScalingGroupCapacityOptions {
    /**
     * (experimental) Specifies whether the containers can access the container instance role.
     *
     * @default false
     * @experimental
     */
    readonly canContainersAccessInstanceRole?: boolean;
    /**
     * (experimental) The time period to wait before force terminating an instance that is draining.
     *
     * This creates a Lambda function that is used by a lifecycle hook for the
     * AutoScalingGroup that will delay instance termination until all ECS tasks
     * have drained from the instance. Set to 0 to disable task draining.
     *
     * Set to 0 to disable task draining.
     *
     * @default Duration.minutes(5)
     * @experimental
     */
    readonly taskDrainTime?: Duration;
    /**
     * (experimental) Specify whether to enable Automated Draining for Spot Instances running Amazon ECS Services.
     *
     * For more information, see [Using Spot Instances](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-spot.html).
     *
     * @default false
     * @experimental
     */
    readonly spotInstanceDraining?: boolean;
    /**
     * (experimental) If {@link AddAutoScalingGroupCapacityOptions.taskDrainTime} is non-zero, then the ECS cluster creates an SNS Topic to as part of a system to drain instances of tasks when the instance is being shut down. If this property is provided, then this key will be used to encrypt the contents of that SNS Topic. See [SNS Data Encryption](https://docs.aws.amazon.com/sns/latest/dg/sns-data-encryption.html) for more information.
     *
     * @default The SNS Topic will not be encrypted.
     * @experimental
     */
    readonly topicEncryptionKey?: kms.IKey;
    /**
     * (experimental) Specify the machine image type.
     *
     * @default MachineImageType.AMAZON_LINUX_2
     * @experimental
     */
    readonly machineImageType?: MachineImageType;
}
/**
 * (experimental) The properties for adding instance capacity to an AutoScalingGroup.
 *
 * @experimental
 */
export interface AddCapacityOptions extends AddAutoScalingGroupCapacityOptions, autoscaling.CommonAutoScalingGroupProps {
    /**
     * (experimental) The EC2 instance type to use when launching instances into the AutoScalingGroup.
     *
     * @experimental
     */
    readonly instanceType: ec2.InstanceType;
    /**
     * (experimental) The ECS-optimized AMI variant to use.
     *
     * For more information, see
     * [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
     * You must define either `machineImage` or `machineImageType`, not both.
     *
     * @default - Amazon Linux 2
     * @experimental
     */
    readonly machineImage?: ec2.IMachineImage;
}
/**
 * (experimental) The options for creating an AWS Cloud Map namespace.
 *
 * @experimental
 */
export interface CloudMapNamespaceOptions {
    /**
     * (experimental) The name of the namespace, such as example.com.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The type of CloudMap Namespace to create.
     *
     * @default PrivateDns
     * @experimental
     */
    readonly type?: cloudmap.NamespaceType;
    /**
     * (experimental) The VPC to associate the namespace with.
     *
     * This property is required for private DNS namespaces.
     *
     * @default VPC of the cluster for Private DNS Namespace, otherwise none
     * @experimental
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * (experimental) The ECS-optimized AMI variant to use.
 *
 * For more information, see
 * [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 *
 * @experimental
 */
export declare enum AmiHardwareType {
    /**
     * (experimental) Use the standard Amazon ECS-optimized AMI.
     *
     * @experimental
     */
    STANDARD = "Standard",
    /**
     * (experimental) Use the Amazon ECS GPU-optimized AMI.
     *
     * @experimental
     */
    GPU = "GPU",
    /**
     * (experimental) Use the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI.
     *
     * @experimental
     */
    ARM = "ARM64"
}
