import * as ec2 from "../../../aws-ec2";
import * as iam from "../../../aws-iam";
import { IResource, Resource } from "../../../core";
import { Construct } from 'constructs';
import { ContainerDefinition, ContainerDefinitionOptions, PortMapping, Protocol } from '../container-definition';
import { FirelensLogRouter, FirelensLogRouterDefinitionOptions } from '../firelens-log-router';
import { PlacementConstraint } from '../placement';
import { ProxyConfiguration } from '../proxy-configuration/proxy-configuration';
/**
 * (experimental) The interface for all task definitions.
 *
 * @experimental
 */
export interface ITaskDefinition extends IResource {
    /**
     * (experimental) ARN of this task definition.
     *
     * @experimental
     * @attribute true
     */
    readonly taskDefinitionArn: string;
    /**
     * (experimental) Execution role for this task definition.
     *
     * @experimental
     */
    readonly executionRole?: iam.IRole;
    /**
     * (experimental) What launch types this task definition should be compatible with.
     *
     * @experimental
     */
    readonly compatibility: Compatibility;
    /**
     * (experimental) Return true if the task definition can be run on an EC2 cluster.
     *
     * @experimental
     */
    readonly isEc2Compatible: boolean;
    /**
     * (experimental) Return true if the task definition can be run on a Fargate cluster.
     *
     * @experimental
     */
    readonly isFargateCompatible: boolean;
}
/**
 * (experimental) The common properties for all task definitions.
 *
 * For more information, see
 * [Task Definition Parameters](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html).
 *
 * @experimental
 */
export interface CommonTaskDefinitionProps {
    /**
     * (experimental) The name of a family that this task definition is registered to.
     *
     * A family groups multiple versions of a task definition.
     *
     * @default - Automatically generated name.
     * @experimental
     */
    readonly family?: string;
    /**
     * (experimental) The name of the IAM task execution role that grants the ECS agent to call AWS APIs on your behalf.
     *
     * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
     *
     * @default - An execution role will be automatically created if you use ECR images in your task definition.
     * @experimental
     */
    readonly executionRole?: iam.IRole;
    /**
     * (experimental) The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     *
     * @default - A task role is automatically created for you.
     * @experimental
     */
    readonly taskRole?: iam.IRole;
    /**
     * (experimental) The configuration details for the App Mesh proxy.
     *
     * @default - No proxy configuration.
     * @experimental
     */
    readonly proxyConfiguration?: ProxyConfiguration;
    /**
     * (experimental) The list of volume definitions for the task.
     *
     * For more information, see
     * [Task Definition Parameter Volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes).
     *
     * @default - No volumes are passed to the Docker daemon on a container instance.
     * @experimental
     */
    readonly volumes?: Volume[];
}
/**
 * (experimental) The properties for task definitions.
 *
 * @experimental
 */
export interface TaskDefinitionProps extends CommonTaskDefinitionProps {
    /**
     * (experimental) The networking mode to use for the containers in the task.
     *
     * On Fargate, the only supported networking mode is AwsVpc.
     *
     * @default - NetworkMode.Bridge for EC2 tasks, AwsVpc for Fargate tasks.
     * @experimental
     */
    readonly networkMode?: NetworkMode;
    /**
     * (experimental) The placement constraints to use for tasks in the service.
     *
     * You can specify a maximum of 10 constraints per task (this limit includes
     * constraints in the task definition and those specified at run time).
     *
     * Not supported in Fargate.
     *
     * @default - No placement constraints.
     * @experimental
     */
    readonly placementConstraints?: PlacementConstraint[];
    /**
     * (experimental) The task launch type compatiblity requirement.
     *
     * @experimental
     */
    readonly compatibility: Compatibility;
    /**
     * (experimental) The number of cpu units used by the task.
     *
     * If you are using the EC2 launch type, this field is optional and any value can be used.
     * If you are using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of valid values for the memory parameter:
     *
     * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     *
     * @default - CPU units are not specified.
     * @experimental
     */
    readonly cpu?: string;
    /**
     * (experimental) The amount (in MiB) of memory used by the task.
     *
     * If using the EC2 launch type, this field is optional and any value can be used.
     * If using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of valid values for the cpu parameter:
     *
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     *
     * @default - Memory used by task is not specified.
     * @experimental
     */
    readonly memoryMiB?: string;
    /**
     * (experimental) The IPC resource namespace to use for the containers in the task.
     *
     * Not supported in Fargate and Windows containers.
     *
     * @default - IpcMode used by the task is not specified
     * @experimental
     */
    readonly ipcMode?: IpcMode;
    /**
     * (experimental) The process namespace to use for the containers in the task.
     *
     * Not supported in Fargate and Windows containers.
     *
     * @default - PidMode used by the task is not specified
     * @experimental
     */
    readonly pidMode?: PidMode;
}
declare abstract class TaskDefinitionBase extends Resource implements ITaskDefinition {
    abstract readonly compatibility: Compatibility;
    abstract readonly taskDefinitionArn: string;
    abstract readonly executionRole?: iam.IRole;
    /**
     * (experimental) Return true if the task definition can be run on an EC2 cluster.
     *
     * @experimental
     */
    get isEc2Compatible(): boolean;
    /**
     * (experimental) Return true if the task definition can be run on a Fargate cluster.
     *
     * @experimental
     */
    get isFargateCompatible(): boolean;
}
/**
 * (experimental) The base class for all task definitions.
 *
 * @experimental
 */
export declare class TaskDefinition extends TaskDefinitionBase {
    /**
     * (experimental) Imports a task definition from the specified task definition ARN.
     *
     * The task will have a compatibility of EC2+Fargate.
     *
     * @experimental
     */
    static fromTaskDefinitionArn(scope: Construct, id: string, taskDefinitionArn: string): ITaskDefinition;
    /**
     * (experimental) The name of a family that this task definition is registered to.
     *
     * A family groups multiple versions of a task definition.
     *
     * @experimental
     */
    readonly family: string;
    /**
     * (experimental) The full Amazon Resource Name (ARN) of the task definition.
     *
     * @experimental
     * @attribute true
     */
    readonly taskDefinitionArn: string;
    /**
     * (experimental) The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     *
     * @experimental
     */
    readonly taskRole: iam.IRole;
    /**
     * (experimental) The networking mode to use for the containers in the task.
     *
     * @experimental
     */
    readonly networkMode: NetworkMode;
    /**
     * (experimental) Default container for this task.
     *
     * Load balancers will send traffic to this container. The first
     * essential container that is added to this task will become the default
     * container.
     *
     * @experimental
     */
    defaultContainer?: ContainerDefinition;
    /**
     * (experimental) The task launch type compatiblity requirement.
     *
     * @experimental
     */
    readonly compatibility: Compatibility;
    /**
     * (experimental) The container definitions.
     *
     * @experimental
     */
    protected readonly containers: ContainerDefinition[];
    /**
     * All volumes
     */
    private readonly volumes;
    /**
     * Placement constraints for task instances
     */
    private readonly placementConstraints;
    private _executionRole?;
    /**
     * (experimental) Constructs a new instance of the TaskDefinition class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TaskDefinitionProps);
    /**
     * (experimental) Execution role for this task definition.
     *
     * @experimental
     */
    get executionRole(): iam.IRole | undefined;
    private renderVolumes;
    /**
     * Validate the existence of the input target and set default values.
     *
     * @internal
     */
    _validateTarget(options: LoadBalancerTargetOptions): LoadBalancerTarget;
    /**
     * Returns the port range to be opened that match the provided container name and container port.
     *
     * @internal
     */
    _portRangeFromPortMapping(portMapping: PortMapping): ec2.Port;
    /**
     * (experimental) Adds a policy statement to the task IAM role.
     *
     * @experimental
     */
    addToTaskRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Adds a policy statement to the task execution IAM role.
     *
     * @experimental
     */
    addToExecutionRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Adds a new container to the task definition.
     *
     * @experimental
     */
    addContainer(id: string, props: ContainerDefinitionOptions): ContainerDefinition;
    /**
     * (experimental) Adds a firelens log router to the task definition.
     *
     * @experimental
     */
    addFirelensLogRouter(id: string, props: FirelensLogRouterDefinitionOptions): FirelensLogRouter;
    /**
     * Links a container to this task definition.
     * @internal
     */
    _linkContainer(container: ContainerDefinition): void;
    /**
     * (experimental) Adds a volume to the task definition.
     *
     * @experimental
     */
    addVolume(volume: Volume): void;
    /**
     * (experimental) Adds the specified placement constraint to the task definition.
     *
     * @experimental
     */
    addPlacementConstraint(constraint: PlacementConstraint): void;
    /**
     * (experimental) Adds the specified extention to the task definition.
     *
     * Extension can be used to apply a packaged modification to
     * a task definition.
     *
     * @experimental
     */
    addExtension(extension: ITaskDefinitionExtension): void;
    /**
     * (experimental) Creates the task execution IAM role if it doesn't already exist.
     *
     * @experimental
     */
    obtainExecutionRole(): iam.IRole;
    /**
     * (experimental) Validates the task definition.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * Returns the container that match the provided containerName.
     */
    private findContainer;
    private renderNetworkMode;
    private renderContainers;
}
/**
 * (experimental) The networking mode to use for the containers in the task.
 *
 * @experimental
 */
export declare enum NetworkMode {
    /**
     * (experimental) The task's containers do not have external connectivity and port mappings can't be specified in the container definition.
     *
     * @experimental
     */
    NONE = "none",
    /**
     * (experimental) The task utilizes Docker's built-in virtual network which runs inside each container instance.
     *
     * @experimental
     */
    BRIDGE = "bridge",
    /**
     * (experimental) The task is allocated an elastic network interface.
     *
     * @experimental
     */
    AWS_VPC = "awsvpc",
    /**
     * (experimental) The task bypasses Docker's built-in virtual network and maps container ports directly to the EC2 instance's network interface directly.
     *
     * In this mode, you can't run multiple instantiations of the same task on a
     * single container instance when port mappings are used.
     *
     * @experimental
     */
    HOST = "host",
    /**
     * (experimental) The task utilizes NAT network mode required by Windows containers.
     *
     * This is the only supported network mode for Windows containers. For more information, see
     * [Task Definition Parameters](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#network_mode).
     *
     * @experimental
     */
    NAT = "nat"
}
/**
 * (experimental) The IPC resource namespace to use for the containers in the task.
 *
 * @experimental
 */
export declare enum IpcMode {
    /**
     * (experimental) If none is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance.
     *
     * @experimental
     */
    NONE = "none",
    /**
     * (experimental) If host is specified, then all containers within the tasks that specified the host IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance.
     *
     * @experimental
     */
    HOST = "host",
    /**
     * (experimental) If task is specified, all containers within the specified task share the same IPC resources.
     *
     * @experimental
     */
    TASK = "task"
}
/**
 * (experimental) The process namespace to use for the containers in the task.
 *
 * @experimental
 */
export declare enum PidMode {
    /**
     * (experimental) If host is specified, then all containers within the tasks that specified the host PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
     *
     * @experimental
     */
    HOST = "host",
    /**
     * (experimental) If task is specified, all containers within the specified task share the same process namespace.
     *
     * @experimental
     */
    TASK = "task"
}
/**
 * (experimental) A data volume used in a task definition.
 *
 * For tasks that use a Docker volume, specify a DockerVolumeConfiguration.
 * For tasks that use a bind mount host volume, specify a host and optional sourcePath.
 *
 * For more information, see [Using Data Volumes in Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html).
 *
 * @experimental
 */
export interface Volume {
    /**
     * (experimental) This property is specified when you are using bind mount host volumes.
     *
     * Bind mount host volumes are supported when you are using either the EC2 or Fargate launch types.
     * The contents of the host parameter determine whether your bind mount host volume persists on the
     * host container instance and where it is stored. If the host parameter is empty, then the Docker
     * daemon assigns a host path for your data volume. However, the data is not guaranteed to persist
     * after the containers associated with it stop running.
     *
     * @experimental
     */
    readonly host?: Host;
    /**
     * (experimental) The name of the volume.
     *
     * Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
     * This name is referenced in the sourceVolume parameter of container definition mountPoints.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) This property is specified when you are using Docker volumes.
     *
     * Docker volumes are only supported when you are using the EC2 launch type.
     * Windows containers only support the use of the local driver.
     * To use bind mounts, specify a host instead.
     *
     * @experimental
     */
    readonly dockerVolumeConfiguration?: DockerVolumeConfiguration;
    /**
     * (experimental) This property is specified when you are using Amazon EFS.
     *
     * When specifying Amazon EFS volumes in tasks using the Fargate launch type,
     * Fargate creates a supervisor container that is responsible for managing the Amazon EFS volume.
     * The supervisor container uses a small amount of the task's memory.
     * The supervisor container is visible when querying the task metadata version 4 endpoint,
     * but is not visible in CloudWatch Container Insights.
     *
     * @default No Elastic FileSystem is setup
     * @experimental
     */
    readonly efsVolumeConfiguration?: EfsVolumeConfiguration;
}
/**
 * (experimental) The details on a container instance bind mount host volume.
 *
 * @experimental
 */
export interface Host {
    /**
     * (experimental) Specifies the path on the host container instance that is presented to the container.
     *
     * If the sourcePath value does not exist on the host container instance, the Docker daemon creates it.
     * If the location does exist, the contents of the source path folder are exported.
     *
     * This property is not supported for tasks that use the Fargate launch type.
     *
     * @experimental
     */
    readonly sourcePath?: string;
}
/**
 * Properties for an ECS target.
 *
 * @internal
 */
export interface LoadBalancerTarget {
    /**
     * The name of the container.
     */
    readonly containerName: string;
    /**
     * The port mapping of the target.
     */
    readonly portMapping: PortMapping;
}
/**
 * (experimental) Properties for defining an ECS target.
 *
 * The port mapping for it must already have been created through addPortMapping().
 *
 * @experimental
 */
export interface LoadBalancerTargetOptions {
    /**
     * (experimental) The name of the container.
     *
     * @experimental
     */
    readonly containerName: string;
    /**
     * (experimental) The port number of the container.
     *
     * Only applicable when using application/network load balancers.
     *
     * @default - Container port of the first added port mapping.
     * @experimental
     */
    readonly containerPort?: number;
    /**
     * (experimental) The protocol used for the port mapping.
     *
     * Only applicable when using application load balancers.
     *
     * @default Protocol.TCP
     * @experimental
     */
    readonly protocol?: Protocol;
}
/**
 * (experimental) The configuration for a Docker volume.
 *
 * Docker volumes are only supported when you are using the EC2 launch type.
 *
 * @experimental
 */
export interface DockerVolumeConfiguration {
    /**
     * (experimental) Specifies whether the Docker volume should be created if it does not already exist.
     *
     * If true is specified, the Docker volume will be created for you.
     *
     * @default false
     * @experimental
     */
    readonly autoprovision?: boolean;
    /**
     * (experimental) The Docker volume driver to use.
     *
     * @experimental
     */
    readonly driver: string;
    /**
     * (experimental) A map of Docker driver-specific options passed through.
     *
     * @default No options
     * @experimental
     */
    readonly driverOpts?: {
        [key: string]: string;
    };
    /**
     * (experimental) Custom metadata to add to your Docker volume.
     *
     * @default No labels
     * @experimental
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * (experimental) The scope for the Docker volume that determines its lifecycle.
     *
     * @experimental
     */
    readonly scope: Scope;
}
/**
 * (experimental) The authorization configuration details for the Amazon EFS file system.
 *
 * @experimental
 */
export interface AuthorizationConfig {
    /**
     * (experimental) The access point ID to use.
     *
     * If an access point is specified, the root directory value will be
     * relative to the directory set for the access point.
     * If specified, transit encryption must be enabled in the EFSVolumeConfiguration.
     *
     * @default No id
     * @experimental
     */
    readonly accessPointId?: string;
    /**
     * (experimental) Whether or not to use the Amazon ECS task IAM role defined in a task definition when mounting the Amazon EFS file system.
     *
     * If enabled, transit encryption must be enabled in the EFSVolumeConfiguration.
     *
     * Valid values: ENABLED | DISABLED
     *
     * @default If this parameter is omitted, the default value of DISABLED is used.
     * @experimental
     */
    readonly iam?: string;
}
/**
 * (experimental) The configuration for an Elastic FileSystem volume.
 *
 * @experimental
 */
export interface EfsVolumeConfiguration {
    /**
     * (experimental) The Amazon EFS file system ID to use.
     *
     * @experimental
     */
    readonly fileSystemId: string;
    /**
     * (experimental) The directory within the Amazon EFS file system to mount as the root directory inside the host.
     *
     * Specifying / will have the same effect as omitting this parameter.
     *
     * @default The root of the Amazon EFS volume
     * @experimental
     */
    readonly rootDirectory?: string;
    /**
     * (experimental) Whether or not to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
     *
     * Transit encryption must be enabled if Amazon EFS IAM authorization is used.
     *
     * Valid values: ENABLED | DISABLED
     *
     * @default DISABLED
     * @experimental
     */
    readonly transitEncryption?: string;
    /**
     * (experimental) The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
     *
     * EFS mount helper uses.
     *
     * @default Port selection strategy that the Amazon EFS mount helper uses.
     * @experimental
     */
    readonly transitEncryptionPort?: number;
    /**
     * (experimental) The authorization configuration details for the Amazon EFS file system.
     *
     * @default No configuration.
     * @experimental
     */
    readonly authorizationConfig?: AuthorizationConfig;
}
/**
 * (experimental) The scope for the Docker volume that determines its lifecycle.
 *
 * Docker volumes that are scoped to a task are automatically provisioned when the task starts and destroyed when the task stops.
 * Docker volumes that are scoped as shared persist after the task stops.
 *
 * @experimental
 */
export declare enum Scope {
    /**
     * (experimental) Docker volumes that are scoped to a task are automatically provisioned when the task starts and destroyed when the task stops.
     *
     * @experimental
     */
    TASK = "task",
    /**
     * (experimental) Docker volumes that are scoped as shared persist after the task stops.
     *
     * @experimental
     */
    SHARED = "shared"
}
/**
 * (experimental) The task launch type compatibility requirement.
 *
 * @experimental
 */
export declare enum Compatibility {
    /**
     * (experimental) The task should specify the EC2 launch type.
     *
     * @experimental
     */
    EC2 = 0,
    /**
     * (experimental) The task should specify the Fargate launch type.
     *
     * @experimental
     */
    FARGATE = 1,
    /**
     * (experimental) The task can specify either the EC2 or Fargate launch types.
     *
     * @experimental
     */
    EC2_AND_FARGATE = 2
}
/**
 * (experimental) An extension for Task Definitions.
 *
 * Classes that want to make changes to a TaskDefinition (such as
 * adding helper containers) can implement this interface, and can
 * then be "added" to a TaskDefinition like so:
 *
 *     taskDefinition.addExtension(new MyExtension("some_parameter"));
 *
 * @experimental
 */
export interface ITaskDefinitionExtension {
    /**
     * (experimental) Apply the extension to the given TaskDefinition.
     *
     * @param taskDefinition [disable-awslint:ref-via-interface].
     * @experimental
     */
    extend(taskDefinition: TaskDefinition): void;
}
export {};
