import * as appscaling from "../../../aws-applicationautoscaling";
import * as cloudwatch from "../../../aws-cloudwatch";
import * as elbv2 from "../../../aws-elasticloadbalancingv2";
import { Construct } from 'constructs';
/**
 * (experimental) The properties of a scalable attribute representing task count.
 *
 * @experimental
 */
export interface ScalableTaskCountProps extends appscaling.BaseScalableAttributeProps {
}
/**
 * (experimental) The scalable attribute representing task count.
 *
 * @experimental
 */
export declare class ScalableTaskCount extends appscaling.BaseScalableAttribute {
    /**
     * (experimental) Constructs a new instance of the ScalableTaskCount class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ScalableTaskCountProps);
    /**
     * (experimental) Scales in or out based on a specified scheduled time.
     *
     * @experimental
     */
    scaleOnSchedule(id: string, props: appscaling.ScalingSchedule): void;
    /**
     * (experimental) Scales in or out based on a specified metric value.
     *
     * @experimental
     */
    scaleOnMetric(id: string, props: appscaling.BasicStepScalingPolicyProps): void;
    /**
     * (experimental) Scales in or out to achieve a target CPU utilization.
     *
     * @experimental
     */
    scaleOnCpuUtilization(id: string, props: CpuUtilizationScalingProps): void;
    /**
     * (experimental) Scales in or out to achieve a target memory utilization.
     *
     * @experimental
     */
    scaleOnMemoryUtilization(id: string, props: MemoryUtilizationScalingProps): void;
    /**
     * (experimental) Scales in or out to achieve a target Application Load Balancer request count per target.
     *
     * @experimental
     */
    scaleOnRequestCount(id: string, props: RequestCountScalingProps): void;
    /**
     * (experimental) Scales in or out to achieve a target on a custom metric.
     *
     * @experimental
     */
    scaleToTrackCustomMetric(id: string, props: TrackCustomMetricProps): void;
}
/**
 * (experimental) The properties for enabling scaling based on CPU utilization.
 *
 * @experimental
 */
export interface CpuUtilizationScalingProps extends appscaling.BaseTargetTrackingProps {
    /**
     * (experimental) The target value for CPU utilization across all tasks in the service.
     *
     * @experimental
     */
    readonly targetUtilizationPercent: number;
}
/**
 * (experimental) The properties for enabling scaling based on memory utilization.
 *
 * @experimental
 */
export interface MemoryUtilizationScalingProps extends appscaling.BaseTargetTrackingProps {
    /**
     * (experimental) The target value for memory utilization across all tasks in the service.
     *
     * @experimental
     */
    readonly targetUtilizationPercent: number;
}
/**
 * (experimental) The properties for enabling scaling based on Application Load Balancer (ALB) request counts.
 *
 * @experimental
 */
export interface RequestCountScalingProps extends appscaling.BaseTargetTrackingProps {
    /**
     * (experimental) The number of ALB requests per target.
     *
     * @experimental
     */
    readonly requestsPerTarget: number;
    /**
     * (experimental) The ALB target group name.
     *
     * @experimental
     */
    readonly targetGroup: elbv2.ApplicationTargetGroup;
}
/**
 * (experimental) The properties for enabling target tracking scaling based on a custom CloudWatch metric.
 *
 * @experimental
 */
export interface TrackCustomMetricProps extends appscaling.BaseTargetTrackingProps {
    /**
     * (experimental) The custom CloudWatch metric to track.
     *
     * The metric must represent utilization; that is, you will always get the following behavior:
     *
     * - metric > targetValue => scale out
     * - metric < targetValue => scale in
     *
     * @experimental
     */
    readonly metric: cloudwatch.IMetric;
    /**
     * (experimental) The target value for the custom CloudWatch metric.
     *
     * @experimental
     */
    readonly targetValue: number;
}
