import * as appscaling from "../../../aws-applicationautoscaling";
import * as cloudwatch from "../../../aws-cloudwatch";
import * as ec2 from "../../../aws-ec2";
import * as elb from "../../../aws-elasticloadbalancing";
import * as elbv2 from "../../../aws-elasticloadbalancingv2";
import * as cloudmap from "../../../aws-servicediscovery";
import { Duration, IResource, Resource } from "../../../core";
import { Construct } from 'constructs';
import { LoadBalancerTargetOptions, TaskDefinition } from '../base/task-definition';
import { ICluster } from '../cluster';
import { Protocol } from '../container-definition';
import { CfnService } from '../ecs.generated';
import { ScalableTaskCount } from './scalable-task-count';
/**
 * (experimental) The interface for a service.
 *
 * @experimental
 */
export interface IService extends IResource {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceArn: string;
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceName: string;
}
/**
 * (experimental) The deployment controller to use for the service.
 *
 * @experimental
 */
export interface DeploymentController {
    /**
     * (experimental) The deployment controller type to use.
     *
     * @default DeploymentControllerType.ECS
     * @experimental
     */
    readonly type?: DeploymentControllerType;
}
/**
 * @experimental
 */
export interface EcsTarget {
    /**
     * (experimental) The name of the container.
     *
     * @experimental
     */
    readonly containerName: string;
    /**
     * (experimental) The port number of the container.
     *
     * Only applicable when using application/network load balancers.
     *
     * @default - Container port of the first added port mapping.
     * @experimental
     */
    readonly containerPort?: number;
    /**
     * (experimental) The protocol used for the port mapping.
     *
     * Only applicable when using application load balancers.
     *
     * @default Protocol.TCP
     * @experimental
     */
    readonly protocol?: Protocol;
    /**
     * (experimental) ID for a target group to be created.
     *
     * @experimental
     */
    readonly newTargetGroupId: string;
    /**
     * (experimental) Listener and properties for adding target group to the listener.
     *
     * @experimental
     */
    readonly listener: ListenerConfig;
}
/**
 * (experimental) Interface for ECS load balancer target.
 *
 * @experimental
 */
export interface IEcsLoadBalancerTarget extends elbv2.IApplicationLoadBalancerTarget, elbv2.INetworkLoadBalancerTarget, elb.ILoadBalancerTarget {
}
/**
 * (experimental) The properties for the base Ec2Service or FargateService service.
 *
 * @experimental
 */
export interface BaseServiceOptions {
    /**
     * (experimental) The name of the cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     *
     * @default 1
     * @experimental
     */
    readonly desiredCount?: number;
    /**
     * (experimental) The name of the service.
     *
     * @default - CloudFormation-generated name.
     * @experimental
     */
    readonly serviceName?: string;
    /**
     * (experimental) The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     *
     * @default - 100 if daemon, otherwise 200
     * @experimental
     */
    readonly maxHealthyPercent?: number;
    /**
     * (experimental) The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     *
     * @default - 0 if daemon, otherwise 50
     * @experimental
     */
    readonly minHealthyPercent?: number;
    /**
     * (experimental) The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     *
     * @default - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
     * @experimental
     */
    readonly healthCheckGracePeriod?: Duration;
    /**
     * (experimental) The options for configuring an Amazon ECS service to use service discovery.
     *
     * @default - AWS Cloud Map service discovery is not enabled.
     * @experimental
     */
    readonly cloudMapOptions?: CloudMapOptions;
    /**
     * (experimental) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     *
     * Valid values are: PropagatedTagSource.SERVICE, PropagatedTagSource.TASK_DEFINITION or PropagatedTagSource.NONE
     *
     * @default PropagatedTagSource.NONE
     * @experimental
     */
    readonly propagateTags?: PropagatedTagSource;
    /**
     * (experimental) Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     *
     * For more information, see
     * [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
     *
     * @default false
     * @experimental
     */
    readonly enableECSManagedTags?: boolean;
    /**
     * (experimental) Specifies which deployment controller to use for the service.
     *
     * For more information, see
     * [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html)
     *
     * @default - Rolling update (ECS)
     * @experimental
     */
    readonly deploymentController?: DeploymentController;
}
/**
 * (experimental) Complete base service properties that are required to be supplied by the implementation of the BaseService class.
 *
 * @experimental
 */
export interface BaseServiceProps extends BaseServiceOptions {
    /**
     * (experimental) The launch type on which to run your service.
     *
     * Valid values are: LaunchType.ECS or LaunchType.FARGATE
     *
     * @experimental
     */
    readonly launchType: LaunchType;
}
/**
 * (experimental) Base class for configuring listener when registering targets.
 *
 * @experimental
 */
export declare abstract class ListenerConfig {
    /**
     * (experimental) Create a config for adding target group to ALB listener.
     *
     * @experimental
     */
    static applicationListener(listener: elbv2.ApplicationListener, props?: elbv2.AddApplicationTargetsProps): ListenerConfig;
    /**
     * (experimental) Create a config for adding target group to NLB listener.
     *
     * @experimental
     */
    static networkListener(listener: elbv2.NetworkListener, props?: elbv2.AddNetworkTargetsProps): ListenerConfig;
    /**
     * (experimental) Create and attach a target group to listener.
     *
     * @experimental
     */
    abstract addTargets(id: string, target: LoadBalancerTargetOptions, service: BaseService): void;
}
/**
 * (experimental) The interface for BaseService.
 *
 * @experimental
 */
export interface IBaseService extends IService {
    /**
     * (experimental) The cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
}
/**
 * (experimental) The base class for Ec2Service and FargateService services.
 *
 * @experimental
 */
export declare abstract class BaseService extends Resource implements IBaseService, elbv2.IApplicationLoadBalancerTarget, elbv2.INetworkLoadBalancerTarget, elb.ILoadBalancerTarget {
    /**
     * (experimental) The security groups which manage the allowed network traffic for the service.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the service.
     *
     * @experimental
     */
    readonly serviceArn: string;
    /**
     * (experimental) The name of the service.
     *
     * @experimental
     * @attribute true
     */
    readonly serviceName: string;
    /**
     * (experimental) The task definition to use for tasks in the service.
     *
     * @experimental
     */
    readonly taskDefinition: TaskDefinition;
    /**
     * (experimental) The cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The details of the AWS Cloud Map service.
     *
     * @experimental
     */
    protected cloudmapService?: cloudmap.Service;
    /**
     * (experimental) A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     *
     * @experimental
     */
    protected loadBalancers: CfnService.LoadBalancerProperty[];
    /**
     * (experimental) A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     *
     * @experimental
     */
    protected networkConfiguration?: CfnService.NetworkConfigurationProperty;
    /**
     * (experimental) The details of the service discovery registries to assign to this service.
     *
     * For more information, see Service Discovery.
     *
     * @experimental
     */
    protected serviceRegistries: CfnService.ServiceRegistryProperty[];
    private readonly resource;
    private scalableTaskCount?;
    /**
     * (experimental) Constructs a new instance of the BaseService class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BaseServiceProps, additionalProps: any, taskDefinition: TaskDefinition);
    /**
     * (experimental) The CloudMap service created for this service, if any.
     *
     * @experimental
     */
    get cloudMapService(): cloudmap.IService | undefined;
    /**
     * (experimental) This method is called to attach this service to an Application Load Balancer.
     *
     * Don't call this function directly. Instead, call `listener.addTargets()`
     * to add this service to a load balancer.
     *
     * @experimental
     */
    attachToApplicationTargetGroup(targetGroup: elbv2.IApplicationTargetGroup): elbv2.LoadBalancerTargetProps;
    /**
     * (experimental) Registers the service as a target of a Classic Load Balancer (CLB).
     *
     * Don't call this. Call `loadBalancer.addTarget()` instead.
     *
     * @experimental
     */
    attachToClassicLB(loadBalancer: elb.LoadBalancer): void;
    /**
     * (experimental) Return a load balancing target for a specific container and port.
     *
     * Use this function to create a load balancer target if you want to load balance to
     * another container than the first essential container or the first mapped port on
     * the container.
     *
     * Use the return value of this function where you would normally use a load balancer
     * target, instead of the `Service` object itself.
     *
     * @experimental
     * @example
     *
     * listener.addTargets('ECS', {
     *   port: 80,
     *   targets: [service.loadBalancerTarget({
     *     containerName: 'MyContainer',
     *     containerPort: 1234,
     *   })],
     * });
     */
    loadBalancerTarget(options: LoadBalancerTargetOptions): IEcsLoadBalancerTarget;
    /**
     * (experimental) Use this function to create all load balancer targets to be registered in this service, add them to target groups, and attach target groups to listeners accordingly.
     *
     * Alternatively, you can use `listener.addTargets()` to create targets and add them to target groups.
     *
     * @experimental
     * @example
     *
     * service.registerLoadBalancerTargets(
     *   {
     *     containerName: 'web',
     *     containerPort: 80,
     *     newTargetGroupId: 'ECS',
     *     listener: ecs.ListenerConfig.applicationListener(listener, {
     *       protocol: elbv2.ApplicationProtocol.HTTPS
     *     }),
     *   },
     * )
     */
    registerLoadBalancerTargets(...targets: EcsTarget[]): void;
    /**
     * (experimental) This method is called to attach this service to a Network Load Balancer.
     *
     * Don't call this function directly. Instead, call `listener.addTargets()`
     * to add this service to a load balancer.
     *
     * @experimental
     */
    attachToNetworkTargetGroup(targetGroup: elbv2.INetworkTargetGroup): elbv2.LoadBalancerTargetProps;
    /**
     * (experimental) An attribute representing the minimum and maximum task count for an AutoScalingGroup.
     *
     * @experimental
     */
    autoScaleTaskCount(props: appscaling.EnableScalingProps): ScalableTaskCount;
    /**
     * (experimental) Enable CloudMap service discovery for the service.
     *
     * @returns The created CloudMap service
     * @experimental
     */
    enableCloudMap(options: CloudMapOptions): cloudmap.Service;
    /**
     * (experimental) This method returns the specified CloudWatch metric name for this service.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) This method returns the CloudWatch metric for this clusters memory utilization.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricMemoryUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) This method returns the CloudWatch metric for this clusters CPU utilization.
     *
     * @default average over 5 minutes
     * @experimental
     */
    metricCpuUtilization(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) This method is called to create a networkConfiguration.
     *
     * @deprecated use configureAwsVpcNetworkingWithSecurityGroups instead.
     */
    protected configureAwsVpcNetworking(vpc: ec2.IVpc, assignPublicIp?: boolean, vpcSubnets?: ec2.SubnetSelection, securityGroup?: ec2.ISecurityGroup): void;
    /**
     * (experimental) This method is called to create a networkConfiguration.
     *
     * @experimental
     */
    protected configureAwsVpcNetworkingWithSecurityGroups(vpc: ec2.IVpc, assignPublicIp?: boolean, vpcSubnets?: ec2.SubnetSelection, securityGroups?: ec2.ISecurityGroup[]): void;
    private renderServiceRegistry;
    /**
     * Shared logic for attaching to an ELB
     */
    private attachToELB;
    /**
     * Shared logic for attaching to an ELBv2
     */
    private attachToELBv2;
    private get defaultLoadBalancerTarget();
    /**
     * Generate the role that will be used for autoscaling this service
     */
    private makeAutoScalingRole;
    /**
     * Associate Service Discovery (Cloud Map) service
     */
    private addServiceRegistry;
    /**
     *  Return the default grace period when load balancers are configured and
     *  healthCheckGracePeriod is not already set
     */
    private evaluateHealthGracePeriod;
}
/**
 * (experimental) The options to enabling AWS Cloud Map for an Amazon ECS service.
 *
 * @experimental
 */
export interface CloudMapOptions {
    /**
     * (experimental) The name of the Cloud Map service to attach to the ECS service.
     *
     * @default CloudFormation-generated name
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) The service discovery namespace for the Cloud Map service to attach to the ECS service.
     *
     * @default - the defaultCloudMapNamespace associated to the cluster
     * @experimental
     */
    readonly cloudMapNamespace?: cloudmap.INamespace;
    /**
     * (experimental) The DNS record type that you want AWS Cloud Map to create.
     *
     * The supported record types are A or SRV.
     *
     * @default - DnsRecordType.A if TaskDefinition.networkMode = AWS_VPC, otherwise DnsRecordType.SRV
     * @experimental
     */
    readonly dnsRecordType?: cloudmap.DnsRecordType.A | cloudmap.DnsRecordType.SRV;
    /**
     * (experimental) The amount of time that you want DNS resolvers to cache the settings for this record.
     *
     * @default 60
     * @experimental
     */
    readonly dnsTtl?: Duration;
    /**
     * (experimental) The number of 30-second intervals that you want Cloud Map to wait after receiving an UpdateInstanceCustomHealthStatus request before it changes the health status of a service instance.
     *
     * NOTE: This is used for HealthCheckCustomConfig
     *
     * @experimental
     */
    readonly failureThreshold?: number;
}
/**
 * (experimental) The launch type of an ECS service.
 *
 * @experimental
 */
export declare enum LaunchType {
    /**
     * (experimental) The service will be launched using the EC2 launch type.
     *
     * @experimental
     */
    EC2 = "EC2",
    /**
     * (experimental) The service will be launched using the FARGATE launch type.
     *
     * @experimental
     */
    FARGATE = "FARGATE"
}
/**
 * (experimental) The deployment controller type to use for the service.
 *
 * @experimental
 */
export declare enum DeploymentControllerType {
    /**
     * (experimental) The rolling update (ECS) deployment type involves replacing the current running version of the container with the latest version.
     *
     * @experimental
     */
    ECS = "ECS",
    /**
     * (experimental) The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment model powered by AWS CodeDeploy.
     *
     * @experimental
     */
    CODE_DEPLOY = "CODE_DEPLOY",
    /**
     * (experimental) The external (EXTERNAL) deployment type enables you to use any third-party deployment controller.
     *
     * @experimental
     */
    EXTERNAL = "EXTERNAL"
}
/**
 * (experimental) Propagate tags from either service or task definition.
 *
 * @experimental
 */
export declare enum PropagatedTagSource {
    /**
     * (experimental) Propagate tags from service.
     *
     * @experimental
     */
    SERVICE = "SERVICE",
    /**
     * (experimental) Propagate tags from task definition.
     *
     * @experimental
     */
    TASK_DEFINITION = "TASK_DEFINITION",
    /**
     * (experimental) Do not propagate.
     *
     * @experimental
     */
    NONE = "NONE"
}
