"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledFargateTask = void 0;
const aws_ecs_1 = require("../../../aws-ecs"); // Automatically re-written from '@aws-cdk/aws-ecs'
const scheduled_task_base_1 = require("../base/scheduled-task-base");
/**
 * (experimental) A scheduled Fargate task that will be initiated off of CloudWatch Events.
 *
 * @experimental
 */
class ScheduledFargateTask extends scheduled_task_base_1.ScheduledTaskBase {
    /**
     * (experimental) Constructs a new instance of the ScheduledFargateTask class.
     *
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        if (props.scheduledFargateTaskDefinitionOptions && props.scheduledFargateTaskImageOptions) {
            throw new Error('You must specify either a scheduledFargateTaskDefinitionOptions or scheduledFargateTaskOptions, not both.');
        }
        else if (props.scheduledFargateTaskDefinitionOptions) {
            this.taskDefinition = props.scheduledFargateTaskDefinitionOptions.taskDefinition;
        }
        else if (props.scheduledFargateTaskImageOptions) {
            const taskImageOptions = props.scheduledFargateTaskImageOptions;
            this.taskDefinition = new aws_ecs_1.FargateTaskDefinition(this, 'ScheduledTaskDef', {
                memoryLimitMiB: taskImageOptions.memoryLimitMiB || 512,
                cpu: taskImageOptions.cpu || 256,
            });
            this.taskDefinition.addContainer('ScheduledContainer', {
                image: taskImageOptions.image,
                command: taskImageOptions.command,
                environment: taskImageOptions.environment,
                secrets: taskImageOptions.secrets,
                logging: taskImageOptions.logDriver !== undefined ? taskImageOptions.logDriver : this.createAWSLogDriver(this.node.id),
            });
        }
        else {
            throw new Error('You must specify one of: taskDefinition or image');
        }
        this.addTaskDefinitionToEventTarget(this.taskDefinition);
    }
}
exports.ScheduledFargateTask = ScheduledFargateTask;
//# sourceMappingURL=data:application/json;base64,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