import { FargatePlatformVersion, FargateService, FargateTaskDefinition } from "../../../aws-ecs";
import { Construct } from 'constructs';
import { QueueProcessingServiceBase, QueueProcessingServiceBaseProps } from '../base/queue-processing-service-base';
/**
 * (experimental) The properties for the QueueProcessingFargateService service.
 *
 * @experimental
 */
export interface QueueProcessingFargateServiceProps extends QueueProcessingServiceBaseProps {
    /**
     * (experimental) The number of cpu units used by the task.
     *
     * Valid values, which determines your range of valid values for the memory parameter:
     *
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     *
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     *
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     *
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     *
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     *
     * This default is set in the underlying FargateTaskDefinition construct.
     *
     * @default 256
     * @experimental
     */
    readonly cpu?: number;
    /**
     * (experimental) The amount (in MiB) of memory used by the task.
     *
     * This field is required and you must use one of the following values, which determines your range of valid values
     * for the cpu parameter:
     *
     * 0.5GB, 1GB, 2GB - Available cpu values: 256 (.25 vCPU)
     *
     * 1GB, 2GB, 3GB, 4GB - Available cpu values: 512 (.5 vCPU)
     *
     * 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB - Available cpu values: 1024 (1 vCPU)
     *
     * Between 4GB and 16GB in 1GB increments - Available cpu values: 2048 (2 vCPU)
     *
     * Between 8GB and 30GB in 1GB increments - Available cpu values: 4096 (4 vCPU)
     *
     * This default is set in the underlying FargateTaskDefinition construct.
     *
     * @default 512
     * @experimental
     */
    readonly memoryLimitMiB?: number;
    /**
     * (experimental) The platform version on which to run your service.
     *
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
     * in the Amazon Elastic Container Service Developer Guide.
     *
     * @default Latest
     * @experimental
     */
    readonly platformVersion?: FargatePlatformVersion;
}
/**
 * (experimental) Class to create a queue processing Fargate service.
 *
 * @experimental
 */
export declare class QueueProcessingFargateService extends QueueProcessingServiceBase {
    /**
     * (experimental) The Fargate service in this construct.
     *
     * @experimental
     */
    readonly service: FargateService;
    /**
     * (experimental) The Fargate task definition in this construct.
     *
     * @experimental
     */
    readonly taskDefinition: FargateTaskDefinition;
    /**
     * (experimental) Constructs a new instance of the QueueProcessingFargateService class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: QueueProcessingFargateServiceProps);
}
