import { Schedule } from "../../../aws-applicationautoscaling";
import { IVpc, SubnetSelection } from "../../../aws-ec2";
import { AwsLogDriver, Cluster, ContainerImage, ICluster, LogDriver, Secret, TaskDefinition } from "../../../aws-ecs";
import { Rule } from "../../../aws-events";
import { EcsTask } from "../../../aws-events-targets";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../../core";
/**
 * (experimental) The properties for the base ScheduledEc2Task or ScheduledFargateTask task.
 *
 * @experimental
 */
export interface ScheduledTaskBaseProps {
    /**
     * (experimental) The name of the cluster that hosts the service.
     *
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     *
     * @default - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     * @experimental
     */
    readonly cluster?: ICluster;
    /**
     * (experimental) The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     *
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     *
     * @default - uses the VPC defined in the cluster or creates a new VPC.
     * @experimental
     */
    readonly vpc?: IVpc;
    /**
     * (experimental) The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
     *
     * For more information, see
     * [Schedule Expression Syntax for Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
     * in the Amazon CloudWatch User Guide.
     *
     * @experimental
     */
    readonly schedule: Schedule;
    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     *
     * @default 1
     * @experimental
     */
    readonly desiredTaskCount?: number;
    /**
     * (experimental) In what subnets to place the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     * @experimental
     */
    readonly subnetSelection?: SubnetSelection;
}
/**
 * @experimental
 */
export interface ScheduledTaskImageProps {
    /**
     * (experimental) The image used to start a container.
     *
     * Image or taskDefinition must be specified, but not both.
     *
     * @default - none
     * @experimental
     */
    readonly image: ContainerImage;
    /**
     * (experimental) The command that is passed to the container.
     *
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     *
     * @default - CMD value built into container image.
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The environment variables to pass to the container.
     *
     * @default none
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The secret to expose to the container as an environment variable.
     *
     * @default - No secret environment variables.
     * @experimental
     */
    readonly secrets?: {
        [key: string]: Secret;
    };
    /**
     * (experimental) The log driver to use.
     *
     * @default - AwsLogDriver if enableLogging is true
     * @experimental
     */
    readonly logDriver?: LogDriver;
}
/**
 * (experimental) The base class for ScheduledEc2Task and ScheduledFargateTask tasks.
 *
 * @experimental
 */
export declare abstract class ScheduledTaskBase extends CoreConstruct {
    /**
     * (experimental) The name of the cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     *
     * The minimum value is 1
     *
     * @experimental
     */
    readonly desiredTaskCount: number;
    /**
     * (experimental) In what subnets to place the task's ENIs.
     *
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     *
     * @default Private subnets
     * @experimental
     */
    readonly subnetSelection: SubnetSelection;
    /**
     * (experimental) The CloudWatch Events rule for the service.
     *
     * @experimental
     */
    readonly eventRule: Rule;
    /**
     * (experimental) Constructs a new instance of the ScheduledTaskBase class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ScheduledTaskBaseProps);
    /**
     * (experimental) Create an ECS task using the task definition provided and add it to the scheduled event rule.
     *
     * @param taskDefinition the TaskDefinition to add to the event rule.
     * @experimental
     */
    protected addTaskDefinitionToEventTarget(taskDefinition: TaskDefinition): EcsTask;
    /**
     * (experimental) Returns the default cluster.
     *
     * @experimental
     */
    protected getDefaultCluster(scope: CoreConstruct, vpc?: IVpc): Cluster;
    /**
     * (experimental) Create an AWS Log Driver with the provided streamPrefix.
     *
     * @param prefix the Cloudwatch logging prefix.
     * @experimental
     */
    protected createAWSLogDriver(prefix: string): AwsLogDriver;
}
