import { IVpc } from "../../../aws-ec2";
import { AwsLogDriver, BaseService, CloudMapOptions, Cluster, ContainerImage, ICluster, LogDriver, PropagatedTagSource, Secret } from "../../../aws-ecs";
import { INetworkLoadBalancer, NetworkListener, NetworkLoadBalancer, NetworkTargetGroup } from "../../../aws-elasticloadbalancingv2";
import { IRole } from "../../../aws-iam";
import { IHostedZone } from "../../../aws-route53";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Describes the type of DNS record the service should create.
 *
 * @experimental
 */
export declare enum NetworkLoadBalancedServiceRecordType {
    /**
     * (experimental) Create Route53 A Alias record.
     *
     * @experimental
     */
    ALIAS = 0,
    /**
     * (experimental) Create a CNAME record.
     *
     * @experimental
     */
    CNAME = 1,
    /**
     * (experimental) Do not create any DNS records.
     *
     * @experimental
     */
    NONE = 2
}
/**
 * (experimental) The properties for the base NetworkLoadBalancedEc2Service or NetworkLoadBalancedFargateService service.
 *
 * @experimental
 */
export interface NetworkLoadBalancedServiceBaseProps {
    /**
     * (experimental) The name of the cluster that hosts the service.
     *
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     *
     * @default - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     * @experimental
     */
    readonly cluster?: ICluster;
    /**
     * (experimental) The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     *
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     *
     * @default - uses the VPC defined in the cluster or creates a new VPC.
     * @experimental
     */
    readonly vpc?: IVpc;
    /**
     * (experimental) The properties required to create a new task definition.
     *
     * One of taskImageOptions or taskDefinition must be specified.
     *
     * @default - none
     * @experimental
     */
    readonly taskImageOptions?: NetworkLoadBalancedTaskImageOptions;
    /**
     * (experimental) Determines whether the Load Balancer will be internet-facing.
     *
     * @default true
     * @experimental
     */
    readonly publicLoadBalancer?: boolean;
    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     *
     * The minimum value is 1
     *
     * @default 1
     * @experimental
     */
    readonly desiredCount?: number;
    /**
     * (experimental) The domain name for the service, e.g. "api.example.com.".
     *
     * @default - No domain name.
     * @experimental
     */
    readonly domainName?: string;
    /**
     * (experimental) The Route53 hosted zone for the domain, e.g. "example.com.".
     *
     * @default - No Route53 hosted domain zone.
     * @experimental
     */
    readonly domainZone?: IHostedZone;
    /**
     * (experimental) The name of the service.
     *
     * @default - CloudFormation-generated name.
     * @experimental
     */
    readonly serviceName?: string;
    /**
     * (experimental) The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     *
     * @default - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
     * @experimental
     */
    readonly healthCheckGracePeriod?: cdk.Duration;
    /**
     * (experimental) The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
     *
     * @default - 100 if daemon, otherwise 200
     * @experimental
     */
    readonly maxHealthyPercent?: number;
    /**
     * (experimental) The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
     *
     * @default - 0 if daemon, otherwise 50
     * @experimental
     */
    readonly minHealthyPercent?: number;
    /**
     * (experimental) The network load balancer that will serve traffic to the service.
     *
     * If the load balancer has been imported, the vpc attribute must be specified
     * in the call to fromNetworkLoadBalancerAttributes().
     *
     * [disable-awslint:ref-via-interface]
     *
     * @default - a new load balancer will be created.
     * @experimental
     */
    readonly loadBalancer?: INetworkLoadBalancer;
    /**
     * (experimental) Listener port of the network load balancer that will serve traffic to the service.
     *
     * @default 80
     * @experimental
     */
    readonly listenerPort?: number;
    /**
     * (experimental) Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
     *
     * Tags can only be propagated to the tasks within the service during service creation.
     *
     * @default - none
     * @experimental
     */
    readonly propagateTags?: PropagatedTagSource;
    /**
     * (experimental) Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
     *
     * For more information, see
     * [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
     *
     * @default false
     * @experimental
     */
    readonly enableECSManagedTags?: boolean;
    /**
     * (experimental) The options for configuring an Amazon ECS service to use service discovery.
     *
     * @default - AWS Cloud Map service discovery is not enabled.
     * @experimental
     */
    readonly cloudMapOptions?: CloudMapOptions;
    /**
     * (experimental) Specifies whether the Route53 record should be a CNAME, an A record using the Alias feature or no record at all.
     *
     * This is useful if you need to work with DNS systems that do not support alias records.
     *
     * @default NetworkLoadBalancedServiceRecordType.ALIAS
     * @experimental
     */
    readonly recordType?: NetworkLoadBalancedServiceRecordType;
}
/**
 * @experimental
 */
export interface NetworkLoadBalancedTaskImageOptions {
    /**
     * (experimental) The image used to start a container.
     *
     * Image or taskDefinition must be specified, but not both.
     *
     * @default - none
     * @experimental
     */
    readonly image: ContainerImage;
    /**
     * (experimental) The environment variables to pass to the container.
     *
     * @default - No environment variables.
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The secret to expose to the container as an environment variable.
     *
     * @default - No secret environment variables.
     * @experimental
     */
    readonly secrets?: {
        [key: string]: Secret;
    };
    /**
     * (experimental) Flag to indicate whether to enable logging.
     *
     * @default true
     * @experimental
     */
    readonly enableLogging?: boolean;
    /**
     * (experimental) The log driver to use.
     *
     * @default - AwsLogDriver if enableLogging is true
     * @experimental
     */
    readonly logDriver?: LogDriver;
    /**
     * (experimental) The name of the task execution IAM role that grants the Amazon ECS container agent permission to call AWS APIs on your behalf.
     *
     * @default - No value
     * @experimental
     */
    readonly executionRole?: IRole;
    /**
     * (experimental) The name of the task IAM role that grants containers in the task permission to call AWS APIs on your behalf.
     *
     * @default - A task role is automatically created for you.
     * @experimental
     */
    readonly taskRole?: IRole;
    /**
     * (experimental) The container name value to be specified in the task definition.
     *
     * @default - none
     * @experimental
     */
    readonly containerName?: string;
    /**
     * (experimental) The port number on the container that is bound to the user-specified or automatically assigned host port.
     *
     * If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
     * If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
     * your container automatically receives a host port in the ephemeral port range.
     *
     * Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
     *
     * For more information, see
     * [hostPort](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PortMapping.html#ECS-Type-PortMapping-hostPort).
     *
     * @default 80
     * @experimental
     */
    readonly containerPort?: number;
    /**
     * (experimental) The name of a family that this task definition is registered to.
     *
     * A family groups multiple versions of a task definition.
     *
     * @default - Automatically generated name.
     * @experimental
     */
    readonly family?: string;
}
/**
 * (experimental) The base class for NetworkLoadBalancedEc2Service and NetworkLoadBalancedFargateService services.
 *
 * @experimental
 */
export declare abstract class NetworkLoadBalancedServiceBase extends cdk.Construct {
    /**
     * (experimental) The desired number of instantiations of the task definition to keep running on the service.
     *
     * @experimental
     */
    readonly desiredCount: number;
    /**
     * (experimental) The Network Load Balancer for the service.
     *
     * @experimental
     */
    get loadBalancer(): NetworkLoadBalancer;
    /**
     * (experimental) The listener for the service.
     *
     * @experimental
     */
    readonly listener: NetworkListener;
    /**
     * (experimental) The target group for the service.
     *
     * @experimental
     */
    readonly targetGroup: NetworkTargetGroup;
    /**
     * (experimental) The cluster that hosts the service.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    private readonly _networkLoadBalancer?;
    /**
     * (experimental) Constructs a new instance of the NetworkLoadBalancedServiceBase class.
     *
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: NetworkLoadBalancedServiceBaseProps);
    /**
     * (experimental) Returns the default cluster.
     *
     * @experimental
     */
    protected getDefaultCluster(scope: cdk.Construct, vpc?: IVpc): Cluster;
    /**
     * (experimental) Adds service as a target of the target group.
     *
     * @experimental
     */
    protected addServiceAsTarget(service: BaseService): void;
    /**
     * @experimental
     */
    protected createAWSLogDriver(prefix: string): AwsLogDriver;
}
