import * as cloudwatch from "../../aws-cloudwatch";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IVpc, SubnetSelection } from './vpc';
/**
 * @experimental
 */
export interface IVpnConnection extends IResource {
    /**
     * (experimental) The id of the VPN connection.
     *
     * @experimental
     */
    readonly vpnId: string;
    /**
     * (experimental) The id of the customer gateway.
     *
     * @experimental
     */
    readonly customerGatewayId: string;
    /**
     * (experimental) The ip address of the customer gateway.
     *
     * @experimental
     */
    readonly customerGatewayIp: string;
    /**
     * (experimental) The ASN of the customer gateway.
     *
     * @experimental
     */
    readonly customerGatewayAsn: number;
}
/**
 * (experimental) The virtual private gateway interface.
 *
 * @experimental
 */
export interface IVpnGateway extends IResource {
    /**
     * (experimental) The virtual private gateway Id.
     *
     * @experimental
     */
    readonly gatewayId: string;
}
/**
 * @experimental
 */
export interface VpnTunnelOption {
    /**
     * (experimental) The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
     *
     * Allowed characters are alphanumeric characters
     * and ._. Must be between 8 and 64 characters in length and cannot start with zero (0).
     *
     * @default an Amazon generated pre-shared key
     * @experimental
     */
    readonly preSharedKey?: string;
    /**
     * (experimental) The range of inside IP addresses for the tunnel.
     *
     * Any specified CIDR blocks must be
     * unique across all VPN connections that use the same virtual private gateway.
     * A size /30 CIDR block from the 169.254.0.0/16 range.
     *
     * @default an Amazon generated inside IP CIDR
     * @experimental
     */
    readonly tunnelInsideCidr?: string;
}
/**
 * @experimental
 */
export interface VpnConnectionOptions {
    /**
     * (experimental) The ip address of the customer gateway.
     *
     * @experimental
     */
    readonly ip: string;
    /**
     * (experimental) The ASN of the customer gateway.
     *
     * @default 65000
     * @experimental
     */
    readonly asn?: number;
    /**
     * (experimental) The static routes to be routed from the VPN gateway to the customer gateway.
     *
     * @default Dynamic routing (BGP)
     * @experimental
     */
    readonly staticRoutes?: string[];
    /**
     * (experimental) The tunnel options for the VPN connection.
     *
     * At most two elements (one per tunnel).
     * Duplicates not allowed.
     *
     * @default Amazon generated tunnel options
     * @experimental
     */
    readonly tunnelOptions?: VpnTunnelOption[];
}
/**
 * (experimental) The VpnGateway Properties.
 *
 * @experimental
 */
export interface VpnGatewayProps {
    /**
     * (experimental) Default type ipsec.1.
     *
     * @experimental
     */
    readonly type: string;
    /**
     * (experimental) Explicitely specify an Asn or let aws pick an Asn for you.
     *
     * @default 65000
     * @experimental
     */
    readonly amazonSideAsn?: number;
}
/**
 * (experimental) Options for the Vpc.enableVpnGateway() method.
 *
 * @experimental
 */
export interface EnableVpnGatewayOptions extends VpnGatewayProps {
    /**
     * (experimental) Provide an array of subnets where the route propagation shoud be added.
     *
     * @default noPropagation
     * @experimental
     */
    readonly vpnRoutePropagation?: SubnetSelection[];
}
/**
 * @experimental
 */
export interface VpnConnectionProps extends VpnConnectionOptions {
    /**
     * (experimental) The VPC to connect to.
     *
     * @experimental
     */
    readonly vpc: IVpc;
}
/**
 * (experimental) The VPN connection type.
 *
 * @experimental
 */
export declare enum VpnConnectionType {
    /**
     * (experimental) The IPsec 1 VPN connection type.
     *
     * @experimental
     */
    IPSEC_1 = "ipsec.1",
    /**
     * (experimental) Dummy member TODO: remove once https://github.com/aws/jsii/issues/231 is fixed.
     *
     * @experimental
     */
    DUMMY = "dummy"
}
/**
 * (experimental) The VPN Gateway that shall be added to the VPC.
 *
 * @experimental
 * @resource AWS::EC2::VPNGateway
 */
export declare class VpnGateway extends Resource implements IVpnGateway {
    /**
     * (experimental) The virtual private gateway Id.
     *
     * @experimental
     */
    readonly gatewayId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VpnGatewayProps);
}
/**
 * (experimental) Define a VPN Connection.
 *
 * @experimental
 * @resource AWS::EC2::VPNConnection
 */
export declare class VpnConnection extends Resource implements IVpnConnection {
    /**
     * (experimental) Return the given named metric for all VPN connections in the account/region.
     *
     * @experimental
     */
    static metricAll(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the tunnel state of all VPN connections in the account/region.
     *
     * @default average over 5 minutes
     * @experimental
     */
    static metricAllTunnelState(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the tunnel data in of all VPN connections in the account/region.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    static metricAllTunnelDataIn(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the tunnel data out of all VPN connections.
     *
     * @default sum over 5 minutes
     * @experimental
     */
    static metricAllTunnelDataOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The id of the VPN connection.
     *
     * @experimental
     */
    readonly vpnId: string;
    /**
     * (experimental) The id of the customer gateway.
     *
     * @experimental
     */
    readonly customerGatewayId: string;
    /**
     * (experimental) The ip address of the customer gateway.
     *
     * @experimental
     */
    readonly customerGatewayIp: string;
    /**
     * (experimental) The ASN of the customer gateway.
     *
     * @experimental
     */
    readonly customerGatewayAsn: number;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VpnConnectionProps);
}
export declare const RESERVED_TUNNEL_INSIDE_CIDR: string[];
