import { ISubnet } from './vpc';
/**
 * (experimental) Contains logic which chooses a set of subnets from a larger list, in conjunction with SubnetSelection, to determine where to place AWS resources such as VPC endpoints, EC2 instances, etc.
 *
 * @experimental
 */
export declare abstract class SubnetFilter {
    /**
     * (experimental) Chooses subnets which are in one of the given availability zones.
     *
     * @experimental
     */
    static availabilityZones(availabilityZones: string[]): SubnetFilter;
    /**
     * (experimental) Chooses subnets such that there is at most one per availability zone.
     *
     * @experimental
     */
    static onePerAz(): SubnetFilter;
    /**
     * (experimental) Chooses subnets which contain any of the specified IP addresses.
     *
     * @experimental
     */
    static containsIpAddresses(ipv4addrs: string[]): SubnetFilter;
    /**
     * (experimental) Executes the subnet filtering logic, returning a filtered set of subnets.
     *
     * @experimental
     */
    selectSubnets(_subnets: ISubnet[]): ISubnet[];
}
