/**
 * (experimental) Protocol for use in Connection Rules.
 *
 * @experimental
 */
export declare enum Protocol {
    /**
     * @experimental
     */
    ALL = "-1",
    /**
     * @experimental
     */
    TCP = "tcp",
    /**
     * @experimental
     */
    UDP = "udp",
    /**
     * @experimental
     */
    ICMP = "icmp",
    /**
     * @experimental
     */
    ICMPV6 = "58"
}
/**
 * (experimental) Properties to create a port range.
 *
 * @experimental
 */
export interface PortProps {
    /**
     * (experimental) The protocol for the range.
     *
     * @experimental
     */
    readonly protocol: Protocol;
    /**
     * (experimental) The starting port for the range.
     *
     * @default - Not included in the rule
     * @experimental
     */
    readonly fromPort?: number;
    /**
     * (experimental) The ending port for the range.
     *
     * @default - Not included in the rule
     * @experimental
     */
    readonly toPort?: number;
    /**
     * (experimental) String representation for this object.
     *
     * @experimental
     */
    readonly stringRepresentation: string;
}
/**
 * (experimental) Interface for classes that provide the connection-specification parts of a security group rule.
 *
 * @experimental
 */
export declare class Port {
    private readonly props;
    /**
     * (experimental) A single TCP port.
     *
     * @experimental
     */
    static tcp(port: number): Port;
    /**
     * (experimental) A TCP port range.
     *
     * @experimental
     */
    static tcpRange(startPort: number, endPort: number): Port;
    /**
     * (experimental) Any TCP traffic.
     *
     * @experimental
     */
    static allTcp(): Port;
    /**
     * (experimental) A single UDP port.
     *
     * @experimental
     */
    static udp(port: number): Port;
    /**
     * (experimental) A UDP port range.
     *
     * @experimental
     */
    static udpRange(startPort: number, endPort: number): Port;
    /**
     * (experimental) Any UDP traffic.
     *
     * @experimental
     */
    static allUdp(): Port;
    /**
     * (experimental) A specific combination of ICMP type and code.
     *
     * @see https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     * @experimental
     */
    static icmpTypeAndCode(type: number, code: number): Port;
    /**
     * (experimental) All codes for a single ICMP type.
     *
     * @experimental
     */
    static icmpType(type: number): Port;
    /**
     * (experimental) ICMP ping (echo) traffic.
     *
     * @experimental
     */
    static icmpPing(): Port;
    /**
     * (experimental) All ICMP traffic.
     *
     * @experimental
     */
    static allIcmp(): Port;
    /**
     * (experimental) All traffic.
     *
     * @experimental
     */
    static allTraffic(): Port;
    /**
     * (experimental) Whether the rule containing this port range can be inlined into a securitygroup or not.
     *
     * @experimental
     */
    readonly canInlineRule: boolean;
    /**
     * @experimental
     */
    constructor(props: PortProps);
    /**
     * (experimental) Produce the ingress/egress rule JSON for the given connection.
     *
     * @experimental
     */
    toRuleJson(): any;
    /**
     * @experimental
     */
    toString(): string;
}
