/**
 * (experimental) What class and generation of instance to use.
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 *
 * @experimental
 */
export declare enum InstanceClass {
    /**
     * (experimental) Standard instances, 3rd generation.
     *
     * @experimental
     */
    STANDARD3 = "m3",
    /**
     * Standard instances, 3rd generation
     */
    M3 = "m3",
    /**
     * (experimental) Standard instances, 4th generation.
     *
     * @experimental
     */
    STANDARD4 = "m4",
    /**
     * Standard instances, 4th generation
     */
    M4 = "m4",
    /**
     * (experimental) Standard instances, 5th generation.
     *
     * @experimental
     */
    STANDARD5 = "m5",
    /**
     * Standard instances, 5th generation
     */
    M5 = "m5",
    /**
     * (experimental) Standard instances with local NVME drive, 5th generation.
     *
     * @experimental
     */
    STANDARD5_NVME_DRIVE = "m5d",
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    M5D = "m5d",
    /**
     * (experimental) Standard instances based on AMD EPYC, 5th generation.
     *
     * @experimental
     */
    STANDARD5_AMD = "m5a",
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    M5A = "m5a",
    /**
     * (experimental) Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     *
     * @experimental
     */
    STANDARD5_AMD_NVME_DRIVE = "m5ad",
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    M5AD = "m5ad",
    /**
     * (experimental) Memory optimized instances, 3rd generation.
     *
     * @experimental
     */
    MEMORY3 = "r3",
    /**
     * Memory optimized instances, 3rd generation
     */
    R3 = "r3",
    /**
     * (experimental) Memory optimized instances, 4th generation.
     *
     * @experimental
     */
    MEMORY4 = "r4",
    /**
     * Memory optimized instances, 4th generation
     */
    R4 = "r4",
    /**
     * (experimental) Memory optimized instances, 5th generation.
     *
     * @experimental
     */
    MEMORY5 = "r5",
    /**
     * Memory optimized instances, 5th generation
     */
    R5 = "r5",
    /**
     * (experimental) Memory optimized instances for high performance computing, 5th generation.
     *
     * @experimental
     */
    MEMORY5_HIGH_PERFORMANCE = "r5n",
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    R5N = "r5n",
    /**
     * (experimental) Memory optimized instances with local NVME drive, 5th generation.
     *
     * @experimental
     */
    MEMORY5_NVME_DRIVE = "r5d",
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    R5D = "r5d",
    /**
     * (experimental) Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     *
     * @experimental
     */
    MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE = "r5dn",
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    R5DN = "r5dn",
    /**
     * (experimental) Memory optimized instances based on AMD EPYC, 5th generation.
     *
     * @experimental
     */
    MEMORY5_AMD = "r5a",
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    R5A = "r5a",
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    MEMORY5_AMD_NVME_DRIVE = "r5a",
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    R5AD = "r5a",
    /**
     * (experimental) Memory optimized instances, 6th generation with Graviton2 processors.
     *
     * @experimental
     */
    MEMORY6_GRAVITON = "r6g",
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    R6G = "r6g",
    /**
     * (experimental) Compute optimized instances, 3rd generation.
     *
     * @experimental
     */
    COMPUTE3 = "c3",
    /**
     * Compute optimized instances, 3rd generation
     */
    C3 = "c3",
    /**
     * (experimental) Compute optimized instances, 4th generation.
     *
     * @experimental
     */
    COMPUTE4 = "c4",
    /**
     * Compute optimized instances, 4th generation
     */
    C4 = "c4",
    /**
     * (experimental) Compute optimized instances, 5th generation.
     *
     * @experimental
     */
    COMPUTE5 = "c5",
    /**
     * Compute optimized instances, 5th generation
     */
    C5 = "c5",
    /**
     * (experimental) Compute optimized instances with local NVME drive, 5th generation.
     *
     * @experimental
     */
    COMPUTE5_NVME_DRIVE = "c5d",
    /**
     * (experimental) Compute optimized instances based on AMD EPYC, 5th generation.
     *
     * @experimental
     */
    COMPUTE5_AMD = "c5a",
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    C5A = "c5a",
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    C5D = "c5d",
    /**
     * (experimental) Compute optimized instances for high performance computing, 5th generation.
     *
     * @experimental
     */
    COMPUTE5_HIGH_PERFORMANCE = "c5n",
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    C5N = "c5n",
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     *
     * @experimental
     */
    COMPUTE6_GRAVITON2 = "c6g",
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    C6G = "c6g",
    /**
     * (experimental) Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     *
     * @experimental
     */
    COMPUTE6_GRAVITON2_NVME_DRIVE = "c6gd",
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    C6GD = "c6gd",
    /**
     * (experimental) Storage-optimized instances, 2nd generation.
     *
     * @experimental
     */
    STORAGE2 = "d2",
    /**
     * Storage-optimized instances, 2nd generation
     */
    D2 = "d2",
    /**
     * (experimental) Storage/compute balanced instances, 1st generation.
     *
     * @experimental
     */
    STORAGE_COMPUTE_1 = "h1",
    /**
     * Storage/compute balanced instances, 1st generation
     */
    H1 = "h1",
    /**
     * (experimental) I/O-optimized instances, 3rd generation.
     *
     * @experimental
     */
    IO3 = "i3",
    /**
     * I/O-optimized instances, 3rd generation
     */
    I3 = "i3",
    /**
     * (experimental) I/O-optimized instances with local NVME drive, 3rd generation.
     *
     * @experimental
     */
    IO3_DENSE_NVME_DRIVE = "i3en",
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    I3EN = "i3en",
    /**
     * (experimental) Burstable instances, 2nd generation.
     *
     * @experimental
     */
    BURSTABLE2 = "t2",
    /**
     * Burstable instances, 2nd generation
     */
    T2 = "t2",
    /**
     * (experimental) Burstable instances, 3rd generation.
     *
     * @experimental
     */
    BURSTABLE3 = "t3",
    /**
     * Burstable instances, 3rd generation
     */
    T3 = "t3",
    /**
     * (experimental) Burstable instances based on AMD EPYC, 3rd generation.
     *
     * @experimental
     */
    BURSTABLE3_AMD = "t3a",
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    T3A = "t3a",
    /**
     * (experimental) Burstable instances, 4th generation with Graviton2 processors.
     *
     * @experimental
     */
    BURSTABLE4_GRAVITON = "t4g",
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    T4G = "t4g",
    /**
     * (experimental) Memory-intensive instances, 1st generation.
     *
     * @experimental
     */
    MEMORY_INTENSIVE_1 = "x1",
    /**
     * Memory-intensive instances, 1st generation
     */
    X1 = "x1",
    /**
     * (experimental) Memory-intensive instances, extended, 1st generation.
     *
     * @experimental
     */
    MEMORY_INTENSIVE_1_EXTENDED = "x1e",
    /**
     * Memory-intensive instances, 1st generation
     */
    X1E = "x1e",
    /**
     * (experimental) Instances with customizable hardware acceleration, 1st generation.
     *
     * @experimental
     */
    FPGA1 = "f1",
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    F1 = "f1",
    /**
     * (experimental) Graphics-optimized instances, 3rd generation.
     *
     * @experimental
     */
    GRAPHICS3 = "g3",
    /**
     * Graphics-optimized instances, 3rd generation
     */
    G3 = "g3",
    /**
     * (experimental) Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     *
     * @experimental
     */
    GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE = "g4dn",
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    G4DN = "g4dn",
    /**
     * (experimental) Parallel-processing optimized instances, 2nd generation.
     *
     * @experimental
     */
    PARALLEL2 = "p2",
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    P2 = "p2",
    /**
     * (experimental) Parallel-processing optimized instances, 3nd generation.
     *
     * @experimental
     */
    PARALLEL3 = "p3",
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    P3 = "p3",
    /**
     * (experimental) Arm processor based instances, 1st generation.
     *
     * @experimental
     */
    ARM1 = "a1",
    /**
     * Arm processor based instances, 1st generation
     */
    A1 = "a1",
    /**
     * (experimental) Arm processor based instances, 2nd generation.
     *
     * @experimental
     */
    STANDARD6_GRAVITON = "m6g",
    /**
     * Arm processor based instances, 2nd generation
     */
    M6G = "m6g",
    /**
     * (experimental) High memory and compute capacity instances, 1st generation.
     *
     * @experimental
     */
    HIGH_COMPUTE_MEMORY1 = "z1d",
    /**
     * High memory and compute capacity instances, 1st generation
     */
    Z1D = "z1d",
    /**
     * (experimental) Inferentia Chips based instances for machine learning inference applications, 1st generation.
     *
     * @experimental
     */
    INFERENCE1 = "inf1",
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    INF1 = "inf1"
}
/**
 * (experimental) What size of instance to use.
 *
 * @experimental
 */
export declare enum InstanceSize {
    /**
     * (experimental) Instance size NANO (nano).
     *
     * @experimental
     */
    NANO = "nano",
    /**
     * (experimental) Instance size MICRO (micro).
     *
     * @experimental
     */
    MICRO = "micro",
    /**
     * (experimental) Instance size SMALL (small).
     *
     * @experimental
     */
    SMALL = "small",
    /**
     * (experimental) Instance size MEDIUM (medium).
     *
     * @experimental
     */
    MEDIUM = "medium",
    /**
     * (experimental) Instance size LARGE (large).
     *
     * @experimental
     */
    LARGE = "large",
    /**
     * (experimental) Instance size XLARGE (xlarge).
     *
     * @experimental
     */
    XLARGE = "xlarge",
    /**
     * (experimental) Instance size XLARGE2 (2xlarge).
     *
     * @experimental
     */
    XLARGE2 = "2xlarge",
    /**
     * (experimental) Instance size XLARGE4 (4xlarge).
     *
     * @experimental
     */
    XLARGE4 = "4xlarge",
    /**
     * (experimental) Instance size XLARGE6 (6xlarge).
     *
     * @experimental
     */
    XLARGE6 = "6xlarge",
    /**
     * (experimental) Instance size XLARGE8 (8xlarge).
     *
     * @experimental
     */
    XLARGE8 = "8xlarge",
    /**
     * (experimental) Instance size XLARGE9 (9xlarge).
     *
     * @experimental
     */
    XLARGE9 = "9xlarge",
    /**
     * (experimental) Instance size XLARGE10 (10xlarge).
     *
     * @experimental
     */
    XLARGE10 = "10xlarge",
    /**
     * (experimental) Instance size XLARGE12 (12xlarge).
     *
     * @experimental
     */
    XLARGE12 = "12xlarge",
    /**
     * (experimental) Instance size XLARGE16 (16xlarge).
     *
     * @experimental
     */
    XLARGE16 = "16xlarge",
    /**
     * (experimental) Instance size XLARGE18 (18xlarge).
     *
     * @experimental
     */
    XLARGE18 = "18xlarge",
    /**
     * (experimental) Instance size XLARGE24 (24xlarge).
     *
     * @experimental
     */
    XLARGE24 = "24xlarge",
    /**
     * (experimental) Instance size XLARGE32 (32xlarge).
     *
     * @experimental
     */
    XLARGE32 = "32xlarge",
    /**
     * (experimental) Instance size METAL (metal).
     *
     * @experimental
     */
    METAL = "metal"
}
/**
 * (experimental) Instance type for EC2 instances.
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 *
 * @experimental
 */
export declare class InstanceType {
    private readonly instanceTypeIdentifier;
    /**
     * (experimental) Instance type for EC2 instances.
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     *
     * @experimental
     */
    static of(instanceClass: InstanceClass, instanceSize: InstanceSize): InstanceType;
    /**
     * @experimental
     */
    constructor(instanceTypeIdentifier: string);
    /**
     * (experimental) Return the instance type as a dotted string.
     *
     * @experimental
     */
    toString(): string;
}
