import { IPeer } from './peer';
import { Port } from './port';
import { ISecurityGroup } from './security-group';
/**
 * (experimental) An object that has a Connections object.
 *
 * @experimental
 */
export interface IConnectable {
    /**
     * @experimental
     */
    readonly connections: Connections;
}
/**
 * (experimental) Properties to intialize a new Connections object.
 *
 * @experimental
 */
export interface ConnectionsProps {
    /**
     * (experimental) Class that represents the rule by which others can connect to this connectable.
     *
     * This object is required, but will be derived from securityGroup if that is passed.
     *
     * @default Derived from securityGroup if set.
     * @experimental
     */
    readonly peer?: IPeer;
    /**
     * (experimental) What securityGroup(s) this object is managing connections for.
     *
     * @default No security groups
     * @experimental
     */
    readonly securityGroups?: ISecurityGroup[];
    /**
     * (experimental) Default port range for initiating connections to and from this object.
     *
     * @default - No default port
     * @experimental
     */
    readonly defaultPort?: Port;
}
/**
 * (experimental) Manage the allowed network connections for constructs with Security Groups.
 *
 * Security Groups can be thought of as a firewall for network-connected
 * devices. This class makes it easy to allow network connections to and
 * from security groups, and between security groups individually. When
 * establishing connectivity between security groups, it will automatically
 * add rules in both security groups
 *
 * This object can manage one or more security groups.
 *
 * @experimental
 */
export declare class Connections implements IConnectable {
    /**
     * @experimental
     */
    readonly connections: Connections;
    /**
     * (experimental) The default port configured for this connection peer, if available.
     *
     * @experimental
     */
    readonly defaultPort?: Port;
    /**
     * Underlying securityGroup for this Connections object, if present
     *
     * May be empty if this Connections object is not managing a SecurityGroup,
     * but simply representing a Connectable peer.
     */
    private readonly _securityGroups;
    /**
     * The rule that defines how to represent this peer in a security group
     */
    private readonly _securityGroupRules;
    /**
     * When doing bidirectional grants between Connections, make sure we don't recursive infinitely
     */
    private skip;
    /**
     * When doing bidirectional grants between Security Groups in different stacks, put the rule on the other SG
     */
    private remoteRule;
    /**
     * @experimental
     */
    constructor(props?: ConnectionsProps);
    /**
     * @experimental
     */
    get securityGroups(): ISecurityGroup[];
    /**
     * (experimental) Add a security group to the list of security groups managed by this object.
     *
     * @experimental
     */
    addSecurityGroup(...securityGroups: ISecurityGroup[]): void;
    /**
     * (experimental) Allow connections to the peer on the given port.
     *
     * @experimental
     */
    allowTo(other: IConnectable, portRange: Port, description?: string): void;
    /**
     * (experimental) Allow connections from the peer on the given port.
     *
     * @experimental
     */
    allowFrom(other: IConnectable, portRange: Port, description?: string): void;
    /**
     * (experimental) Allow hosts inside the security group to connect to each other on the given port.
     *
     * @experimental
     */
    allowInternally(portRange: Port, description?: string): void;
    /**
     * (experimental) Allow to all IPv4 ranges.
     *
     * @experimental
     */
    allowToAnyIpv4(portRange: Port, description?: string): void;
    /**
     * (experimental) Allow from any IPv4 ranges.
     *
     * @experimental
     */
    allowFromAnyIpv4(portRange: Port, description?: string): void;
    /**
     * (experimental) Allow connections from the peer on our default port.
     *
     * Even if the peer has a default port, we will always use our default port.
     *
     * @experimental
     */
    allowDefaultPortFrom(other: IConnectable, description?: string): void;
    /**
     * (experimental) Allow hosts inside the security group to connect to each other.
     *
     * @experimental
     */
    allowDefaultPortInternally(description?: string): void;
    /**
     * (experimental) Allow default connections from all IPv4 ranges.
     *
     * @experimental
     */
    allowDefaultPortFromAnyIpv4(description?: string): void;
    /**
     * (experimental) Allow connections to the security group on their default port.
     *
     * @experimental
     */
    allowToDefaultPort(other: IConnectable, description?: string): void;
    /**
     * (experimental) Allow connections from the peer on our default port.
     *
     * Even if the peer has a default port, we will always use our default port.
     *
     * @experimental
     */
    allowDefaultPortTo(other: IConnectable, description?: string): void;
}
