import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { IResource, RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
import { EnableScalingProps, IScalableTableAttribute } from './scalable-attribute-api';
/**
 * (experimental) Options for configuring a system errors metric that considers multiple operations.
 *
 * @experimental
 */
export interface SystemErrorsForOperationsMetricOptions extends cloudwatch.MetricOptions {
    /**
     * (experimental) The operations to apply the metric to.
     *
     * @default - All operations available by DynamoDB tables will be considered.
     * @experimental
     */
    readonly operations?: Operation[];
}
/**
 * (experimental) Supported DynamoDB table operations.
 *
 * @experimental
 */
export declare enum Operation {
    /**
     * (experimental) GetItem.
     *
     * @experimental
     */
    GET_ITEM = "GetItem",
    /**
     * (experimental) BatchGetItem.
     *
     * @experimental
     */
    BATCH_GET_ITEM = "BatchGetItem",
    /**
     * (experimental) Scan.
     *
     * @experimental
     */
    SCAN = "Scan",
    /**
     * (experimental) Query.
     *
     * @experimental
     */
    QUERY = "Query",
    /**
     * (experimental) GetRecords.
     *
     * @experimental
     */
    GET_RECORDS = "GetRecords",
    /**
     * (experimental) PutItem.
     *
     * @experimental
     */
    PUT_ITEM = "PutItem",
    /**
     * (experimental) DeleteItem.
     *
     * @experimental
     */
    DELETE_ITEM = "DeleteItem",
    /**
     * (experimental) UpdateItem.
     *
     * @experimental
     */
    UPDATE_ITEM = "UpdateItem",
    /**
     * (experimental) BatchWriteItem.
     *
     * @experimental
     */
    BATCH_WRITE_ITEM = "BatchWriteItem"
}
/**
 * (experimental) Represents an attribute for describing the key schema for the table and indexes.
 *
 * @experimental
 */
export interface Attribute {
    /**
     * (experimental) The name of an attribute.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The data type of an attribute.
     *
     * @experimental
     */
    readonly type: AttributeType;
}
/**
 * (experimental) What kind of server-side encryption to apply to this table.
 *
 * @experimental
 */
export declare enum TableEncryption {
    /**
     * (experimental) Server-side KMS encryption with a master key owned by AWS.
     *
     * @experimental
     */
    DEFAULT = "AWS_OWNED",
    /**
     * (experimental) Server-side KMS encryption with a customer master key managed by customer.
     *
     * If `encryptionKey` is specified, this key will be used, otherwise, one will be defined.
     *
     * @experimental
     */
    CUSTOMER_MANAGED = "CUSTOMER_MANAGED",
    /**
     * (experimental) Server-side KMS encryption with a master key managed by AWS.
     *
     * @experimental
     */
    AWS_MANAGED = "AWS_MANAGED"
}
/**
 * (experimental) Properties of a DynamoDB Table.
 *
 * Use {@link TableProps} for all table properties
 *
 * @experimental
 */
export interface TableOptions {
    /**
     * (experimental) Partition key attribute definition.
     *
     * @experimental
     */
    readonly partitionKey: Attribute;
    /**
     * (experimental) Table sort key attribute definition.
     *
     * @default no sort key
     * @experimental
     */
    readonly sortKey?: Attribute;
    /**
     * (experimental) The read capacity for the table.
     *
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     *
     * Can only be provided if billingMode is Provisioned.
     *
     * @default 5
     * @experimental
     */
    readonly readCapacity?: number;
    /**
     * (experimental) The write capacity for the table.
     *
     * Careful if you add Global Secondary Indexes, as
     * those will share the table's provisioned throughput.
     *
     * Can only be provided if billingMode is Provisioned.
     *
     * @default 5
     * @experimental
     */
    readonly writeCapacity?: number;
    /**
     * (experimental) Specify how you are charged for read and write throughput and how you manage capacity.
     *
     * @default PROVISIONED if `replicationRegions` is not specified, PAY_PER_REQUEST otherwise
     * @experimental
     */
    readonly billingMode?: BillingMode;
    /**
     * (experimental) Whether point-in-time recovery is enabled.
     *
     * @default - point-in-time recovery is disabled
     * @experimental
     */
    readonly pointInTimeRecovery?: boolean;
    /**
     * (deprecated) Whether server-side encryption with an AWS managed customer master key is enabled.
     *
     * This property cannot be set if `encryption` and/or `encryptionKey` is set.
     *
     * @default - server-side encryption is enabled with an AWS owned customer master key
     * @deprecated This property is deprecated. In order to obtain the same behavior as
     * enabling this, set the `encryption` property to `TableEncryption.AWS_MANAGED` instead.
     */
    readonly serverSideEncryption?: boolean;
    /**
     * (experimental) Whether server-side encryption with an AWS managed customer master key is enabled.
     *
     * This property cannot be set if `serverSideEncryption` is set.
     *
     * @default - server-side encryption is enabled with an AWS owned customer master key
     * @experimental
     */
    readonly encryption?: TableEncryption;
    /**
     * (experimental) External KMS key to use for table encryption.
     *
     * This property can only be set if `encryption` is set to `TableEncryption.CUSTOMER_MANAGED`.
     *
     * @default - If `encryption` is set to `TableEncryption.CUSTOMER_MANAGED` and this
     * property is undefined, a new KMS key will be created and associated with this table.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The name of TTL attribute.
     *
     * @default - TTL is disabled
     * @experimental
     */
    readonly timeToLiveAttribute?: string;
    /**
     * (experimental) When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
     *
     * @default - streams are disabled unless `replicationRegions` is specified
     * @experimental
     */
    readonly stream?: StreamViewType;
    /**
     * (experimental) The removal policy to apply to the DynamoDB Table.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Regions where replica tables will be created.
     *
     * @default - no replica tables are created
     * @experimental
     */
    readonly replicationRegions?: string[];
}
/**
 * (experimental) Properties for a DynamoDB Table.
 *
 * @experimental
 */
export interface TableProps extends TableOptions {
    /**
     * (experimental) Enforces a particular physical table name.
     *
     * @default <generated>
     * @experimental
     */
    readonly tableName?: string;
}
/**
 * (experimental) Properties for a secondary index.
 *
 * @experimental
 */
export interface SecondaryIndexProps {
    /**
     * (experimental) The name of the secondary index.
     *
     * @experimental
     */
    readonly indexName: string;
    /**
     * (experimental) The set of attributes that are projected into the secondary index.
     *
     * @default ALL
     * @experimental
     */
    readonly projectionType?: ProjectionType;
    /**
     * (experimental) The non-key attributes that are projected into the secondary index.
     *
     * @default - No additional attributes
     * @experimental
     */
    readonly nonKeyAttributes?: string[];
}
/**
 * (experimental) Properties for a global secondary index.
 *
 * @experimental
 */
export interface GlobalSecondaryIndexProps extends SecondaryIndexProps {
    /**
     * (experimental) The attribute of a partition key for the global secondary index.
     *
     * @experimental
     */
    readonly partitionKey: Attribute;
    /**
     * (experimental) The attribute of a sort key for the global secondary index.
     *
     * @default - No sort key
     * @experimental
     */
    readonly sortKey?: Attribute;
    /**
     * (experimental) The read capacity for the global secondary index.
     *
     * Can only be provided if table billingMode is Provisioned or undefined.
     *
     * @default 5
     * @experimental
     */
    readonly readCapacity?: number;
    /**
     * (experimental) The write capacity for the global secondary index.
     *
     * Can only be provided if table billingMode is Provisioned or undefined.
     *
     * @default 5
     * @experimental
     */
    readonly writeCapacity?: number;
}
/**
 * (experimental) Properties for a local secondary index.
 *
 * @experimental
 */
export interface LocalSecondaryIndexProps extends SecondaryIndexProps {
    /**
     * (experimental) The attribute of a sort key for the local secondary index.
     *
     * @experimental
     */
    readonly sortKey: Attribute;
}
/**
 * (experimental) An interface that represents a DynamoDB Table - either created with the CDK, or an existing one.
 *
 * @experimental
 */
export interface ITable extends IResource {
    /**
     * (experimental) Arn of the dynamodb table.
     *
     * @experimental
     * @attribute true
     */
    readonly tableArn: string;
    /**
     * (experimental) Table name of the dynamodb table.
     *
     * @experimental
     * @attribute true
     */
    readonly tableName: string;
    /**
     * (experimental) ARN of the table's stream, if there is one.
     *
     * @experimental
     * @attribute true
     */
    readonly tableStreamArn?: string;
    /**
     * (experimental) Optional KMS encryption key associated with this table.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Adds an IAM policy statement associated with this table to an IAM principal's policy.
     *
     * If `encryptionKey` is present, appropriate grants to the key needs to be added
     * separately using the `table.encryptionKey.grant*` methods.
     *
     * @param grantee The principal (no-op if undefined).
     * @param actions The set of actions to allow (i.e. "dynamodb:PutItem", "dynamodb:GetItem", ...).
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Adds an IAM policy statement associated with this table's stream to an IAM principal's policy.
     *
     * If `encryptionKey` is present, appropriate grants to the key needs to be added
     * separately using the `table.encryptionKey.grant*` methods.
     *
     * @param grantee The principal (no-op if undefined).
     * @param actions The set of actions to allow (i.e. "dynamodb:DescribeStream", "dynamodb:GetRecords", ...).
     * @experimental
     */
    grantStream(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantReadData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM Principal to list streams attached to current dynamodb table.
     *
     * @param grantee The principal (no-op if undefined).
     * @experimental
     */
    grantTableListStreams(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantStreamRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantWriteData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM principal to all data read/write operations to this table.
     *
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantReadWriteData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantFullAccess(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Metric for the number of Errors executing all Lambdas.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the consumed read capacity units.
     *
     * @param props properties of a metric.
     * @experimental
     */
    metricConsumedReadCapacityUnits(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the consumed write capacity units.
     *
     * @param props properties of a metric.
     * @experimental
     */
    metricConsumedWriteCapacityUnits(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the system errors.
     *
     * @param props properties of a metric.
     * @deprecated use `metricSystemErrorsForOperations`
     */
    metricSystemErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the user errors.
     *
     * @param props properties of a metric.
     * @experimental
     */
    metricUserErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the conditional check failed requests.
     *
     * @param props properties of a metric.
     * @experimental
     */
    metricConditionalCheckFailedRequests(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the successful request latency.
     *
     * @param props properties of a metric.
     * @experimental
     */
    metricSuccessfulRequestLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * (experimental) Reference to a dynamodb table.
 *
 * @experimental
 */
export interface TableAttributes {
    /**
     * (experimental) The ARN of the dynamodb table.
     *
     * One of this, or {@link tableName}, is required.
     *
     * @default - no table arn
     * @experimental
     */
    readonly tableArn?: string;
    /**
     * (experimental) The table name of the dynamodb table.
     *
     * One of this, or {@link tableArn}, is required.
     *
     * @default - no table name
     * @experimental
     */
    readonly tableName?: string;
    /**
     * (experimental) The ARN of the table's stream.
     *
     * @default - no table stream
     * @experimental
     */
    readonly tableStreamArn?: string;
    /**
     * (experimental) KMS encryption key, if this table uses a customer-managed encryption key.
     *
     * @default - no key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The name of the global indexes set for this Table.
     *
     * Note that you need to set either this property,
     * or {@link localIndexes},
     * if you want methods like grantReadData()
     * to grant permissions for indexes as well as the table itself.
     *
     * @default - no global indexes
     * @experimental
     */
    readonly globalIndexes?: string[];
    /**
     * (experimental) The name of the local indexes set for this Table.
     *
     * Note that you need to set either this property,
     * or {@link globalIndexes},
     * if you want methods like grantReadData()
     * to grant permissions for indexes as well as the table itself.
     *
     * @default - no local indexes
     * @experimental
     */
    readonly localIndexes?: string[];
}
declare abstract class TableBase extends Resource implements ITable {
    /**
     * @attribute
     */
    abstract readonly tableArn: string;
    /**
     * @attribute
     */
    abstract readonly tableName: string;
    /**
     * @attribute
     */
    abstract readonly tableStreamArn?: string;
    /**
     * KMS encryption key, if this table uses a customer-managed encryption key.
     */
    abstract readonly encryptionKey?: kms.IKey;
    /**
     * @experimental
     */
    protected readonly regionalArns: string[];
    /**
     * (experimental) Adds an IAM policy statement associated with this table to an IAM principal's policy.
     *
     * If `encryptionKey` is present, appropriate grants to the key needs to be added
     * separately using the `table.encryptionKey.grant*` methods.
     *
     * @param grantee The principal (no-op if undefined).
     * @param actions The set of actions to allow (i.e. "dynamodb:PutItem", "dynamodb:GetItem", ...).
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Adds an IAM policy statement associated with this table's stream to an IAM principal's policy.
     *
     * If `encryptionKey` is present, appropriate grants to the key needs to be added
     * separately using the `table.encryptionKey.grant*` methods.
     *
     * @param grantee The principal (no-op if undefined).
     * @param actions The set of actions to allow (i.e. "dynamodb:DescribeStream", "dynamodb:GetRecords", ...).
     * @experimental
     */
    grantStream(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Permits an IAM principal all data read operations from this table: BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantReadData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM Principal to list streams attached to current dynamodb table.
     *
     * @param grantee The principal (no-op if undefined).
     * @experimental
     */
    grantTableListStreams(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM principal all stream data read operations for this table's stream: DescribeStream, GetRecords, GetShardIterator, ListStreams.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantStreamRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM principal all data write operations to this table: BatchWriteItem, PutItem, UpdateItem, DeleteItem.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantWriteData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits an IAM principal to all data read/write operations to this table.
     *
     * BatchGetItem, GetRecords, GetShardIterator, Query, GetItem, Scan,
     * BatchWriteItem, PutItem, UpdateItem, DeleteItem
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantReadWriteData(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Permits all DynamoDB operations ("dynamodb:*") to an IAM principal.
     *
     * Appropriate grants will also be added to the customer-managed KMS key
     * if one was configured.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantFullAccess(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Return the given named metric for this Table.
     *
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the consumed read capacity units this table.
     *
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metricConsumedReadCapacityUnits(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the consumed write capacity units this table.
     *
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metricConsumedWriteCapacityUnits(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (deprecated) Metric for the system errors this table.
     *
     * @deprecated use `metricSystemErrorsForOperations`.
     */
    metricSystemErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the user errors.
     *
     * Note that this metric reports user errors across all
     * the tables in the account and region the table resides in.
     *
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metricUserErrors(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the conditional check failed requests this table.
     *
     * By default, the metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metricConditionalCheckFailedRequests(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the successful request latency this table.
     *
     * By default, the metric will be calculated as an average over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metricSuccessfulRequestLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) Metric for the system errors this table.
     *
     * This will sum errors across all possible operations.
     * Note that by default, each individual metric will be calculated as a sum over a period of 5 minutes.
     * You can customize this by using the `statistic` and `period` properties.
     *
     * @experimental
     */
    metricSystemErrorsForOperations(props?: SystemErrorsForOperationsMetricOptions): cloudwatch.IMetric;
    /**
     * Create a map of metrics that can be used in a math expression.
     *
     * Using the return value of this function as the `usingMetrics` property in `cloudwatch.MathExpression` allows you to
     * use the keys of this map as metric names inside you expression.
     *
     * @param metricName The metric name.
     * @param operations The list of operations to create metrics for.
     * @param props Properties for the individual metrics.
     * @param metricNameMapper Mapper function to allow controlling the individual metric name per operation.
     */
    private createMetricsForOperations;
    protected abstract get hasIndex(): boolean;
    /**
     * Adds an IAM policy statement associated with this table to an IAM
     * principal's policy.
     * @param grantee The principal (no-op if undefined)
     * @param opts Options for keyActions, tableActions and streamActions
     */
    private combinedGrant;
}
/**
 * (experimental) Provides a DynamoDB table.
 *
 * @experimental
 */
export declare class Table extends TableBase {
    /**
     * (deprecated) Permits an IAM Principal to list all DynamoDB Streams.
     *
     * @param grantee The principal (no-op if undefined).
     * @deprecated Use {@link #grantTableListStreams} for more granular permission
     */
    static grantListStreams(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Creates a Table construct that represents an external table via table name.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param tableName The table's name.
     * @experimental
     */
    static fromTableName(scope: Construct, id: string, tableName: string): ITable;
    /**
     * (experimental) Creates a Table construct that represents an external table via table arn.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param tableArn The table's ARN.
     * @experimental
     */
    static fromTableArn(scope: Construct, id: string, tableArn: string): ITable;
    /**
     * (experimental) Creates a Table construct that represents an external table.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `TableAttributes` object.
     * @experimental
     */
    static fromTableAttributes(scope: Construct, id: string, attrs: TableAttributes): ITable;
    /**
     * (experimental) KMS encryption key, if this table uses a customer-managed encryption key.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Arn of the dynamodb table.
     *
     * @experimental
     * @attribute true
     */
    readonly tableArn: string;
    /**
     * (experimental) Table name of the dynamodb table.
     *
     * @experimental
     * @attribute true
     */
    readonly tableName: string;
    /**
     * (experimental) ARN of the table's stream, if there is one.
     *
     * @experimental
     * @attribute true
     */
    readonly tableStreamArn: string | undefined;
    private readonly table;
    private readonly keySchema;
    private readonly attributeDefinitions;
    private readonly globalSecondaryIndexes;
    private readonly localSecondaryIndexes;
    private readonly secondaryIndexNames;
    private readonly nonKeyAttributes;
    private readonly tablePartitionKey;
    private readonly tableSortKey?;
    private readonly billingMode;
    private readonly tableScaling;
    private readonly indexScaling;
    private readonly scalingRole;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: TableProps);
    /**
     * (experimental) Add a global secondary index of table.
     *
     * @param props the property of global secondary index.
     * @experimental
     */
    addGlobalSecondaryIndex(props: GlobalSecondaryIndexProps): void;
    /**
     * (experimental) Add a local secondary index of table.
     *
     * @param props the property of local secondary index.
     * @experimental
     */
    addLocalSecondaryIndex(props: LocalSecondaryIndexProps): void;
    /**
     * (experimental) Enable read capacity scaling for this table.
     *
     * @returns An object to configure additional AutoScaling settings
     * @experimental
     */
    autoScaleReadCapacity(props: EnableScalingProps): IScalableTableAttribute;
    /**
     * (experimental) Enable write capacity scaling for this table.
     *
     * @returns An object to configure additional AutoScaling settings for this attribute
     * @experimental
     */
    autoScaleWriteCapacity(props: EnableScalingProps): IScalableTableAttribute;
    /**
     * (experimental) Enable read capacity scaling for the given GSI.
     *
     * @returns An object to configure additional AutoScaling settings for this attribute
     * @experimental
     */
    autoScaleGlobalSecondaryIndexReadCapacity(indexName: string, props: EnableScalingProps): IScalableTableAttribute;
    /**
     * (experimental) Enable write capacity scaling for the given GSI.
     *
     * @returns An object to configure additional AutoScaling settings for this attribute
     * @experimental
     */
    autoScaleGlobalSecondaryIndexWriteCapacity(indexName: string, props: EnableScalingProps): IScalableTableAttribute;
    /**
     * (experimental) Validate the table construct.
     *
     * @returns an array of validation error message
     * @experimental
     */
    protected validate(): string[];
    /**
     * Validate read and write capacity are not specified for on-demand tables (billing mode PAY_PER_REQUEST).
     *
     * @param props read and write capacity properties
     */
    private validateProvisioning;
    /**
     * Validate index name to check if a duplicate name already exists.
     *
     * @param indexName a name of global or local secondary index
     */
    private validateIndexName;
    /**
     * Validate non-key attributes by checking limits within secondary index, which may vary in future.
     *
     * @param nonKeyAttributes a list of non-key attribute names
     */
    private validateNonKeyAttributes;
    private buildIndexKeySchema;
    private buildIndexProjection;
    private findKey;
    private addKey;
    /**
     * Register the key attribute of table or secondary index to assemble attribute definitions of TableResourceProps.
     *
     * @param attribute the key attribute of table or secondary index
     */
    private registerAttribute;
    /**
     * Return the role that will be used for AutoScaling
     */
    private makeScalingRole;
    /**
     * Creates replica tables
     *
     * @param regions regions where to create tables
     */
    private createReplicaTables;
    /**
     * (experimental) Whether this table has indexes.
     *
     * @experimental
     */
    protected get hasIndex(): boolean;
    /**
     * Set up key properties and return the Table encryption property from the
     * user's configuration.
     */
    private parseEncryption;
}
/**
 * (experimental) Data types for attributes within a table.
 *
 * @see https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes
 * @experimental
 */
export declare enum AttributeType {
    /**
     * (experimental) Up to 400KiB of binary data (which must be encoded as base64 before sending to DynamoDB).
     *
     * @experimental
     */
    BINARY = "B",
    /**
     * (experimental) Numeric values made of up to 38 digits (positive, negative or zero).
     *
     * @experimental
     */
    NUMBER = "N",
    /**
     * (experimental) Up to 400KiB of UTF-8 encoded text.
     *
     * @experimental
     */
    STRING = "S"
}
/**
 * (experimental) DyanmoDB's Read/Write capacity modes.
 *
 * @experimental
 */
export declare enum BillingMode {
    /**
     * (experimental) Pay only for what you use.
     *
     * You don't configure Read/Write capacity units.
     *
     * @experimental
     */
    PAY_PER_REQUEST = "PAY_PER_REQUEST",
    /**
     * (experimental) Explicitly specified Read/Write capacity units.
     *
     * @experimental
     */
    PROVISIONED = "PROVISIONED"
}
/**
 * (experimental) The set of attributes that are projected into the index.
 *
 * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_Projection.html
 * @experimental
 */
export declare enum ProjectionType {
    /**
     * (experimental) Only the index and primary keys are projected into the index.
     *
     * @experimental
     */
    KEYS_ONLY = "KEYS_ONLY",
    /**
     * (experimental) Only the specified table attributes are projected into the index.
     *
     * The list of projected attributes is in `nonKeyAttributes`.
     *
     * @experimental
     */
    INCLUDE = "INCLUDE",
    /**
     * (experimental) All of the table attributes are projected into the index.
     *
     * @experimental
     */
    ALL = "ALL"
}
/**
 * (experimental) When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
 *
 * @see https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_StreamSpecification.html
 * @experimental
 */
export declare enum StreamViewType {
    /**
     * (experimental) The entire item, as it appears after it was modified, is written to the stream.
     *
     * @experimental
     */
    NEW_IMAGE = "NEW_IMAGE",
    /**
     * (experimental) The entire item, as it appeared before it was modified, is written to the stream.
     *
     * @experimental
     */
    OLD_IMAGE = "OLD_IMAGE",
    /**
     * (experimental) Both the new and the old item images of the item are written to the stream.
     *
     * @experimental
     */
    NEW_AND_OLD_IMAGES = "NEW_AND_OLD_IMAGES",
    /**
     * (experimental) Only the key attributes of the modified item are written to the stream.
     *
     * @experimental
     */
    KEYS_ONLY = "KEYS_ONLY"
}
export {};
