"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableTableAttribute = void 0;
const appscaling = require("../../aws-applicationautoscaling"); // Automatically re-written from '@aws-cdk/aws-applicationautoscaling'
/**
 * A scalable table attribute
 */
class ScalableTableAttribute extends appscaling.BaseScalableAttribute {
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
    /**
     * Scale out or in to keep utilization at a given level
     */
    scaleOnUtilization(props) {
        if (props.targetUtilizationPercent < 10 || props.targetUtilizationPercent > 90) {
            // eslint-disable-next-line max-len
            throw new RangeError(`targetUtilizationPercent for DynamoDB scaling must be between 10 and 90 percent, got: ${props.targetUtilizationPercent}`);
        }
        const predefinedMetric = this.props.dimension.indexOf('ReadCapacity') === -1
            ? appscaling.PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION
            : appscaling.PredefinedMetric.DYNAMODB_READ_CAPACITY_UTILIZATION;
        super.doScaleToTrackMetric('Tracking', {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: props.targetUtilizationPercent,
            predefinedMetric,
        });
    }
}
exports.ScalableTableAttribute = ScalableTableAttribute;
//# sourceMappingURL=data:application/json;base64,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