import * as lambda from "../../aws-lambda";
import { NestedStack } from "../../core";
import * as cr from "../../custom-resources";
import { Construct } from 'constructs';
export declare class ReplicaProvider extends NestedStack {
    /**
     * Creates a stack-singleton resource provider nested stack.
     */
    static getOrCreate(scope: Construct): ReplicaProvider;
    /**
     * The custom resource provider.
     */
    readonly provider: cr.Provider;
    /**
     * The onEvent handler
     */
    readonly onEventHandler: lambda.Function;
    /**
     * The isComplete handler
     */
    readonly isCompleteHandler: lambda.Function;
    private constructor();
}
