import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::DocDB::DBCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html
 * @external
 */
export interface CfnDBClusterProps {
    /**
     * `AWS::DocDB::DBCluster.MasterUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masterusername
     * @external
     */
    readonly masterUsername: string;
    /**
     * `AWS::DocDB::DBCluster.MasterUserPassword`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
     * @external
     */
    readonly masterUserPassword: string;
    /**
     * `AWS::DocDB::DBCluster.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-availabilityzones
     * @external
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::DocDB::DBCluster.BackupRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-backupretentionperiod
     * @external
     */
    readonly backupRetentionPeriod?: number;
    /**
     * `AWS::DocDB::DBCluster.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-dbclusteridentifier
     * @external
     */
    readonly dbClusterIdentifier?: string;
    /**
     * `AWS::DocDB::DBCluster.DBClusterParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-dbclusterparametergroupname
     * @external
     */
    readonly dbClusterParameterGroupName?: string;
    /**
     * `AWS::DocDB::DBCluster.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-dbsubnetgroupname
     * @external
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::DocDB::DBCluster.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-deletionprotection
     * @external
     */
    readonly deletionProtection?: boolean | cdk.IResolvable;
    /**
     * `AWS::DocDB::DBCluster.EnableCloudwatchLogsExports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-enablecloudwatchlogsexports
     * @external
     */
    readonly enableCloudwatchLogsExports?: string[];
    /**
     * `AWS::DocDB::DBCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::DocDB::DBCluster.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::DocDB::DBCluster.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::DocDB::DBCluster.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-preferredbackupwindow
     * @external
     */
    readonly preferredBackupWindow?: string;
    /**
     * `AWS::DocDB::DBCluster.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::DocDB::DBCluster.SnapshotIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-snapshotidentifier
     * @external
     */
    readonly snapshotIdentifier?: string;
    /**
     * `AWS::DocDB::DBCluster.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-storageencrypted
     * @external
     */
    readonly storageEncrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::DocDB::DBCluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DocDB::DBCluster.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-vpcsecuritygroupids
     * @external
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::DocDB::DBCluster`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html
 * @external
 * @cloudformationResource AWS::DocDB::DBCluster
 */
export declare class CfnDBCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DocDB::DBCluster";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBCluster;
    /**
     * @external
     * @cloudformationAttribute ClusterResourceId
     */
    readonly attrClusterResourceId: string;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * @external
     * @cloudformationAttribute Port
     */
    readonly attrPort: string;
    /**
     * @external
     * @cloudformationAttribute ReadEndpoint
     */
    readonly attrReadEndpoint: string;
    /**
     * `AWS::DocDB::DBCluster.MasterUsername`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masterusername
     * @external
     */
    masterUsername: string;
    /**
     * `AWS::DocDB::DBCluster.MasterUserPassword`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
     * @external
     */
    masterUserPassword: string;
    /**
     * `AWS::DocDB::DBCluster.AvailabilityZones`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-availabilityzones
     * @external
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::DocDB::DBCluster.BackupRetentionPeriod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-backupretentionperiod
     * @external
     */
    backupRetentionPeriod: number | undefined;
    /**
     * `AWS::DocDB::DBCluster.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-dbclusteridentifier
     * @external
     */
    dbClusterIdentifier: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.DBClusterParameterGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-dbclusterparametergroupname
     * @external
     */
    dbClusterParameterGroupName: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-dbsubnetgroupname
     * @external
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.DeletionProtection`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-deletionprotection
     * @external
     */
    deletionProtection: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DocDB::DBCluster.EnableCloudwatchLogsExports`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-enablecloudwatchlogsexports
     * @external
     */
    enableCloudwatchLogsExports: string[] | undefined;
    /**
     * `AWS::DocDB::DBCluster.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::DocDB::DBCluster.PreferredBackupWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-preferredbackupwindow
     * @external
     */
    preferredBackupWindow: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.SnapshotIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-snapshotidentifier
     * @external
     */
    snapshotIdentifier: string | undefined;
    /**
     * `AWS::DocDB::DBCluster.StorageEncrypted`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-storageencrypted
     * @external
     */
    storageEncrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DocDB::DBCluster.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DocDB::DBCluster.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-vpcsecuritygroupids
     * @external
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::DocDB::DBCluster`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DocDB::DBClusterParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html
 * @external
 */
export interface CfnDBClusterParameterGroupProps {
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-family
     * @external
     */
    readonly family: string;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-parameters
     * @external
     */
    readonly parameters: any | cdk.IResolvable;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DocDB::DBClusterParameterGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html
 * @external
 * @cloudformationResource AWS::DocDB::DBClusterParameterGroup
 */
export declare class CfnDBClusterParameterGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DocDB::DBClusterParameterGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBClusterParameterGroup;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-description
     * @external
     */
    description: string;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Family`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-family
     * @external
     */
    family: string;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-parameters
     * @external
     */
    parameters: any | cdk.IResolvable;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::DocDB::DBClusterParameterGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbclusterparametergroup.html#cfn-docdb-dbclusterparametergroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DocDB::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBClusterParameterGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DocDB::DBInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html
 * @external
 */
export interface CfnDBInstanceProps {
    /**
     * `AWS::DocDB::DBInstance.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbclusteridentifier
     * @external
     */
    readonly dbClusterIdentifier: string;
    /**
     * `AWS::DocDB::DBInstance.DBInstanceClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceclass
     * @external
     */
    readonly dbInstanceClass: string;
    /**
     * `AWS::DocDB::DBInstance.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-autominorversionupgrade
     * @external
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::DocDB::DBInstance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::DocDB::DBInstance.DBInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceidentifier
     * @external
     */
    readonly dbInstanceIdentifier?: string;
    /**
     * `AWS::DocDB::DBInstance.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::DocDB::DBInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DocDB::DBInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html
 * @external
 * @cloudformationResource AWS::DocDB::DBInstance
 */
export declare class CfnDBInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DocDB::DBInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBInstance;
    /**
     * @external
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * @external
     * @cloudformationAttribute Port
     */
    readonly attrPort: string;
    /**
     * `AWS::DocDB::DBInstance.DBClusterIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbclusteridentifier
     * @external
     */
    dbClusterIdentifier: string;
    /**
     * `AWS::DocDB::DBInstance.DBInstanceClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceclass
     * @external
     */
    dbInstanceClass: string;
    /**
     * `AWS::DocDB::DBInstance.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-autominorversionupgrade
     * @external
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DocDB::DBInstance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::DocDB::DBInstance.DBInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-dbinstanceidentifier
     * @external
     */
    dbInstanceIdentifier: string | undefined;
    /**
     * `AWS::DocDB::DBInstance.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::DocDB::DBInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbinstance.html#cfn-docdb-dbinstance-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DocDB::DBInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DocDB::DBSubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html
 * @external
 */
export interface CfnDBSubnetGroupProps {
    /**
     * `AWS::DocDB::DBSubnetGroup.DBSubnetGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-dbsubnetgroupdescription
     * @external
     */
    readonly dbSubnetGroupDescription: string;
    /**
     * `AWS::DocDB::DBSubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::DocDB::DBSubnetGroup.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-dbsubnetgroupname
     * @external
     */
    readonly dbSubnetGroupName?: string;
    /**
     * `AWS::DocDB::DBSubnetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DocDB::DBSubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html
 * @external
 * @cloudformationResource AWS::DocDB::DBSubnetGroup
 */
export declare class CfnDBSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DocDB::DBSubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDBSubnetGroup;
    /**
     * `AWS::DocDB::DBSubnetGroup.DBSubnetGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-dbsubnetgroupdescription
     * @external
     */
    dbSubnetGroupDescription: string;
    /**
     * `AWS::DocDB::DBSubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::DocDB::DBSubnetGroup.DBSubnetGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-dbsubnetgroupname
     * @external
     */
    dbSubnetGroupName: string | undefined;
    /**
     * `AWS::DocDB::DBSubnetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbsubnetgroup.html#cfn-docdb-dbsubnetgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DocDB::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDBSubnetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
