import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::DMS::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html
 * @external
 */
export interface CfnCertificateProps {
    /**
     * `AWS::DMS::Certificate.CertificateIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificateidentifier
     * @external
     */
    readonly certificateIdentifier?: string;
    /**
     * `AWS::DMS::Certificate.CertificatePem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatepem
     * @external
     */
    readonly certificatePem?: string;
    /**
     * `AWS::DMS::Certificate.CertificateWallet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatewallet
     * @external
     */
    readonly certificateWallet?: string;
}
/**
 * A CloudFormation `AWS::DMS::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html
 * @external
 * @cloudformationResource AWS::DMS::Certificate
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Certificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCertificate;
    /**
     * `AWS::DMS::Certificate.CertificateIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificateidentifier
     * @external
     */
    certificateIdentifier: string | undefined;
    /**
     * `AWS::DMS::Certificate.CertificatePem`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatepem
     * @external
     */
    certificatePem: string | undefined;
    /**
     * `AWS::DMS::Certificate.CertificateWallet`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatewallet
     * @external
     */
    certificateWallet: string | undefined;
    /**
     * Create a new `AWS::DMS::Certificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 */
export interface CfnEndpointProps {
    /**
     * `AWS::DMS::Endpoint.EndpointType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype
     * @external
     */
    readonly endpointType: string;
    /**
     * `AWS::DMS::Endpoint.EngineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename
     * @external
     */
    readonly engineName: string;
    /**
     * `AWS::DMS::Endpoint.CertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn
     * @external
     */
    readonly certificateArn?: string;
    /**
     * `AWS::DMS::Endpoint.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename
     * @external
     */
    readonly databaseName?: string;
    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings
     * @external
     */
    readonly dynamoDbSettings?: CfnEndpoint.DynamoDbSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings
     * @external
     */
    readonly elasticsearchSettings?: CfnEndpoint.ElasticsearchSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.EndpointIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier
     * @external
     */
    readonly endpointIdentifier?: string;
    /**
     * `AWS::DMS::Endpoint.ExtraConnectionAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes
     * @external
     */
    readonly extraConnectionAttributes?: string;
    /**
     * `AWS::DMS::Endpoint.KafkaSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings
     * @external
     */
    readonly kafkaSettings?: CfnEndpoint.KafkaSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.KinesisSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings
     * @external
     */
    readonly kinesisSettings?: CfnEndpoint.KinesisSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings
     * @external
     */
    readonly mongoDbSettings?: CfnEndpoint.MongoDbSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings
     * @external
     */
    readonly neptuneSettings?: CfnEndpoint.NeptuneSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password
     * @external
     */
    readonly password?: string;
    /**
     * `AWS::DMS::Endpoint.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port
     * @external
     */
    readonly port?: number;
    /**
     * `AWS::DMS::Endpoint.S3Settings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings
     * @external
     */
    readonly s3Settings?: CfnEndpoint.S3SettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.ServerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername
     * @external
     */
    readonly serverName?: string;
    /**
     * `AWS::DMS::Endpoint.SslMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode
     * @external
     */
    readonly sslMode?: string;
    /**
     * `AWS::DMS::Endpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DMS::Endpoint.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username
     * @external
     */
    readonly username?: string;
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Endpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEndpoint;
    /**
     * @external
     * @cloudformationAttribute ExternalId
     */
    readonly attrExternalId: string;
    /**
     * `AWS::DMS::Endpoint.EndpointType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype
     * @external
     */
    endpointType: string;
    /**
     * `AWS::DMS::Endpoint.EngineName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename
     * @external
     */
    engineName: string;
    /**
     * `AWS::DMS::Endpoint.CertificateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn
     * @external
     */
    certificateArn: string | undefined;
    /**
     * `AWS::DMS::Endpoint.DatabaseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename
     * @external
     */
    databaseName: string | undefined;
    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings
     * @external
     */
    dynamoDbSettings: CfnEndpoint.DynamoDbSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings
     * @external
     */
    elasticsearchSettings: CfnEndpoint.ElasticsearchSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.EndpointIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier
     * @external
     */
    endpointIdentifier: string | undefined;
    /**
     * `AWS::DMS::Endpoint.ExtraConnectionAttributes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes
     * @external
     */
    extraConnectionAttributes: string | undefined;
    /**
     * `AWS::DMS::Endpoint.KafkaSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings
     * @external
     */
    kafkaSettings: CfnEndpoint.KafkaSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.KinesisSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings
     * @external
     */
    kinesisSettings: CfnEndpoint.KinesisSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings
     * @external
     */
    mongoDbSettings: CfnEndpoint.MongoDbSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings
     * @external
     */
    neptuneSettings: CfnEndpoint.NeptuneSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.Password`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password
     * @external
     */
    password: string | undefined;
    /**
     * `AWS::DMS::Endpoint.Port`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port
     * @external
     */
    port: number | undefined;
    /**
     * `AWS::DMS::Endpoint.S3Settings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings
     * @external
     */
    s3Settings: CfnEndpoint.S3SettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.ServerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername
     * @external
     */
    serverName: string | undefined;
    /**
     * `AWS::DMS::Endpoint.SslMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode
     * @external
     */
    sslMode: string | undefined;
    /**
     * `AWS::DMS::Endpoint.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DMS::Endpoint.Username`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username
     * @external
     */
    username: string | undefined;
    /**
     * Create a new `AWS::DMS::Endpoint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html
     * @external
     */
    interface DynamoDbSettingsProperty {
        /**
         * `CfnEndpoint.DynamoDbSettingsProperty.ServiceAccessRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html#cfn-dms-endpoint-dynamodbsettings-serviceaccessrolearn
         * @external
         */
        readonly serviceAccessRoleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html
     * @external
     */
    interface ElasticsearchSettingsProperty {
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.EndpointUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-endpointuri
         * @external
         */
        readonly endpointUri?: string;
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.ErrorRetryDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-errorretryduration
         * @external
         */
        readonly errorRetryDuration?: number;
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.FullLoadErrorPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-fullloaderrorpercentage
         * @external
         */
        readonly fullLoadErrorPercentage?: number;
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.ServiceAccessRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-serviceaccessrolearn
         * @external
         */
        readonly serviceAccessRoleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html
     * @external
     */
    interface KafkaSettingsProperty {
        /**
         * `CfnEndpoint.KafkaSettingsProperty.Broker`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-broker
         * @external
         */
        readonly broker?: string;
        /**
         * `CfnEndpoint.KafkaSettingsProperty.Topic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-topic
         * @external
         */
        readonly topic?: string;
    }
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html
     * @external
     */
    interface KinesisSettingsProperty {
        /**
         * `CfnEndpoint.KinesisSettingsProperty.MessageFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-messageformat
         * @external
         */
        readonly messageFormat?: string;
        /**
         * `CfnEndpoint.KinesisSettingsProperty.ServiceAccessRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-serviceaccessrolearn
         * @external
         */
        readonly serviceAccessRoleArn?: string;
        /**
         * `CfnEndpoint.KinesisSettingsProperty.StreamArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-streamarn
         * @external
         */
        readonly streamArn?: string;
    }
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html
     * @external
     */
    interface MongoDbSettingsProperty {
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthMechanism`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authmechanism
         * @external
         */
        readonly authMechanism?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authsource
         * @external
         */
        readonly authSource?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authtype
         * @external
         */
        readonly authType?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.DocsToInvestigate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-docstoinvestigate
         * @external
         */
        readonly docsToInvestigate?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.ExtractDocId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-extractdocid
         * @external
         */
        readonly extractDocId?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.NestingLevel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-nestinglevel
         * @external
         */
        readonly nestingLevel?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-password
         * @external
         */
        readonly password?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.ServerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-servername
         * @external
         */
        readonly serverName?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html
     * @external
     */
    interface NeptuneSettingsProperty {
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.ErrorRetryDuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-errorretryduration
         * @external
         */
        readonly errorRetryDuration?: number;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.IamAuthEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-iamauthenabled
         * @external
         */
        readonly iamAuthEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.MaxFileSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxfilesize
         * @external
         */
        readonly maxFileSize?: number;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.MaxRetryCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxretrycount
         * @external
         */
        readonly maxRetryCount?: number;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.S3BucketFolder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketfolder
         * @external
         */
        readonly s3BucketFolder?: string;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.S3BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketname
         * @external
         */
        readonly s3BucketName?: string;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.ServiceAccessRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-serviceaccessrolearn
         * @external
         */
        readonly serviceAccessRoleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 * @external
 * @cloudformationResource AWS::DMS::Endpoint
 */
export declare namespace CfnEndpoint {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html
     * @external
     */
    interface S3SettingsProperty {
        /**
         * `CfnEndpoint.S3SettingsProperty.BucketFolder`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketfolder
         * @external
         */
        readonly bucketFolder?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketname
         * @external
         */
        readonly bucketName?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.CompressionType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-compressiontype
         * @external
         */
        readonly compressionType?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.CsvDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvdelimiter
         * @external
         */
        readonly csvDelimiter?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.CsvRowDelimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvrowdelimiter
         * @external
         */
        readonly csvRowDelimiter?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.ExternalTableDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-externaltabledefinition
         * @external
         */
        readonly externalTableDefinition?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.ServiceAccessRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-serviceaccessrolearn
         * @external
         */
        readonly serviceAccessRoleArn?: string;
    }
}
/**
 * Properties for defining a `AWS::DMS::EventSubscription`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html
 * @external
 */
export interface CfnEventSubscriptionProps {
    /**
     * `AWS::DMS::EventSubscription.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-snstopicarn
     * @external
     */
    readonly snsTopicArn: string;
    /**
     * `AWS::DMS::EventSubscription.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::EventSubscription.EventCategories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-eventcategories
     * @external
     */
    readonly eventCategories?: string[];
    /**
     * `AWS::DMS::EventSubscription.SourceIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourceids
     * @external
     */
    readonly sourceIds?: string[];
    /**
     * `AWS::DMS::EventSubscription.SourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourcetype
     * @external
     */
    readonly sourceType?: string;
    /**
     * `AWS::DMS::EventSubscription.SubscriptionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-subscriptionname
     * @external
     */
    readonly subscriptionName?: string;
    /**
     * `AWS::DMS::EventSubscription.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DMS::EventSubscription`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html
 * @external
 * @cloudformationResource AWS::DMS::EventSubscription
 */
export declare class CfnEventSubscription extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::EventSubscription";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventSubscription;
    /**
     * `AWS::DMS::EventSubscription.SnsTopicArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-snstopicarn
     * @external
     */
    snsTopicArn: string;
    /**
     * `AWS::DMS::EventSubscription.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::EventSubscription.EventCategories`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-eventcategories
     * @external
     */
    eventCategories: string[] | undefined;
    /**
     * `AWS::DMS::EventSubscription.SourceIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourceids
     * @external
     */
    sourceIds: string[] | undefined;
    /**
     * `AWS::DMS::EventSubscription.SourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourcetype
     * @external
     */
    sourceType: string | undefined;
    /**
     * `AWS::DMS::EventSubscription.SubscriptionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-subscriptionname
     * @external
     */
    subscriptionName: string | undefined;
    /**
     * `AWS::DMS::EventSubscription.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DMS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSubscriptionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::ReplicationInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html
 * @external
 */
export interface CfnReplicationInstanceProps {
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceclass
     * @external
     */
    readonly replicationInstanceClass: string;
    /**
     * `AWS::DMS::ReplicationInstance.AllocatedStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allocatedstorage
     * @external
     */
    readonly allocatedStorage?: number;
    /**
     * `AWS::DMS::ReplicationInstance.AllowMajorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allowmajorversionupgrade
     * @external
     */
    readonly allowMajorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-autominorversionupgrade
     * @external
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-availabilityzone
     * @external
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::DMS::ReplicationInstance.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-engineversion
     * @external
     */
    readonly engineVersion?: string;
    /**
     * `AWS::DMS::ReplicationInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-kmskeyid
     * @external
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::DMS::ReplicationInstance.MultiAZ`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-multiaz
     * @external
     */
    readonly multiAz?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-preferredmaintenancewindow
     * @external
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::DMS::ReplicationInstance.PubliclyAccessible`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-publiclyaccessible
     * @external
     */
    readonly publiclyAccessible?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceidentifier
     * @external
     */
    readonly replicationInstanceIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationSubnetGroupIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationsubnetgroupidentifier
     * @external
     */
    readonly replicationSubnetGroupIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DMS::ReplicationInstance.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-vpcsecuritygroupids
     * @external
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::DMS::ReplicationInstance`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html
 * @external
 * @cloudformationResource AWS::DMS::ReplicationInstance
 */
export declare class CfnReplicationInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReplicationInstance;
    /**
     * @external
     * @cloudformationAttribute ReplicationInstancePrivateIpAddresses
     */
    readonly attrReplicationInstancePrivateIpAddresses: string[];
    /**
     * @external
     * @cloudformationAttribute ReplicationInstancePublicIpAddresses
     */
    readonly attrReplicationInstancePublicIpAddresses: string[];
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceClass`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceclass
     * @external
     */
    replicationInstanceClass: string;
    /**
     * `AWS::DMS::ReplicationInstance.AllocatedStorage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allocatedstorage
     * @external
     */
    allocatedStorage: number | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.AllowMajorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allowmajorversionupgrade
     * @external
     */
    allowMajorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.AutoMinorVersionUpgrade`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-autominorversionupgrade
     * @external
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.AvailabilityZone`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-availabilityzone
     * @external
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.EngineVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-engineversion
     * @external
     */
    engineVersion: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.KmsKeyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-kmskeyid
     * @external
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.MultiAZ`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-multiaz
     * @external
     */
    multiAz: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.PreferredMaintenanceWindow`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-preferredmaintenancewindow
     * @external
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.PubliclyAccessible`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-publiclyaccessible
     * @external
     */
    publiclyAccessible: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceidentifier
     * @external
     */
    replicationInstanceIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationSubnetGroupIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationsubnetgroupidentifier
     * @external
     */
    replicationSubnetGroupIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DMS::ReplicationInstance.VpcSecurityGroupIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-vpcsecuritygroupids
     * @external
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::DMS::ReplicationInstance`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationInstanceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::ReplicationSubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html
 * @external
 */
export interface CfnReplicationSubnetGroupProps {
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupdescription
     * @external
     */
    readonly replicationSubnetGroupDescription: string;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-subnetids
     * @external
     */
    readonly subnetIds: string[];
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupidentifier
     * @external
     */
    readonly replicationSubnetGroupIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DMS::ReplicationSubnetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html
 * @external
 * @cloudformationResource AWS::DMS::ReplicationSubnetGroup
 */
export declare class CfnReplicationSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationSubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReplicationSubnetGroup;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupdescription
     * @external
     */
    replicationSubnetGroupDescription: string;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.SubnetIds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-subnetids
     * @external
     */
    subnetIds: string[];
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupidentifier
     * @external
     */
    replicationSubnetGroupIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DMS::ReplicationSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationSubnetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::ReplicationTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html
 * @external
 */
export interface CfnReplicationTaskProps {
    /**
     * `AWS::DMS::ReplicationTask.MigrationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-migrationtype
     * @external
     */
    readonly migrationType: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationInstanceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationinstancearn
     * @external
     */
    readonly replicationInstanceArn: string;
    /**
     * `AWS::DMS::ReplicationTask.SourceEndpointArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-sourceendpointarn
     * @external
     */
    readonly sourceEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.TableMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tablemappings
     * @external
     */
    readonly tableMappings: string;
    /**
     * `AWS::DMS::ReplicationTask.TargetEndpointArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-targetendpointarn
     * @external
     */
    readonly targetEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartPosition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstartposition
     * @external
     */
    readonly cdcStartPosition?: string;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstarttime
     * @external
     */
    readonly cdcStartTime?: number;
    /**
     * `AWS::DMS::ReplicationTask.CdcStopPosition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstopposition
     * @external
     */
    readonly cdcStopPosition?: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtaskidentifier
     * @external
     */
    readonly replicationTaskIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtasksettings
     * @external
     */
    readonly replicationTaskSettings?: string;
    /**
     * `AWS::DMS::ReplicationTask.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DMS::ReplicationTask.TaskData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-taskdata
     * @external
     */
    readonly taskData?: string;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationTask`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html
 * @external
 * @cloudformationResource AWS::DMS::ReplicationTask
 */
export declare class CfnReplicationTask extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationTask";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnReplicationTask;
    /**
     * `AWS::DMS::ReplicationTask.MigrationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-migrationtype
     * @external
     */
    migrationType: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationInstanceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationinstancearn
     * @external
     */
    replicationInstanceArn: string;
    /**
     * `AWS::DMS::ReplicationTask.SourceEndpointArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-sourceendpointarn
     * @external
     */
    sourceEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.TableMappings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tablemappings
     * @external
     */
    tableMappings: string;
    /**
     * `AWS::DMS::ReplicationTask.TargetEndpointArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-targetendpointarn
     * @external
     */
    targetEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartPosition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstartposition
     * @external
     */
    cdcStartPosition: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartTime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstarttime
     * @external
     */
    cdcStartTime: number | undefined;
    /**
     * `AWS::DMS::ReplicationTask.CdcStopPosition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstopposition
     * @external
     */
    cdcStopPosition: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtaskidentifier
     * @external
     */
    replicationTaskIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtasksettings
     * @external
     */
    replicationTaskSettings: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DMS::ReplicationTask.TaskData`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-taskdata
     * @external
     */
    taskData: string | undefined;
    /**
     * Create a new `AWS::DMS::ReplicationTask`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationTaskProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
