import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 */
export interface CfnLifecyclePolicyProps {
    /**
     * `AWS::DLM::LifecyclePolicy.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::DLM::LifecyclePolicy.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn
     * @external
     */
    readonly executionRoleArn?: string;
    /**
     * `AWS::DLM::LifecyclePolicy.PolicyDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails
     * @external
     */
    readonly policyDetails?: CfnLifecyclePolicy.PolicyDetailsProperty | cdk.IResolvable;
    /**
     * `AWS::DLM::LifecyclePolicy.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state
     * @external
     */
    readonly state?: string;
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare class CfnLifecyclePolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DLM::LifecyclePolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLifecyclePolicy;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::DLM::LifecyclePolicy.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::DLM::LifecyclePolicy.ExecutionRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-executionrolearn
     * @external
     */
    executionRoleArn: string | undefined;
    /**
     * `AWS::DLM::LifecyclePolicy.PolicyDetails`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-policydetails
     * @external
     */
    policyDetails: CfnLifecyclePolicy.PolicyDetailsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DLM::LifecyclePolicy.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html#cfn-dlm-lifecyclepolicy-state
     * @external
     */
    state: string | undefined;
    /**
     * Create a new `AWS::DLM::LifecyclePolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLifecyclePolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html
     * @external
     */
    interface CreateRuleProperty {
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.CronExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-cronexpression
         * @external
         */
        readonly cronExpression?: string;
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-interval
         * @external
         */
        readonly interval?: number;
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.IntervalUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-intervalunit
         * @external
         */
        readonly intervalUnit?: string;
        /**
         * `CfnLifecyclePolicy.CreateRuleProperty.Times`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-createrule.html#cfn-dlm-lifecyclepolicy-createrule-times
         * @external
         */
        readonly times?: string[];
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html
     * @external
     */
    interface CrossRegionCopyRetainRuleProperty {
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-interval
         * @external
         */
        readonly interval: number;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty.IntervalUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyretainrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyretainrule-intervalunit
         * @external
         */
        readonly intervalUnit: string;
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html
     * @external
     */
    interface CrossRegionCopyRuleProperty {
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.CmkArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-cmkarn
         * @external
         */
        readonly cmkArn?: string;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.CopyTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-copytags
         * @external
         */
        readonly copyTags?: boolean | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.Encrypted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-encrypted
         * @external
         */
        readonly encrypted: boolean | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.RetainRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-retainrule
         * @external
         */
        readonly retainRule?: CfnLifecyclePolicy.CrossRegionCopyRetainRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.CrossRegionCopyRuleProperty.TargetRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-crossregioncopyrule.html#cfn-dlm-lifecyclepolicy-crossregioncopyrule-targetregion
         * @external
         */
        readonly targetRegion: string;
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html
     * @external
     */
    interface FastRestoreRuleProperty {
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.AvailabilityZones`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-availabilityzones
         * @external
         */
        readonly availabilityZones?: string[];
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-count
         * @external
         */
        readonly count?: number;
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-interval
         * @external
         */
        readonly interval?: number;
        /**
         * `CfnLifecyclePolicy.FastRestoreRuleProperty.IntervalUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-fastrestorerule.html#cfn-dlm-lifecyclepolicy-fastrestorerule-intervalunit
         * @external
         */
        readonly intervalUnit?: string;
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html
     * @external
     */
    interface ParametersProperty {
        /**
         * `CfnLifecyclePolicy.ParametersProperty.ExcludeBootVolume`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-parameters.html#cfn-dlm-lifecyclepolicy-parameters-excludebootvolume
         * @external
         */
        readonly excludeBootVolume?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html
     * @external
     */
    interface PolicyDetailsProperty {
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-parameters
         * @external
         */
        readonly parameters?: CfnLifecyclePolicy.ParametersProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.PolicyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-policytype
         * @external
         */
        readonly policyType?: string;
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.ResourceTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-resourcetypes
         * @external
         */
        readonly resourceTypes: string[];
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.Schedules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-schedules
         * @external
         */
        readonly schedules: Array<CfnLifecyclePolicy.ScheduleProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.PolicyDetailsProperty.TargetTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-policydetails.html#cfn-dlm-lifecyclepolicy-policydetails-targettags
         * @external
         */
        readonly targetTags: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html
     * @external
     */
    interface RetainRuleProperty {
        /**
         * `CfnLifecyclePolicy.RetainRuleProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-count
         * @external
         */
        readonly count?: number;
        /**
         * `CfnLifecyclePolicy.RetainRuleProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-interval
         * @external
         */
        readonly interval?: number;
        /**
         * `CfnLifecyclePolicy.RetainRuleProperty.IntervalUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-retainrule.html#cfn-dlm-lifecyclepolicy-retainrule-intervalunit
         * @external
         */
        readonly intervalUnit?: string;
    }
}
/**
 * A CloudFormation `AWS::DLM::LifecyclePolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dlm-lifecyclepolicy.html
 * @external
 * @cloudformationResource AWS::DLM::LifecyclePolicy
 */
export declare namespace CfnLifecyclePolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html
     * @external
     */
    interface ScheduleProperty {
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.CopyTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-copytags
         * @external
         */
        readonly copyTags?: boolean | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.CreateRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-createrule
         * @external
         */
        readonly createRule?: CfnLifecyclePolicy.CreateRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.CrossRegionCopyRules`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-crossregioncopyrules
         * @external
         */
        readonly crossRegionCopyRules?: Array<CfnLifecyclePolicy.CrossRegionCopyRuleProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.FastRestoreRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-fastrestorerule
         * @external
         */
        readonly fastRestoreRule?: CfnLifecyclePolicy.FastRestoreRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.RetainRule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-retainrule
         * @external
         */
        readonly retainRule?: CfnLifecyclePolicy.RetainRuleProperty | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.TagsToAdd`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-tagstoadd
         * @external
         */
        readonly tagsToAdd?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLifecyclePolicy.ScheduleProperty.VariableTags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dlm-lifecyclepolicy-schedule.html#cfn-dlm-lifecyclepolicy-schedule-variabletags
         * @external
         */
        readonly variableTags?: Array<cdk.CfnTag | cdk.IResolvable> | cdk.IResolvable;
    }
}
