import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::Config::AggregationAuthorization`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html
 * @external
 */
export interface CfnAggregationAuthorizationProps {
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedaccountid
     * @external
     */
    readonly authorizedAccountId: string;
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAwsRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedawsregion
     * @external
     */
    readonly authorizedAwsRegion: string;
    /**
     * `AWS::Config::AggregationAuthorization.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Config::AggregationAuthorization`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html
 * @external
 * @cloudformationResource AWS::Config::AggregationAuthorization
 */
export declare class CfnAggregationAuthorization extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::AggregationAuthorization";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAggregationAuthorization;
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedaccountid
     * @external
     */
    authorizedAccountId: string;
    /**
     * `AWS::Config::AggregationAuthorization.AuthorizedAwsRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-authorizedawsregion
     * @external
     */
    authorizedAwsRegion: string;
    /**
     * `AWS::Config::AggregationAuthorization.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-aggregationauthorization.html#cfn-config-aggregationauthorization-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Config::AggregationAuthorization`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAggregationAuthorizationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Config::ConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 * @external
 */
export interface CfnConfigRuleProps {
    /**
     * `AWS::Config::ConfigRule.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-source
     * @external
     */
    readonly source: CfnConfigRule.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigRule.ConfigRuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-configrulename
     * @external
     */
    readonly configRuleName?: string;
    /**
     * `AWS::Config::ConfigRule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Config::ConfigRule.InputParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-inputparameters
     * @external
     */
    readonly inputParameters?: any | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigRule.MaximumExecutionFrequency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-maximumexecutionfrequency
     * @external
     */
    readonly maximumExecutionFrequency?: string;
    /**
     * `AWS::Config::ConfigRule.Scope`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-scope
     * @external
     */
    readonly scope?: CfnConfigRule.ScopeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 */
export declare class CfnConfigRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigRule;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Compliance.Type
     */
    readonly attrComplianceType: string;
    /**
     * @external
     * @cloudformationAttribute ConfigRuleId
     */
    readonly attrConfigRuleId: string;
    /**
     * `AWS::Config::ConfigRule.Source`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-source
     * @external
     */
    source: CfnConfigRule.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigRule.ConfigRuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-configrulename
     * @external
     */
    configRuleName: string | undefined;
    /**
     * `AWS::Config::ConfigRule.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Config::ConfigRule.InputParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-inputparameters
     * @external
     */
    inputParameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConfigRule.MaximumExecutionFrequency`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-maximumexecutionfrequency
     * @external
     */
    maximumExecutionFrequency: string | undefined;
    /**
     * `AWS::Config::ConfigRule.Scope`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html#cfn-config-configrule-scope
     * @external
     */
    scope: CfnConfigRule.ScopeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Config::ConfigRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 */
export declare namespace CfnConfigRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html
     * @external
     */
    interface ScopeProperty {
        /**
         * `CfnConfigRule.ScopeProperty.ComplianceResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-complianceresourceid
         * @external
         */
        readonly complianceResourceId?: string;
        /**
         * `CfnConfigRule.ScopeProperty.ComplianceResourceTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-complianceresourcetypes
         * @external
         */
        readonly complianceResourceTypes?: string[];
        /**
         * `CfnConfigRule.ScopeProperty.TagKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-tagkey
         * @external
         */
        readonly tagKey?: string;
        /**
         * `CfnConfigRule.ScopeProperty.TagValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-scope.html#cfn-config-configrule-scope-tagvalue
         * @external
         */
        readonly tagValue?: string;
    }
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 */
export declare namespace CfnConfigRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html
     * @external
     */
    interface SourceProperty {
        /**
         * `CfnConfigRule.SourceProperty.Owner`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html#cfn-config-configrule-source-owner
         * @external
         */
        readonly owner: string;
        /**
         * `CfnConfigRule.SourceProperty.SourceDetails`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html#cfn-config-configrule-source-sourcedetails
         * @external
         */
        readonly sourceDetails?: Array<CfnConfigRule.SourceDetailProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnConfigRule.SourceProperty.SourceIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source.html#cfn-config-configrule-source-sourceidentifier
         * @external
         */
        readonly sourceIdentifier: string;
    }
}
/**
 * A CloudFormation `AWS::Config::ConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configrule.html
 * @external
 * @cloudformationResource AWS::Config::ConfigRule
 */
export declare namespace CfnConfigRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html
     * @external
     */
    interface SourceDetailProperty {
        /**
         * `CfnConfigRule.SourceDetailProperty.EventSource`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html#cfn-config-configrule-source-sourcedetail-eventsource
         * @external
         */
        readonly eventSource: string;
        /**
         * `CfnConfigRule.SourceDetailProperty.MaximumExecutionFrequency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html#cfn-config-configrule-sourcedetail-maximumexecutionfrequency
         * @external
         */
        readonly maximumExecutionFrequency?: string;
        /**
         * `CfnConfigRule.SourceDetailProperty.MessageType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configrule-source-sourcedetails.html#cfn-config-configrule-source-sourcedetail-messagetype
         * @external
         */
        readonly messageType: string;
    }
}
/**
 * Properties for defining a `AWS::Config::ConfigurationAggregator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 * @external
 */
export interface CfnConfigurationAggregatorProps {
    /**
     * `AWS::Config::ConfigurationAggregator.ConfigurationAggregatorName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-configurationaggregatorname
     * @external
     */
    readonly configurationAggregatorName: string;
    /**
     * `AWS::Config::ConfigurationAggregator.AccountAggregationSources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-accountaggregationsources
     * @external
     */
    readonly accountAggregationSources?: Array<CfnConfigurationAggregator.AccountAggregationSourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigurationAggregator.OrganizationAggregationSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-organizationaggregationsource
     * @external
     */
    readonly organizationAggregationSource?: CfnConfigurationAggregator.OrganizationAggregationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::Config::ConfigurationAggregator.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 * @external
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 */
export declare class CfnConfigurationAggregator extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigurationAggregator";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationAggregator;
    /**
     * `AWS::Config::ConfigurationAggregator.ConfigurationAggregatorName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-configurationaggregatorname
     * @external
     */
    configurationAggregatorName: string;
    /**
     * `AWS::Config::ConfigurationAggregator.AccountAggregationSources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-accountaggregationsources
     * @external
     */
    accountAggregationSources: Array<CfnConfigurationAggregator.AccountAggregationSourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConfigurationAggregator.OrganizationAggregationSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-organizationaggregationsource
     * @external
     */
    organizationAggregationSource: CfnConfigurationAggregator.OrganizationAggregationSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConfigurationAggregator.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html#cfn-config-configurationaggregator-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Config::ConfigurationAggregator`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationAggregatorProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 * @external
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 */
export declare namespace CfnConfigurationAggregator {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html
     * @external
     */
    interface AccountAggregationSourceProperty {
        /**
         * `CfnConfigurationAggregator.AccountAggregationSourceProperty.AccountIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html#cfn-config-configurationaggregator-accountaggregationsource-accountids
         * @external
         */
        readonly accountIds: string[];
        /**
         * `CfnConfigurationAggregator.AccountAggregationSourceProperty.AllAwsRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html#cfn-config-configurationaggregator-accountaggregationsource-allawsregions
         * @external
         */
        readonly allAwsRegions?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationAggregator.AccountAggregationSourceProperty.AwsRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-accountaggregationsource.html#cfn-config-configurationaggregator-accountaggregationsource-awsregions
         * @external
         */
        readonly awsRegions?: string[];
    }
}
/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationaggregator.html
 * @external
 * @cloudformationResource AWS::Config::ConfigurationAggregator
 */
export declare namespace CfnConfigurationAggregator {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html
     * @external
     */
    interface OrganizationAggregationSourceProperty {
        /**
         * `CfnConfigurationAggregator.OrganizationAggregationSourceProperty.AllAwsRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html#cfn-config-configurationaggregator-organizationaggregationsource-allawsregions
         * @external
         */
        readonly allAwsRegions?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationAggregator.OrganizationAggregationSourceProperty.AwsRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html#cfn-config-configurationaggregator-organizationaggregationsource-awsregions
         * @external
         */
        readonly awsRegions?: string[];
        /**
         * `CfnConfigurationAggregator.OrganizationAggregationSourceProperty.RoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationaggregator-organizationaggregationsource.html#cfn-config-configurationaggregator-organizationaggregationsource-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * Properties for defining a `AWS::Config::ConfigurationRecorder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 * @external
 */
export interface CfnConfigurationRecorderProps {
    /**
     * `AWS::Config::ConfigurationRecorder.RoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::Config::ConfigurationRecorder.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Config::ConfigurationRecorder.RecordingGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup
     * @external
     */
    readonly recordingGroup?: CfnConfigurationRecorder.RecordingGroupProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Config::ConfigurationRecorder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 * @external
 * @cloudformationResource AWS::Config::ConfigurationRecorder
 */
export declare class CfnConfigurationRecorder extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConfigurationRecorder";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConfigurationRecorder;
    /**
     * `AWS::Config::ConfigurationRecorder.RoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::Config::ConfigurationRecorder.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Config::ConfigurationRecorder.RecordingGroup`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html#cfn-config-configurationrecorder-recordinggroup
     * @external
     */
    recordingGroup: CfnConfigurationRecorder.RecordingGroupProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Config::ConfigurationRecorder`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationRecorderProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConfigurationRecorder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-configurationrecorder.html
 * @external
 * @cloudformationResource AWS::Config::ConfigurationRecorder
 */
export declare namespace CfnConfigurationRecorder {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html
     * @external
     */
    interface RecordingGroupProperty {
        /**
         * `CfnConfigurationRecorder.RecordingGroupProperty.AllSupported`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-allsupported
         * @external
         */
        readonly allSupported?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationRecorder.RecordingGroupProperty.IncludeGlobalResourceTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-includeglobalresourcetypes
         * @external
         */
        readonly includeGlobalResourceTypes?: boolean | cdk.IResolvable;
        /**
         * `CfnConfigurationRecorder.RecordingGroupProperty.ResourceTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-configurationrecorder-recordinggroup.html#cfn-config-configurationrecorder-recordinggroup-resourcetypes
         * @external
         */
        readonly resourceTypes?: string[];
    }
}
/**
 * Properties for defining a `AWS::Config::ConformancePack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 * @external
 */
export interface CfnConformancePackProps {
    /**
     * `AWS::Config::ConformancePack.ConformancePackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackname
     * @external
     */
    readonly conformancePackName: string;
    /**
     * `AWS::Config::ConformancePack.ConformancePackInputParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackinputparameters
     * @external
     */
    readonly conformancePackInputParameters?: Array<CfnConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3bucket
     * @external
     */
    readonly deliveryS3Bucket?: string;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3keyprefix
     * @external
     */
    readonly deliveryS3KeyPrefix?: string;
    /**
     * `AWS::Config::ConformancePack.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatebody
     * @external
     */
    readonly templateBody?: string;
    /**
     * `AWS::Config::ConformancePack.TemplateS3Uri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templates3uri
     * @external
     */
    readonly templateS3Uri?: string;
}
/**
 * A CloudFormation `AWS::Config::ConformancePack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 * @external
 * @cloudformationResource AWS::Config::ConformancePack
 */
export declare class CfnConformancePack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::ConformancePack";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnConformancePack;
    /**
     * `AWS::Config::ConformancePack.ConformancePackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackname
     * @external
     */
    conformancePackName: string;
    /**
     * `AWS::Config::ConformancePack.ConformancePackInputParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-conformancepackinputparameters
     * @external
     */
    conformancePackInputParameters: Array<CfnConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3bucket
     * @external
     */
    deliveryS3Bucket: string | undefined;
    /**
     * `AWS::Config::ConformancePack.DeliveryS3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-deliverys3keyprefix
     * @external
     */
    deliveryS3KeyPrefix: string | undefined;
    /**
     * `AWS::Config::ConformancePack.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templatebody
     * @external
     */
    templateBody: string | undefined;
    /**
     * `AWS::Config::ConformancePack.TemplateS3Uri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html#cfn-config-conformancepack-templates3uri
     * @external
     */
    templateS3Uri: string | undefined;
    /**
     * Create a new `AWS::Config::ConformancePack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConformancePackProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::ConformancePack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-conformancepack.html
 * @external
 * @cloudformationResource AWS::Config::ConformancePack
 */
export declare namespace CfnConformancePack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-conformancepack-conformancepackinputparameter.html
     * @external
     */
    interface ConformancePackInputParameterProperty {
        /**
         * `CfnConformancePack.ConformancePackInputParameterProperty.ParameterName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-conformancepack-conformancepackinputparameter.html#cfn-config-conformancepack-conformancepackinputparameter-parametername
         * @external
         */
        readonly parameterName: string;
        /**
         * `CfnConformancePack.ConformancePackInputParameterProperty.ParameterValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-conformancepack-conformancepackinputparameter.html#cfn-config-conformancepack-conformancepackinputparameter-parametervalue
         * @external
         */
        readonly parameterValue: string;
    }
}
/**
 * Properties for defining a `AWS::Config::DeliveryChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 * @external
 */
export interface CfnDeliveryChannelProps {
    /**
     * `AWS::Config::DeliveryChannel.S3BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3bucketname
     * @external
     */
    readonly s3BucketName: string;
    /**
     * `AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-configsnapshotdeliveryproperties
     * @external
     */
    readonly configSnapshotDeliveryProperties?: CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Config::DeliveryChannel.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::Config::DeliveryChannel.S3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3keyprefix
     * @external
     */
    readonly s3KeyPrefix?: string;
    /**
     * `AWS::Config::DeliveryChannel.SnsTopicARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-snstopicarn
     * @external
     */
    readonly snsTopicArn?: string;
}
/**
 * A CloudFormation `AWS::Config::DeliveryChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 * @external
 * @cloudformationResource AWS::Config::DeliveryChannel
 */
export declare class CfnDeliveryChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::DeliveryChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeliveryChannel;
    /**
     * `AWS::Config::DeliveryChannel.S3BucketName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3bucketname
     * @external
     */
    s3BucketName: string;
    /**
     * `AWS::Config::DeliveryChannel.ConfigSnapshotDeliveryProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-configsnapshotdeliveryproperties
     * @external
     */
    configSnapshotDeliveryProperties: CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::DeliveryChannel.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::Config::DeliveryChannel.S3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-s3keyprefix
     * @external
     */
    s3KeyPrefix: string | undefined;
    /**
     * `AWS::Config::DeliveryChannel.SnsTopicARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html#cfn-config-deliverychannel-snstopicarn
     * @external
     */
    snsTopicArn: string | undefined;
    /**
     * Create a new `AWS::Config::DeliveryChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeliveryChannelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::DeliveryChannel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-deliverychannel.html
 * @external
 * @cloudformationResource AWS::Config::DeliveryChannel
 */
export declare namespace CfnDeliveryChannel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-deliverychannel-configsnapshotdeliveryproperties.html
     * @external
     */
    interface ConfigSnapshotDeliveryPropertiesProperty {
        /**
         * `CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty.DeliveryFrequency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-deliverychannel-configsnapshotdeliveryproperties.html#cfn-config-deliverychannel-configsnapshotdeliveryproperties-deliveryfrequency
         * @external
         */
        readonly deliveryFrequency?: string;
    }
}
/**
 * Properties for defining a `AWS::Config::OrganizationConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 * @external
 */
export interface CfnOrganizationConfigRuleProps {
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationConfigRuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationconfigrulename
     * @external
     */
    readonly organizationConfigRuleName: string;
    /**
     * `AWS::Config::OrganizationConfigRule.ExcludedAccounts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-excludedaccounts
     * @external
     */
    readonly excludedAccounts?: string[];
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata
     * @external
     */
    readonly organizationCustomRuleMetadata?: CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty | cdk.IResolvable;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata
     * @external
     */
    readonly organizationManagedRuleMetadata?: CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 * @external
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 */
export declare class CfnOrganizationConfigRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::OrganizationConfigRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOrganizationConfigRule;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationConfigRuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationconfigrulename
     * @external
     */
    organizationConfigRuleName: string;
    /**
     * `AWS::Config::OrganizationConfigRule.ExcludedAccounts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-excludedaccounts
     * @external
     */
    excludedAccounts: string[] | undefined;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationCustomRuleMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata
     * @external
     */
    organizationCustomRuleMetadata: CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::OrganizationConfigRule.OrganizationManagedRuleMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata
     * @external
     */
    organizationManagedRuleMetadata: CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Config::OrganizationConfigRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOrganizationConfigRuleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 * @external
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 */
export declare namespace CfnOrganizationConfigRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html
     * @external
     */
    interface OrganizationCustomRuleMetadataProperty {
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.InputParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-inputparameters
         * @external
         */
        readonly inputParameters?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.LambdaFunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-lambdafunctionarn
         * @external
         */
        readonly lambdaFunctionArn: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.MaximumExecutionFrequency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-maximumexecutionfrequency
         * @external
         */
        readonly maximumExecutionFrequency?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.OrganizationConfigRuleTriggerTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-organizationconfigruletriggertypes
         * @external
         */
        readonly organizationConfigRuleTriggerTypes: string[];
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.ResourceIdScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourceidscope
         * @external
         */
        readonly resourceIdScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.ResourceTypesScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-resourcetypesscope
         * @external
         */
        readonly resourceTypesScope?: string[];
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.TagKeyScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagkeyscope
         * @external
         */
        readonly tagKeyScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationCustomRuleMetadataProperty.TagValueScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationcustomrulemetadata.html#cfn-config-organizationconfigrule-organizationcustomrulemetadata-tagvaluescope
         * @external
         */
        readonly tagValueScope?: string;
    }
}
/**
 * A CloudFormation `AWS::Config::OrganizationConfigRule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconfigrule.html
 * @external
 * @cloudformationResource AWS::Config::OrganizationConfigRule
 */
export declare namespace CfnOrganizationConfigRule {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html
     * @external
     */
    interface OrganizationManagedRuleMetadataProperty {
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.InputParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-inputparameters
         * @external
         */
        readonly inputParameters?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.MaximumExecutionFrequency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-maximumexecutionfrequency
         * @external
         */
        readonly maximumExecutionFrequency?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.ResourceIdScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourceidscope
         * @external
         */
        readonly resourceIdScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.ResourceTypesScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-resourcetypesscope
         * @external
         */
        readonly resourceTypesScope?: string[];
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.RuleIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-ruleidentifier
         * @external
         */
        readonly ruleIdentifier: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.TagKeyScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagkeyscope
         * @external
         */
        readonly tagKeyScope?: string;
        /**
         * `CfnOrganizationConfigRule.OrganizationManagedRuleMetadataProperty.TagValueScope`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconfigrule-organizationmanagedrulemetadata.html#cfn-config-organizationconfigrule-organizationmanagedrulemetadata-tagvaluescope
         * @external
         */
        readonly tagValueScope?: string;
    }
}
/**
 * Properties for defining a `AWS::Config::OrganizationConformancePack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 * @external
 */
export interface CfnOrganizationConformancePackProps {
    /**
     * `AWS::Config::OrganizationConformancePack.OrganizationConformancePackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-organizationconformancepackname
     * @external
     */
    readonly organizationConformancePackName: string;
    /**
     * `AWS::Config::OrganizationConformancePack.ConformancePackInputParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-conformancepackinputparameters
     * @external
     */
    readonly conformancePackInputParameters?: Array<CfnOrganizationConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3bucket
     * @external
     */
    readonly deliveryS3Bucket?: string;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3keyprefix
     * @external
     */
    readonly deliveryS3KeyPrefix?: string;
    /**
     * `AWS::Config::OrganizationConformancePack.ExcludedAccounts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-excludedaccounts
     * @external
     */
    readonly excludedAccounts?: string[];
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templatebody
     * @external
     */
    readonly templateBody?: string;
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateS3Uri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templates3uri
     * @external
     */
    readonly templateS3Uri?: string;
}
/**
 * A CloudFormation `AWS::Config::OrganizationConformancePack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 * @external
 * @cloudformationResource AWS::Config::OrganizationConformancePack
 */
export declare class CfnOrganizationConformancePack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::OrganizationConformancePack";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnOrganizationConformancePack;
    /**
     * `AWS::Config::OrganizationConformancePack.OrganizationConformancePackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-organizationconformancepackname
     * @external
     */
    organizationConformancePackName: string;
    /**
     * `AWS::Config::OrganizationConformancePack.ConformancePackInputParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-conformancepackinputparameters
     * @external
     */
    conformancePackInputParameters: Array<CfnOrganizationConformancePack.ConformancePackInputParameterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3Bucket`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3bucket
     * @external
     */
    deliveryS3Bucket: string | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.DeliveryS3KeyPrefix`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-deliverys3keyprefix
     * @external
     */
    deliveryS3KeyPrefix: string | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.ExcludedAccounts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-excludedaccounts
     * @external
     */
    excludedAccounts: string[] | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateBody`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templatebody
     * @external
     */
    templateBody: string | undefined;
    /**
     * `AWS::Config::OrganizationConformancePack.TemplateS3Uri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html#cfn-config-organizationconformancepack-templates3uri
     * @external
     */
    templateS3Uri: string | undefined;
    /**
     * Create a new `AWS::Config::OrganizationConformancePack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnOrganizationConformancePackProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::OrganizationConformancePack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-organizationconformancepack.html
 * @external
 * @cloudformationResource AWS::Config::OrganizationConformancePack
 */
export declare namespace CfnOrganizationConformancePack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconformancepack-conformancepackinputparameter.html
     * @external
     */
    interface ConformancePackInputParameterProperty {
        /**
         * `CfnOrganizationConformancePack.ConformancePackInputParameterProperty.ParameterName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconformancepack-conformancepackinputparameter.html#cfn-config-organizationconformancepack-conformancepackinputparameter-parametername
         * @external
         */
        readonly parameterName: string;
        /**
         * `CfnOrganizationConformancePack.ConformancePackInputParameterProperty.ParameterValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-organizationconformancepack-conformancepackinputparameter.html#cfn-config-organizationconformancepack-conformancepackinputparameter-parametervalue
         * @external
         */
        readonly parameterValue: string;
    }
}
/**
 * Properties for defining a `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 */
export interface CfnRemediationConfigurationProps {
    /**
     * `AWS::Config::RemediationConfiguration.ConfigRuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-configrulename
     * @external
     */
    readonly configRuleName: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetid
     * @external
     */
    readonly targetId: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targettype
     * @external
     */
    readonly targetType: string;
    /**
     * `AWS::Config::RemediationConfiguration.Automatic`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-automatic
     * @external
     */
    readonly automatic?: boolean | cdk.IResolvable;
    /**
     * `AWS::Config::RemediationConfiguration.ExecutionControls`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-executioncontrols
     * @external
     */
    readonly executionControls?: CfnRemediationConfiguration.ExecutionControlsProperty | cdk.IResolvable;
    /**
     * `AWS::Config::RemediationConfiguration.MaximumAutomaticAttempts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-maximumautomaticattempts
     * @external
     */
    readonly maximumAutomaticAttempts?: number;
    /**
     * `AWS::Config::RemediationConfiguration.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-parameters
     * @external
     */
    readonly parameters?: any | cdk.IResolvable;
    /**
     * `AWS::Config::RemediationConfiguration.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-resourcetype
     * @external
     */
    readonly resourceType?: string;
    /**
     * `AWS::Config::RemediationConfiguration.RetryAttemptSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-retryattemptseconds
     * @external
     */
    readonly retryAttemptSeconds?: number;
    /**
     * `AWS::Config::RemediationConfiguration.TargetVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetversion
     * @external
     */
    readonly targetVersion?: string;
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 */
export declare class CfnRemediationConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Config::RemediationConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRemediationConfiguration;
    /**
     * `AWS::Config::RemediationConfiguration.ConfigRuleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-configrulename
     * @external
     */
    configRuleName: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetid
     * @external
     */
    targetId: string;
    /**
     * `AWS::Config::RemediationConfiguration.TargetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targettype
     * @external
     */
    targetType: string;
    /**
     * `AWS::Config::RemediationConfiguration.Automatic`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-automatic
     * @external
     */
    automatic: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.ExecutionControls`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-executioncontrols
     * @external
     */
    executionControls: CfnRemediationConfiguration.ExecutionControlsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.MaximumAutomaticAttempts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-maximumautomaticattempts
     * @external
     */
    maximumAutomaticAttempts: number | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-parameters
     * @external
     */
    parameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.ResourceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-resourcetype
     * @external
     */
    resourceType: string | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.RetryAttemptSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-retryattemptseconds
     * @external
     */
    retryAttemptSeconds: number | undefined;
    /**
     * `AWS::Config::RemediationConfiguration.TargetVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html#cfn-config-remediationconfiguration-targetversion
     * @external
     */
    targetVersion: string | undefined;
    /**
     * Create a new `AWS::Config::RemediationConfiguration`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRemediationConfigurationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-executioncontrols.html
     * @external
     */
    interface ExecutionControlsProperty {
        /**
         * `CfnRemediationConfiguration.ExecutionControlsProperty.SsmControls`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-executioncontrols.html#cfn-config-remediationconfiguration-executioncontrols-ssmcontrols
         * @external
         */
        readonly ssmControls?: CfnRemediationConfiguration.SsmControlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-remediationparametervalue.html
     * @external
     */
    interface RemediationParameterValueProperty {
        /**
         * `CfnRemediationConfiguration.RemediationParameterValueProperty.ResourceValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-remediationparametervalue.html#cfn-config-remediationconfiguration-remediationparametervalue-resourcevalue
         * @external
         */
        readonly resourceValue?: CfnRemediationConfiguration.ResourceValueProperty | cdk.IResolvable;
        /**
         * `CfnRemediationConfiguration.RemediationParameterValueProperty.StaticValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-remediationparametervalue.html#cfn-config-remediationconfiguration-remediationparametervalue-staticvalue
         * @external
         */
        readonly staticValue?: CfnRemediationConfiguration.StaticValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-resourcevalue.html
     * @external
     */
    interface ResourceValueProperty {
        /**
         * `CfnRemediationConfiguration.ResourceValueProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-resourcevalue.html#cfn-config-remediationconfiguration-resourcevalue-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-ssmcontrols.html
     * @external
     */
    interface SsmControlsProperty {
        /**
         * `CfnRemediationConfiguration.SsmControlsProperty.ConcurrentExecutionRatePercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-ssmcontrols.html#cfn-config-remediationconfiguration-ssmcontrols-concurrentexecutionratepercentage
         * @external
         */
        readonly concurrentExecutionRatePercentage?: number;
        /**
         * `CfnRemediationConfiguration.SsmControlsProperty.ErrorPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-ssmcontrols.html#cfn-config-remediationconfiguration-ssmcontrols-errorpercentage
         * @external
         */
        readonly errorPercentage?: number;
    }
}
/**
 * A CloudFormation `AWS::Config::RemediationConfiguration`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-config-remediationconfiguration.html
 * @external
 * @cloudformationResource AWS::Config::RemediationConfiguration
 */
export declare namespace CfnRemediationConfiguration {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-staticvalue.html
     * @external
     */
    interface StaticValueProperty {
        /**
         * `CfnRemediationConfiguration.StaticValueProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-remediationconfiguration-staticvalue.html#cfn-config-remediationconfiguration-staticvalue-values
         * @external
         */
        readonly values?: string[];
    }
}
