import { IRole } from "../../aws-iam";
import * as lambda from "../../aws-lambda";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { ICustomAttribute, StandardAttributes } from './user-pool-attr';
import { UserPoolClient, UserPoolClientOptions } from './user-pool-client';
import { UserPoolDomain, UserPoolDomainOptions } from './user-pool-domain';
import { IUserPoolIdentityProvider } from './user-pool-idp';
/**
 * (experimental) The different ways in which users of this pool can sign up or sign in.
 *
 * @experimental
 */
export interface SignInAliases {
    /**
     * (experimental) Whether user is allowed to sign up or sign in with a username.
     *
     * @default true
     * @experimental
     */
    readonly username?: boolean;
    /**
     * (experimental) Whether a user is allowed to sign up or sign in with an email address.
     *
     * @default false
     * @experimental
     */
    readonly email?: boolean;
    /**
     * (experimental) Whether a user is allowed to sign up or sign in with a phone number.
     *
     * @default false
     * @experimental
     */
    readonly phone?: boolean;
    /**
     * (experimental) Whether a user is allowed to ign in with a secondary username, that can be set and modified after sign up.
     *
     * Can only be used in conjunction with `USERNAME`.
     *
     * @default false
     * @experimental
     */
    readonly preferredUsername?: boolean;
}
/**
 * (experimental) Attributes that can be automatically verified for users in a user pool.
 *
 * @experimental
 */
export interface AutoVerifiedAttrs {
    /**
     * (experimental) Whether the email address of the user should be auto verified at sign up.
     *
     * Note: If both `email` and `phone` is set, Cognito only verifies the phone number. To also verify email, see here -
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html
     *
     * @default - true, if email is turned on for `signIn`. false, otherwise.
     * @experimental
     */
    readonly email?: boolean;
    /**
     * (experimental) Whether the phone number of the user should be auto verified at sign up.
     *
     * @default - true, if phone is turned on for `signIn`. false, otherwise.
     * @experimental
     */
    readonly phone?: boolean;
}
/**
 * (experimental) Triggers for a user pool.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
 * @experimental
 */
export interface UserPoolTriggers {
    /**
     * (experimental) Creates an authentication challenge.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html
     * @experimental
     */
    readonly createAuthChallenge?: lambda.IFunction;
    /**
     * (experimental) A custom Message AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html
     * @experimental
     */
    readonly customMessage?: lambda.IFunction;
    /**
     * (experimental) Defines the authentication challenge.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html
     * @experimental
     */
    readonly defineAuthChallenge?: lambda.IFunction;
    /**
     * (experimental) A post-authentication AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html
     * @experimental
     */
    readonly postAuthentication?: lambda.IFunction;
    /**
     * (experimental) A post-confirmation AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html
     * @experimental
     */
    readonly postConfirmation?: lambda.IFunction;
    /**
     * (experimental) A pre-authentication AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html
     * @experimental
     */
    readonly preAuthentication?: lambda.IFunction;
    /**
     * (experimental) A pre-registration AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html
     * @experimental
     */
    readonly preSignUp?: lambda.IFunction;
    /**
     * (experimental) A pre-token-generation AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html
     * @experimental
     */
    readonly preTokenGeneration?: lambda.IFunction;
    /**
     * (experimental) A user-migration AWS Lambda trigger.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html
     * @experimental
     */
    readonly userMigration?: lambda.IFunction;
    /**
     * (experimental) Verifies the authentication challenge response.
     *
     * @default - no trigger configured
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html
     * @experimental
     */
    readonly verifyAuthChallengeResponse?: lambda.IFunction;
    /**
     * Index signature
     */
    [trigger: string]: lambda.IFunction | undefined;
}
/**
 * (experimental) User pool operations to which lambda triggers can be attached.
 *
 * @experimental
 */
export declare class UserPoolOperation {
    /**
     * (experimental) Creates a challenge in a custom auth flow.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html
     * @experimental
     */
    static readonly CREATE_AUTH_CHALLENGE: UserPoolOperation;
    /**
     * (experimental) Advanced customization and localization of messages.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html
     * @experimental
     */
    static readonly CUSTOM_MESSAGE: UserPoolOperation;
    /**
     * (experimental) Determines the next challenge in a custom auth flow.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html
     * @experimental
     */
    static readonly DEFINE_AUTH_CHALLENGE: UserPoolOperation;
    /**
     * (experimental) Event logging for custom analytics.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html
     * @experimental
     */
    static readonly POST_AUTHENTICATION: UserPoolOperation;
    /**
     * (experimental) Custom welcome messages or event logging for custom analytics.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html
     * @experimental
     */
    static readonly POST_CONFIRMATION: UserPoolOperation;
    /**
     * (experimental) Custom validation to accept or deny the sign-in request.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html
     * @experimental
     */
    static readonly PRE_AUTHENTICATION: UserPoolOperation;
    /**
     * (experimental) Custom validation to accept or deny the sign-up request.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html
     * @experimental
     */
    static readonly PRE_SIGN_UP: UserPoolOperation;
    /**
     * (experimental) Add or remove attributes in Id tokens.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html
     * @experimental
     */
    static readonly PRE_TOKEN_GENERATION: UserPoolOperation;
    /**
     * (experimental) Migrate a user from an existing user directory to user pools.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html
     * @experimental
     */
    static readonly USER_MIGRATION: UserPoolOperation;
    /**
     * (experimental) Determines if a response is correct in a custom auth flow.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html
     * @experimental
     */
    static readonly VERIFY_AUTH_CHALLENGE_RESPONSE: UserPoolOperation;
    /**
     * (experimental) A custom user pool operation.
     *
     * @experimental
     */
    static of(name: string): UserPoolOperation;
    /**
     * (experimental) The key to use in `CfnUserPool.LambdaConfigProperty`.
     *
     * @experimental
     */
    readonly operationName: string;
    private constructor();
}
/**
 * (experimental) The email verification style.
 *
 * @experimental
 */
export declare enum VerificationEmailStyle {
    /**
     * (experimental) Verify email via code.
     *
     * @experimental
     */
    CODE = "CONFIRM_WITH_CODE",
    /**
     * (experimental) Verify email via link.
     *
     * @experimental
     */
    LINK = "CONFIRM_WITH_LINK"
}
/**
 * (experimental) User pool configuration for user self sign up.
 *
 * @experimental
 */
export interface UserVerificationConfig {
    /**
     * (experimental) The email subject template for the verification email sent to the user upon sign up.
     *
     * See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
     * learn more about message templates.
     *
     * @default 'Verify your new account'
     * @experimental
     */
    readonly emailSubject?: string;
    /**
     * (experimental) The email body template for the verification email sent to the user upon sign up.
     *
     * See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
     * learn more about message templates.
     *
     * @default - 'The verification code to your new account is {####}' if VerificationEmailStyle.CODE is chosen,
     * 'Verify your account by clicking on {##Verify Email##}' if VerificationEmailStyle.LINK is chosen.
     * @experimental
     */
    readonly emailBody?: string;
    /**
     * (experimental) Emails can be verified either using a code or a link.
     *
     * Learn more at https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-email-verification-message-customization.html
     *
     * @default VerificationEmailStyle.CODE
     * @experimental
     */
    readonly emailStyle?: VerificationEmailStyle;
    /**
     * (experimental) The message template for the verification SMS sent to the user upon sign up.
     *
     * See https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-templates.html to
     * learn more about message templates.
     *
     * @default - 'The verification code to your new account is {####}' if VerificationEmailStyle.CODE is chosen,
     * not configured if VerificationEmailStyle.LINK is chosen
     * @experimental
     */
    readonly smsMessage?: string;
}
/**
 * (experimental) User pool configuration when administrators sign users up.
 *
 * @experimental
 */
export interface UserInvitationConfig {
    /**
     * (experimental) The template to the email subject that is sent to the user when an administrator signs them up to the user pool.
     *
     * @default 'Your temporary password'
     * @experimental
     */
    readonly emailSubject?: string;
    /**
     * (experimental) The template to the email body that is sent to the user when an administrator signs them up to the user pool.
     *
     * @default 'Your username is {username} and temporary password is {####}.'
     * @experimental
     */
    readonly emailBody?: string;
    /**
     * (experimental) The template to the SMS message that is sent to the user when an administrator signs them up to the user pool.
     *
     * @default 'Your username is {username} and temporary password is {####}'
     * @experimental
     */
    readonly smsMessage?: string;
}
/**
 * (experimental) The different ways in which a user pool's MFA enforcement can be configured.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html
 * @experimental
 */
export declare enum Mfa {
    /**
     * (experimental) Users are not required to use MFA for sign in, and cannot configure one.
     *
     * @experimental
     */
    OFF = "OFF",
    /**
     * (experimental) Users are not required to use MFA for sign in, but can configure one if they so choose to.
     *
     * @experimental
     */
    OPTIONAL = "OPTIONAL",
    /**
     * (experimental) Users are required to configure an MFA, and have to use it to sign in.
     *
     * @experimental
     */
    REQUIRED = "ON"
}
/**
 * (experimental) The different ways in which a user pool can obtain their MFA token for sign in.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html
 * @experimental
 */
export interface MfaSecondFactor {
    /**
     * (experimental) The MFA token is sent to the user via SMS to their verified phone numbers.
     *
     * @default true
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-sms-text-message.html
     * @experimental
     */
    readonly sms: boolean;
    /**
     * (experimental) The MFA token is a time-based one time password that is generated by a hardware or software token.
     *
     * @default false
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa-totp.html
     * @experimental
     */
    readonly otp: boolean;
}
/**
 * (experimental) Password policy for User Pools.
 *
 * @experimental
 */
export interface PasswordPolicy {
    /**
     * (experimental) The length of time the temporary password generated by an admin is valid.
     *
     * This must be provided as whole days, like Duration.days(3) or Duration.hours(48).
     * Fractional days, such as Duration.hours(20), will generate an error.
     *
     * @default Duration.days(7)
     * @experimental
     */
    readonly tempPasswordValidity?: Duration;
    /**
     * (experimental) Minimum length required for a user's password.
     *
     * @default 8
     * @experimental
     */
    readonly minLength?: number;
    /**
     * (experimental) Whether the user is required to have lowercase characters in their password.
     *
     * @default true
     * @experimental
     */
    readonly requireLowercase?: boolean;
    /**
     * (experimental) Whether the user is required to have uppercase characters in their password.
     *
     * @default true
     * @experimental
     */
    readonly requireUppercase?: boolean;
    /**
     * (experimental) Whether the user is required to have digits in their password.
     *
     * @default true
     * @experimental
     */
    readonly requireDigits?: boolean;
    /**
     * (experimental) Whether the user is required to have symbols in their password.
     *
     * @default true
     * @experimental
     */
    readonly requireSymbols?: boolean;
}
/**
 * (experimental) Email settings for the user pool.
 *
 * @experimental
 */
export interface EmailSettings {
    /**
     * (experimental) The 'from' address on the emails received by the user.
     *
     * @default noreply
     * @experimental
     * @verificationemail .com
     */
    readonly from?: string;
    /**
     * (experimental) The 'replyTo' address on the emails received by the user as defined by IETF RFC-5322.
     *
     * When set, most email clients recognize to change 'to' line to this address when a reply is drafted.
     *
     * @default - Not set.
     * @experimental
     */
    readonly replyTo?: string;
}
/**
 * (experimental) How will a user be able to recover their account?
 *
 * When a user forgets their password, they can have a code sent to their verified email or verified phone to recover their account.
 * You can choose the preferred way to send codes below.
 * We recommend not allowing phone to be used for both password resets and multi-factor authentication (MFA).
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html
 * @experimental
 */
export declare enum AccountRecovery {
    /**
     * (experimental) Email if available, otherwise phone, but don’t allow a user to reset their password via phone if they are also using it for MFA.
     *
     * @experimental
     */
    EMAIL_AND_PHONE_WITHOUT_MFA = 0,
    /**
     * (experimental) Phone if available, otherwise email, but don’t allow a user to reset their password via phone if they are also using it for MFA.
     *
     * @experimental
     */
    PHONE_WITHOUT_MFA_AND_EMAIL = 1,
    /**
     * (experimental) Email only.
     *
     * @experimental
     */
    EMAIL_ONLY = 2,
    /**
     * (experimental) Phone only, but don’t allow a user to reset their password via phone if they are also using it for MFA.
     *
     * @experimental
     */
    PHONE_ONLY_WITHOUT_MFA = 3,
    /**
     * (experimental) (Not Recommended) Phone if available, otherwise email, and do allow a user to reset their password via phone if they are also using it for MFA.
     *
     * @experimental
     */
    PHONE_AND_EMAIL = 4,
    /**
     * (experimental) None – users will have to contact an administrator to reset their passwords.
     *
     * @experimental
     */
    NONE = 5
}
/**
 * (experimental) Props for the UserPool construct.
 *
 * @experimental
 */
export interface UserPoolProps {
    /**
     * (experimental) Name of the user pool.
     *
     * @default - automatically generated name by CloudFormation at deploy time
     * @experimental
     */
    readonly userPoolName?: string;
    /**
     * (experimental) Whether self sign up should be enabled.
     *
     * This can be further configured via the `selfSignUp` property.
     *
     * @default false
     * @experimental
     */
    readonly selfSignUpEnabled?: boolean;
    /**
     * (experimental) Configuration around users signing themselves up to the user pool.
     *
     * Enable or disable self sign-up via the `selfSignUpEnabled` property.
     *
     * @default - see defaults in UserVerificationConfig
     * @experimental
     */
    readonly userVerification?: UserVerificationConfig;
    /**
     * (experimental) Configuration around admins signing up users into a user pool.
     *
     * @default - see defaults in UserInvitationConfig
     * @experimental
     */
    readonly userInvitation?: UserInvitationConfig;
    /**
     * (experimental) The IAM role that Cognito will assume while sending SMS messages.
     *
     * @default - a new IAM role is created
     * @experimental
     */
    readonly smsRole?: IRole;
    /**
     * (experimental) The 'ExternalId' that Cognito service must using when assuming the `smsRole`, if the role is restricted with an 'sts:ExternalId' conditional.
     *
     * Learn more about ExternalId here - https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html
     *
     * This property will be ignored if `smsRole` is not specified.
     *
     * @default - No external id will be configured
     * @experimental
     */
    readonly smsRoleExternalId?: string;
    /**
     * (experimental) Setting this would explicitly enable or disable SMS role creation.
     *
     * When left unspecified, CDK will determine based on other properties if a role is needed or not.
     *
     * @default - CDK will determine based on other properties of the user pool if an SMS role should be created or not.
     * @experimental
     */
    readonly enableSmsRole?: boolean;
    /**
     * (experimental) Methods in which a user registers or signs in to a user pool.
     *
     * Allows either username with aliases OR sign in with email, phone, or both.
     *
     * Read the sections on usernames and aliases to learn more -
     * https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
     *
     * To match with 'Option 1' in the above link, with a verified email, this property should be set to
     * `{ username: true, email: true }`. To match with 'Option 2' in the above link with both a verified email and phone
     * number, this property should be set to `{ email: true, phone: true }`.
     *
     * @default { username: true }
     * @experimental
     */
    readonly signInAliases?: SignInAliases;
    /**
     * (experimental) Attributes which Cognito will look to verify automatically upon user sign up.
     *
     * EMAIL and PHONE are the only available options.
     *
     * @default - If `signInAlias` includes email and/or phone, they will be included in `autoVerifiedAttributes` by default.
     * If absent, no attributes will be auto-verified.
     * @experimental
     */
    readonly autoVerify?: AutoVerifiedAttrs;
    /**
     * (experimental) The set of attributes that are required for every user in the user pool.
     *
     * Read more on attributes here - https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html
     *
     * @default - All standard attributes are optional and mutable.
     * @experimental
     */
    readonly standardAttributes?: StandardAttributes;
    /**
     * (experimental) Define a set of custom attributes that can be configured for each user in the user pool.
     *
     * @default - No custom attributes.
     * @experimental
     */
    readonly customAttributes?: {
        [key: string]: ICustomAttribute;
    };
    /**
     * (experimental) Configure whether users of this user pool can or are required use MFA to sign in.
     *
     * @default Mfa.OFF
     * @experimental
     */
    readonly mfa?: Mfa;
    /**
     * (experimental) Configure the MFA types that users can use in this user pool.
     *
     * Ignored if `mfa` is set to `OFF`.
     *
     * @default - { sms: true, oneTimePassword: false }, if `mfa` is set to `OPTIONAL` or `REQUIRED`.
     * { sms: false, oneTimePassword: false }, otherwise
     * @experimental
     */
    readonly mfaSecondFactor?: MfaSecondFactor;
    /**
     * (experimental) Password policy for this user pool.
     *
     * @default - see defaults on each property of PasswordPolicy.
     * @experimental
     */
    readonly passwordPolicy?: PasswordPolicy;
    /**
     * (experimental) Email settings for a user pool.
     *
     * @default - see defaults on each property of EmailSettings.
     * @experimental
     */
    readonly emailSettings?: EmailSettings;
    /**
     * (experimental) Lambda functions to use for supported Cognito triggers.
     *
     * @default - No Lambda triggers.
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
     * @experimental
     */
    readonly lambdaTriggers?: UserPoolTriggers;
    /**
     * (experimental) Whether sign-in aliases should be evaluated with case sensitivity.
     *
     * For example, when this option is set to false, users will be able to sign in using either `MyUsername` or `myusername`.
     *
     * @default true
     * @experimental
     */
    readonly signInCaseSensitive?: boolean;
    /**
     * (experimental) How will a user be able to recover their account?
     *
     * @default AccountRecovery.PHONE_WITHOUT_MFA_AND_EMAIL
     * @experimental
     */
    readonly accountRecovery?: AccountRecovery;
}
/**
 * (experimental) Represents a Cognito UserPool.
 *
 * @experimental
 */
export interface IUserPool extends IResource {
    /**
     * (experimental) The physical ID of this user pool resource.
     *
     * @experimental
     * @attribute true
     */
    readonly userPoolId: string;
    /**
     * (experimental) The ARN of this user pool resource.
     *
     * @experimental
     * @attribute true
     */
    readonly userPoolArn: string;
    /**
     * (experimental) Get all identity providers registered with this user pool.
     *
     * @experimental
     */
    readonly identityProviders: IUserPoolIdentityProvider[];
    /**
     * (experimental) Add a new app client to this user pool.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html
     * @experimental
     */
    addClient(id: string, options?: UserPoolClientOptions): UserPoolClient;
    /**
     * (experimental) Associate a domain to this user pool.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html
     * @experimental
     */
    addDomain(id: string, options: UserPoolDomainOptions): UserPoolDomain;
    /**
     * (experimental) Register an identity provider with this user pool.
     *
     * @experimental
     */
    registerIdentityProvider(provider: IUserPoolIdentityProvider): void;
}
declare abstract class UserPoolBase extends Resource implements IUserPool {
    abstract readonly userPoolId: string;
    abstract readonly userPoolArn: string;
    /**
     * (experimental) Get all identity providers registered with this user pool.
     *
     * @experimental
     */
    readonly identityProviders: IUserPoolIdentityProvider[];
    /**
     * (experimental) Add a new app client to this user pool.
     *
     * @experimental
     */
    addClient(id: string, options?: UserPoolClientOptions): UserPoolClient;
    /**
     * (experimental) Associate a domain to this user pool.
     *
     * @experimental
     */
    addDomain(id: string, options: UserPoolDomainOptions): UserPoolDomain;
    /**
     * (experimental) Register an identity provider with this user pool.
     *
     * @experimental
     */
    registerIdentityProvider(provider: IUserPoolIdentityProvider): void;
}
/**
 * (experimental) Define a Cognito User Pool.
 *
 * @experimental
 */
export declare class UserPool extends UserPoolBase {
    /**
     * (experimental) Import an existing user pool based on its id.
     *
     * @experimental
     */
    static fromUserPoolId(scope: Construct, id: string, userPoolId: string): IUserPool;
    /**
     * (experimental) Import an existing user pool based on its ARN.
     *
     * @experimental
     */
    static fromUserPoolArn(scope: Construct, id: string, userPoolArn: string): IUserPool;
    /**
     * (experimental) The physical ID of this user pool resource.
     *
     * @experimental
     */
    readonly userPoolId: string;
    /**
     * (experimental) The ARN of the user pool.
     *
     * @experimental
     */
    readonly userPoolArn: string;
    /**
     * (experimental) User pool provider name.
     *
     * @experimental
     * @attribute true
     */
    readonly userPoolProviderName: string;
    /**
     * (experimental) User pool provider URL.
     *
     * @experimental
     * @attribute true
     */
    readonly userPoolProviderUrl: string;
    private triggers;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: UserPoolProps);
    /**
     * (experimental) Add a lambda trigger to a user pool operation.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html
     * @experimental
     */
    addTrigger(operation: UserPoolOperation, fn: lambda.IFunction): void;
    private addLambdaPermission;
    private verificationMessageConfiguration;
    private signInConfiguration;
    private smsConfiguration;
    private mfaConfiguration;
    private configurePasswordPolicy;
    private schemaConfiguration;
    private accountRecovery;
}
export {};
