"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolIdentityProviderGoogle = exports.UserPoolIdentityProviderFacebook = exports.UserPoolIdentityProviderAmazon = exports.ProviderAttribute = exports.UserPoolIdentityProvider = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cognito_generated_1 = require("./cognito.generated");
const attr_names_1 = require("./private/attr-names");
/**
 * (experimental) User pool third-party identity providers.
 *
 * @experimental
 */
class UserPoolIdentityProvider {
    /**
     * (experimental) Import an existing UserPoolIdentityProvider.
     *
     * @experimental
     */
    static fromProviderName(scope, id, providerName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.providerName = providerName;
            }
        }
        return new Import(scope, id);
    }
    constructor() { }
}
exports.UserPoolIdentityProvider = UserPoolIdentityProvider;
/**
 * (experimental) An attribute available from a third party identity provider.
 *
 * @experimental
 */
class ProviderAttribute {
    constructor(attributeName) {
        this.attributeName = attributeName;
    }
    /**
     * (experimental) Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     *
     * @param attributeName the attribute value string as recognized by the provider.
     * @experimental
     */
    static other(attributeName) {
        return new ProviderAttribute(attributeName);
    }
}
exports.ProviderAttribute = ProviderAttribute;
/**
 * (experimental) The user id attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_USER_ID = new ProviderAttribute('user_id');
/**
 * (experimental) The email attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_EMAIL = new ProviderAttribute('email');
/**
 * (experimental) The name attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_NAME = new ProviderAttribute('name');
/**
 * (experimental) The postal code attribute provided by Amazon.
 *
 * @experimental
 */
ProviderAttribute.AMAZON_POSTAL_CODE = new ProviderAttribute('postal_code');
/**
 * (experimental) The user id attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_ID = new ProviderAttribute('id');
/**
 * (experimental) The birthday attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_BIRTHDAY = new ProviderAttribute('birthday');
/**
 * (experimental) The email attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_EMAIL = new ProviderAttribute('email');
/**
 * (experimental) The name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_NAME = new ProviderAttribute('name');
/**
 * (experimental) The first name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_FIRST_NAME = new ProviderAttribute('first_name');
/**
 * (experimental) The last name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_LAST_NAME = new ProviderAttribute('last_name');
/**
 * (experimental) The middle name attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_MIDDLE_NAME = new ProviderAttribute('middle_name');
/**
 * (experimental) The gender attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_GENDER = new ProviderAttribute('gender');
/**
 * (experimental) The locale attribute provided by Facebook.
 *
 * @experimental
 */
ProviderAttribute.FACEBOOK_LOCALE = new ProviderAttribute('locale');
/**
 * (experimental) The name attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_NAMES = new ProviderAttribute('names');
/**
 * (experimental) The gender attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_GENDER = new ProviderAttribute('gender');
/**
 * (experimental) The birthday attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_BIRTHDAYS = new ProviderAttribute('birthdays');
/**
 * (experimental) The birthday attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_PHONE_NUMBERS = new ProviderAttribute('phoneNumbers');
/**
 * (experimental) The email attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_EMAIL = new ProviderAttribute('email');
/**
 * (experimental) The name attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_NAME = new ProviderAttribute('name');
/**
 * (experimental) The email attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_PICTURE = new ProviderAttribute('picture');
/**
 * (experimental) The email attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_GIVEN_NAME = new ProviderAttribute('given_name');
/**
 * (experimental) The email attribute provided by Google.
 *
 * @experimental
 */
ProviderAttribute.GOOGLE_FAMILY_NAME = new ProviderAttribute('family_name');
/**
 * Options to integrate with the various social identity providers.
 */
class UserPoolIdentityProviderBase extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        props.userPool.registerIdentityProvider(this);
    }
    /**
     * @experimental
     */
    configureAttributeMapping() {
        if (!this.props.attributeMapping) {
            return undefined;
        }
        let mapping = {};
        mapping = Object.entries(this.props.attributeMapping)
            .filter(([k, _]) => k !== 'custom') // 'custom' handled later separately
            .reduce((agg, [k, v]) => {
            return { ...agg, [attr_names_1.StandardAttributeNames[k]]: v.attributeName };
        }, mapping);
        if (this.props.attributeMapping.custom) {
            mapping = Object.entries(this.props.attributeMapping.custom).reduce((agg, [k, v]) => {
                return { ...agg, [k]: v.attributeName };
            }, mapping);
        }
        if (Object.keys(mapping).length === 0) {
            return undefined;
        }
        return mapping;
    }
}
/**
 * (experimental) Represents a identity provider that integrates with 'Login with Amazon'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderAmazon extends UserPoolIdentityProviderBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'LoginWithAmazon',
            providerType: 'LoginWithAmazon',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderAmazon = UserPoolIdentityProviderAmazon;
/**
 * (experimental) Represents a identity provider that integrates with 'Facebook Login'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderFacebook extends UserPoolIdentityProviderBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['public_profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'Facebook',
            providerType: 'Facebook',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(','),
                api_version: props.apiVersion,
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderFacebook = UserPoolIdentityProviderFacebook;
/**
 * (experimental) Represents a identity provider that integrates with 'Google'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
class UserPoolIdentityProviderGoogle extends UserPoolIdentityProviderBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id, props);
        const scopes = (_a = props.scopes) !== null && _a !== void 0 ? _a : ['profile'];
        const resource = new cognito_generated_1.CfnUserPoolIdentityProvider(this, 'Resource', {
            userPoolId: props.userPool.userPoolId,
            providerName: 'Google',
            providerType: 'Google',
            providerDetails: {
                client_id: props.clientId,
                client_secret: props.clientSecret,
                authorize_scopes: scopes.join(' '),
            },
            attributeMapping: super.configureAttributeMapping(),
        });
        this.providerName = super.getResourceNameAttribute(resource.ref);
    }
}
exports.UserPoolIdentityProviderGoogle = UserPoolIdentityProviderGoogle;
//# sourceMappingURL=data:application/json;base64,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