import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IUserPool } from './user-pool';
/**
 * (experimental) Represents a UserPoolIdentityProvider.
 *
 * @experimental
 */
export interface IUserPoolIdentityProvider extends IResource {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     * @attribute true
     */
    readonly providerName: string;
}
/**
 * (experimental) User pool third-party identity providers.
 *
 * @experimental
 */
export declare class UserPoolIdentityProvider {
    /**
     * (experimental) Import an existing UserPoolIdentityProvider.
     *
     * @experimental
     */
    static fromProviderName(scope: Construct, id: string, providerName: string): IUserPoolIdentityProvider;
    private constructor();
}
/**
 * (experimental) An attribute available from a third party identity provider.
 *
 * @experimental
 */
export declare class ProviderAttribute {
    /**
     * (experimental) The user id attribute provided by Amazon.
     *
     * @experimental
     */
    static readonly AMAZON_USER_ID: ProviderAttribute;
    /**
     * (experimental) The email attribute provided by Amazon.
     *
     * @experimental
     */
    static readonly AMAZON_EMAIL: ProviderAttribute;
    /**
     * (experimental) The name attribute provided by Amazon.
     *
     * @experimental
     */
    static readonly AMAZON_NAME: ProviderAttribute;
    /**
     * (experimental) The postal code attribute provided by Amazon.
     *
     * @experimental
     */
    static readonly AMAZON_POSTAL_CODE: ProviderAttribute;
    /**
     * (experimental) The user id attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_ID: ProviderAttribute;
    /**
     * (experimental) The birthday attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_BIRTHDAY: ProviderAttribute;
    /**
     * (experimental) The email attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_EMAIL: ProviderAttribute;
    /**
     * (experimental) The name attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_NAME: ProviderAttribute;
    /**
     * (experimental) The first name attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_FIRST_NAME: ProviderAttribute;
    /**
     * (experimental) The last name attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_LAST_NAME: ProviderAttribute;
    /**
     * (experimental) The middle name attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_MIDDLE_NAME: ProviderAttribute;
    /**
     * (experimental) The gender attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_GENDER: ProviderAttribute;
    /**
     * (experimental) The locale attribute provided by Facebook.
     *
     * @experimental
     */
    static readonly FACEBOOK_LOCALE: ProviderAttribute;
    /**
     * (experimental) The name attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_NAMES: ProviderAttribute;
    /**
     * (experimental) The gender attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_GENDER: ProviderAttribute;
    /**
     * (experimental) The birthday attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_BIRTHDAYS: ProviderAttribute;
    /**
     * (experimental) The birthday attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_PHONE_NUMBERS: ProviderAttribute;
    /**
     * (experimental) The email attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_EMAIL: ProviderAttribute;
    /**
     * (experimental) The name attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_NAME: ProviderAttribute;
    /**
     * (experimental) The email attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_PICTURE: ProviderAttribute;
    /**
     * (experimental) The email attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_GIVEN_NAME: ProviderAttribute;
    /**
     * (experimental) The email attribute provided by Google.
     *
     * @experimental
     */
    static readonly GOOGLE_FAMILY_NAME: ProviderAttribute;
    /**
     * (experimental) Use this to specify an attribute from the identity provider that is not pre-defined in the CDK.
     *
     * @param attributeName the attribute value string as recognized by the provider.
     * @experimental
     */
    static other(attributeName: string): ProviderAttribute;
    /**
     * (experimental) The attribute value string as recognized by the provider.
     *
     * @experimental
     */
    readonly attributeName: string;
    private constructor();
}
/**
 * (experimental) The mapping of user pool attributes to the attributes provided by the identity providers.
 *
 * @experimental
 */
export interface AttributeMapping {
    /**
     * (experimental) The user's postal address is a required attribute.
     *
     * @default - not mapped
     * @experimental
     */
    readonly address?: ProviderAttribute;
    /**
     * (experimental) The user's birthday.
     *
     * @default - not mapped
     * @experimental
     */
    readonly birthdate?: ProviderAttribute;
    /**
     * (experimental) The user's e-mail address.
     *
     * @default - not mapped
     * @experimental
     */
    readonly email?: ProviderAttribute;
    /**
     * (experimental) The surname or last name of user.
     *
     * @default - not mapped
     * @experimental
     */
    readonly familyName?: ProviderAttribute;
    /**
     * (experimental) The user's gender.
     *
     * @default - not mapped
     * @experimental
     */
    readonly gender?: ProviderAttribute;
    /**
     * (experimental) The user's first name or give name.
     *
     * @default - not mapped
     * @experimental
     */
    readonly givenName?: ProviderAttribute;
    /**
     * (experimental) The user's locale.
     *
     * @default - not mapped
     * @experimental
     */
    readonly locale?: ProviderAttribute;
    /**
     * (experimental) The user's middle name.
     *
     * @default - not mapped
     * @experimental
     */
    readonly middleName?: ProviderAttribute;
    /**
     * (experimental) The user's full name in displayable form.
     *
     * @default - not mapped
     * @experimental
     */
    readonly fullname?: ProviderAttribute;
    /**
     * (experimental) The user's nickname or casual name.
     *
     * @default - not mapped
     * @experimental
     */
    readonly nickname?: ProviderAttribute;
    /**
     * (experimental) The user's telephone number.
     *
     * @default - not mapped
     * @experimental
     */
    readonly phoneNumber?: ProviderAttribute;
    /**
     * (experimental) The URL to the user's profile picture.
     *
     * @default - not mapped
     * @experimental
     */
    readonly profilePicture?: ProviderAttribute;
    /**
     * (experimental) The user's preferred username.
     *
     * @default - not mapped
     * @experimental
     */
    readonly preferredUsername?: ProviderAttribute;
    /**
     * (experimental) The URL to the user's profile page.
     *
     * @default - not mapped
     * @experimental
     */
    readonly profilePage?: ProviderAttribute;
    /**
     * (experimental) The user's time zone.
     *
     * @default - not mapped
     * @experimental
     */
    readonly timezone?: ProviderAttribute;
    /**
     * (experimental) Time, the user's information was last updated.
     *
     * @default - not mapped
     * @experimental
     */
    readonly lastUpdateTime?: ProviderAttribute;
    /**
     * (experimental) The URL to the user's web page or blog.
     *
     * @default - not mapped
     * @experimental
     */
    readonly website?: ProviderAttribute;
    /**
     * (experimental) Specify custom attribute mapping here and mapping for any standard attributes not supported yet.
     *
     * @default - no custom attribute mapping
     * @experimental
     */
    readonly custom?: {
        [key: string]: ProviderAttribute;
    };
}
/**
 * (experimental) Properties to create a new instance of UserPoolIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderProps {
    /**
     * (experimental) The user pool to which this construct provides identities.
     *
     * @experimental
     */
    readonly userPool: IUserPool;
    /**
     * (experimental) Mapping attributes from the identity provider to standard and custom attributes of the user pool.
     *
     * @default - no attribute mapping
     * @experimental
     */
    readonly attributeMapping?: AttributeMapping;
}
/**
 * Options to integrate with the various social identity providers.
 */
declare abstract class UserPoolIdentityProviderBase extends Resource implements IUserPoolIdentityProvider {
    private readonly props;
    abstract readonly providerName: string;
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderProps);
    /**
     * @experimental
     */
    protected configureAttributeMapping(): any;
}
/**
 * (experimental) Properties to initialize UserPoolAmazonIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderAmazonProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by 'Login with Amazon' APIs.
     *
     * @see https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret to be accompanied with clientId for 'Login with Amazon' APIs to authenticate the client.
     *
     * @see https://developer.amazon.com/docs/login-with-amazon/security-profile.html#client-identifier
     * @experimental
     */
    readonly clientSecret: string;
    /**
     * (experimental) The types of user profile data to obtain for the Amazon profile.
     *
     * @default [ profile ]
     * @see https://developer.amazon.com/docs/login-with-amazon/customer-profile.html
     * @experimental
     */
    readonly scopes?: string[];
}
/**
 * (experimental) Represents a identity provider that integrates with 'Login with Amazon'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderAmazon extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderAmazonProps);
}
/**
 * (experimental) Properties to initialize UserPoolFacebookIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderFacebookProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by Facebook APIs.
     *
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret to be accompanied with clientUd for Facebook to authenticate the client.
     *
     * @see https://developers.facebook.com/docs/facebook-login/security#appsecret
     * @experimental
     */
    readonly clientSecret: string;
    /**
     * (experimental) The list of facebook permissions to obtain for getting access to the Facebook profile.
     *
     * @default [ public_profile ]
     * @see https://developers.facebook.com/docs/facebook-login/permissions
     * @experimental
     */
    readonly scopes?: string[];
    /**
     * (experimental) The Facebook API version to use.
     *
     * @default - to the oldest version supported by Facebook
     * @experimental
     */
    readonly apiVersion?: string;
}
/**
 * (experimental) Represents a identity provider that integrates with 'Facebook Login'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderFacebook extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderFacebookProps);
}
/**
 * (experimental) Properties to initialize UserPoolGoogleIdentityProvider.
 *
 * @experimental
 */
export interface UserPoolIdentityProviderGoogleProps extends UserPoolIdentityProviderProps {
    /**
     * (experimental) The client id recognized by Google APIs.
     *
     * @see https://developers.google.com/identity/sign-in/web/sign-in#specify_your_apps_client_id
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret to be accompanied with clientId for Google APIs to authenticate the client.
     *
     * @see https://developers.google.com/identity/sign-in/web/sign-in
     * @experimental
     */
    readonly clientSecret: string;
    /**
     * (experimental) The list of google permissions to obtain for getting access to the google profile.
     *
     * @default [ profile ]
     * @see https://developers.google.com/identity/sign-in/web/sign-in
     * @experimental
     */
    readonly scopes?: string[];
}
/**
 * (experimental) Represents a identity provider that integrates with 'Google'.
 *
 * @experimental
 * @resource AWS::Cognito::UserPoolIdentityProvider
 */
export declare class UserPoolIdentityProviderGoogle extends UserPoolIdentityProviderBase {
    /**
     * (experimental) The primary identifier of this identity provider.
     *
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolIdentityProviderGoogleProps);
}
export {};
