import { ICertificate } from "../../aws-certificatemanager";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IUserPool } from './user-pool';
import { UserPoolClient } from './user-pool-client';
/**
 * (experimental) Represents a user pool domain.
 *
 * @experimental
 */
export interface IUserPoolDomain extends IResource {
    /**
     * (experimental) The domain that was specified to be created.
     *
     * If `customDomain` was selected, this holds the full domain name that was specified.
     * If the `cognitoDomain` was used, it contains the prefix to the Cognito hosted domain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainName: string;
}
/**
 * (experimental) Options while specifying custom domain.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
 * @experimental
 */
export interface CustomDomainOptions {
    /**
     * (experimental) The custom domain name that you would like to associate with this User Pool.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The certificate to associate with this domain.
     *
     * @experimental
     */
    readonly certificate: ICertificate;
}
/**
 * (experimental) Options while specifying a cognito prefix domain.
 *
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html
 * @experimental
 */
export interface CognitoDomainOptions {
    /**
     * (experimental) The prefix to the Cognito hosted domain name that will be associated with the user pool.
     *
     * @experimental
     */
    readonly domainPrefix: string;
}
/**
 * (experimental) Options to create a UserPoolDomain.
 *
 * @experimental
 */
export interface UserPoolDomainOptions {
    /**
     * (experimental) Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
     *
     * @default - not set if `cognitoDomain` is specified, otherwise, throws an error.
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
     * @experimental
     */
    readonly customDomain?: CustomDomainOptions;
    /**
     * (experimental) Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
     *
     * @default - not set if `customDomain` is specified, otherwise, throws an error.
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html
     * @experimental
     */
    readonly cognitoDomain?: CognitoDomainOptions;
}
/**
 * (experimental) Props for UserPoolDomain construct.
 *
 * @experimental
 */
export interface UserPoolDomainProps extends UserPoolDomainOptions {
    /**
     * (experimental) The user pool to which this domain should be associated.
     *
     * @experimental
     */
    readonly userPool: IUserPool;
}
/**
 * (experimental) Define a user pool domain.
 *
 * @experimental
 */
export declare class UserPoolDomain extends Resource implements IUserPoolDomain {
    /**
     * (experimental) Import a UserPoolDomain given its domain name.
     *
     * @experimental
     */
    static fromDomainName(scope: Construct, id: string, userPoolDomainName: string): IUserPoolDomain;
    /**
     * (experimental) The domain that was specified to be created.
     *
     * If `customDomain` was selected, this holds the full domain name that was specified.
     * If the `cognitoDomain` was used, it contains the prefix to the Cognito hosted domain.
     *
     * @experimental
     */
    readonly domainName: string;
    private isCognitoDomain;
    private cloudFrontCustomResource?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserPoolDomainProps);
    /**
     * (experimental) The domain name of the CloudFront distribution associated with the user pool domain.
     *
     * @experimental
     */
    get cloudFrontDomainName(): string;
    /**
     * (experimental) The URL to the hosted UI associated with this domain.
     *
     * @experimental
     */
    baseUrl(): string;
    /**
     * (experimental) The URL to the sign in page in this domain using a specific UserPoolClient.
     *
     * @param client [disable-awslint:ref-via-interface] the user pool client that the UI will use to interact with the UserPool.
     * @param options options to customize the behaviour of this method.
     * @experimental
     */
    signInUrl(client: UserPoolClient, options: SignInUrlOptions): string;
}
/**
 * (experimental) Options to customize the behaviour of `signInUrl()`.
 *
 * @experimental
 */
export interface SignInUrlOptions {
    /**
     * (experimental) Where to redirect to after sign in.
     *
     * @experimental
     */
    readonly redirectUri: string;
    /**
     * (experimental) The path in the URI where the sign-in page is located.
     *
     * @default '/login'
     * @experimental
     */
    readonly signInPath?: string;
}
