"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codestar = require("./codestar.generated");
/**
 * (experimental) The GitHubRepository resource.
 *
 * @experimental
 */
class GitHubRepository extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.toString(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_a = props.enableIssues) !== null && _a !== void 0 ? _a : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
/**
 * (experimental) Visibility of the GitHubRepository.
 *
 * @experimental
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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