import * as codepipeline from "../../../aws-codepipeline";
import * as s3 from "../../../aws-s3";
import { Construct, Duration } from "../../../core";
import { Action } from '../action';
/**
 * (experimental) Used for HTTP cache-control header, which influences downstream caches.
 *
 * Use the provided static factory methods to construct instances of this class.
 * Used in the {@link S3DeployActionProps.cacheControl} property.
 *
 * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9
 * @experimental
 */
export declare class CacheControl {
    value: string;
    /**
     * (experimental) The 'must-revalidate' cache control directive.
     *
     * @experimental
     */
    static mustRevalidate(): CacheControl;
    /**
     * (experimental) The 'no-cache' cache control directive.
     *
     * @experimental
     */
    static noCache(): CacheControl;
    /**
     * (experimental) The 'no-transform' cache control directive.
     *
     * @experimental
     */
    static noTransform(): CacheControl;
    /**
     * (experimental) The 'public' cache control directive.
     *
     * @experimental
     */
    static setPublic(): CacheControl;
    /**
     * (experimental) The 'private' cache control directive.
     *
     * @experimental
     */
    static setPrivate(): CacheControl;
    /**
     * (experimental) The 'proxy-revalidate' cache control directive.
     *
     * @experimental
     */
    static proxyRevalidate(): CacheControl;
    /**
     * (experimental) The 'max-age' cache control directive.
     *
     * @experimental
     */
    static maxAge(t: Duration): CacheControl;
    /**
     * (experimental) The 's-max-age' cache control directive.
     *
     * @experimental
     */
    static sMaxAge(t: Duration): CacheControl;
    /**
     * (experimental) Allows you to create an arbitrary cache control directive, in case our support is missing a method for a particular directive.
     *
     * @experimental
     */
    static fromString(s: string): CacheControl;
    /** @param value the actual text value of the created directive */
    private constructor();
}
/**
 * (experimental) Construction properties of the {@link S3DeployAction S3 deploy Action}.
 *
 * @experimental
 */
export interface S3DeployActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) Should the deploy action extract the artifact before deploying to Amazon S3.
     *
     * @default true
     * @experimental
     */
    readonly extract?: boolean;
    /**
     * (experimental) The key of the target object.
     *
     * This is required if extract is false.
     *
     * @experimental
     */
    readonly objectKey?: string;
    /**
     * (experimental) The input Artifact to deploy to Amazon S3.
     *
     * @experimental
     */
    readonly input: codepipeline.Artifact;
    /**
     * (experimental) The Amazon S3 bucket that is the deploy target.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
    /**
     * (experimental) The specified canned ACL to objects deployed to Amazon S3.
     *
     * This overwrites any existing ACL that was applied to the object.
     *
     * @default - the original object ACL
     * @experimental
     */
    readonly accessControl?: s3.BucketAccessControl;
    /**
     * (experimental) The caching behavior for requests/responses for objects in the bucket.
     *
     * The final cache control property will be the result of joining all of the provided array elements with a comma
     * (plus a space after the comma).
     *
     * @default - none, decided by the HTTP client
     * @experimental
     */
    readonly cacheControl?: CacheControl[];
}
/**
 * (experimental) Deploys the sourceArtifact to Amazon S3.
 *
 * @experimental
 */
export declare class S3DeployAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: S3DeployActionProps);
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
