import * as codepipeline from "../../aws-codepipeline";
import * as sns from "../../aws-sns";
import * as cdk from "../../core";
import { Action } from './action';
/**
 * (experimental) Construction properties of the {@link ManualApprovalAction}.
 *
 * @experimental
 */
export interface ManualApprovalActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * (experimental) Optional SNS topic to send notifications to when an approval is pending.
     *
     * @experimental
     */
    readonly notificationTopic?: sns.ITopic;
    /**
     * (experimental) A list of email addresses to subscribe to notifications when this Action is pending approval.
     *
     * If this has been provided, but not `notificationTopic`,
     * a new Topic will be created.
     *
     * @experimental
     */
    readonly notifyEmails?: string[];
    /**
     * (experimental) Any additional information that you want to include in the notification email message.
     *
     * @experimental
     */
    readonly additionalInformation?: string;
    /**
     * (experimental) URL you want to provide to the reviewer as part of the approval request.
     *
     * @default - the approval request will not have an external link
     * @experimental
     */
    readonly externalEntityLink?: string;
}
/**
 * (experimental) Manual approval action.
 *
 * @experimental
 */
export declare class ManualApprovalAction extends Action {
    /**
     * The SNS Topic passed when constructing the Action.
     * If no Topic was passed, but `notifyEmails` were provided,
     * a new Topic will be created.
     */
    private _notificationTopic?;
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: ManualApprovalActionProps);
    /**
     * @experimental
     */
    get notificationTopic(): sns.ITopic | undefined;
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(scope: cdk.Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
