import * as codepipeline from "../../../aws-codepipeline";
import * as cdk from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A Jenkins provider.
 *
 * If you want to create a new Jenkins provider managed alongside your CDK code,
 * instantiate the {@link JenkinsProvider} class directly.
 *
 * If you want to reference an already registered provider,
 * use the {@link JenkinsProvider#fromJenkinsProviderAttributes} method.
 *
 * @experimental
 */
export interface IJenkinsProvider extends cdk.IConstruct {
    /**
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    readonly serverUrl: string;
    /**
     * @experimental
     */
    readonly version: string;
    /**
     * Registers a Jenkins Provider for the build category.
     * This method will be automatically called when creating
     * a {@link JenkinsAction},
     * so you should never need to call it explicitly.
     *
     * @internal
     */
    _registerBuildProvider(): void;
    /**
     * Registers a Jenkins Provider for the test category.
     * This method will be automatically called when creating
     * a {@link JenkinsTestAction},
     * so you should never need to call it explicitly.
     *
     * @internal
     */
    _registerTestProvider(): void;
}
/**
 * (experimental) Properties for importing an existing Jenkins provider.
 *
 * @experimental
 */
export interface JenkinsProviderAttributes {
    /**
     * (experimental) The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
     *
     * @experimental
     * @example
     *
     * 'MyJenkinsProvider'
     */
    readonly providerName: string;
    /**
     * (experimental) The base URL of your Jenkins server.
     *
     * @experimental
     * @example
     *
     * 'http://myjenkins.com:8080'
     */
    readonly serverUrl: string;
    /**
     * (experimental) The version of your provider.
     *
     * @default '1'
     * @experimental
     */
    readonly version?: string;
}
/**
 * @experimental
 */
export interface JenkinsProviderProps {
    /**
     * (experimental) The name of the Jenkins provider that you set in the AWS CodePipeline plugin configuration of your Jenkins project.
     *
     * @experimental
     * @example
     *
     * 'MyJenkinsProvider'
     */
    readonly providerName: string;
    /**
     * (experimental) The base URL of your Jenkins server.
     *
     * @experimental
     * @example
     *
     * 'http://myjenkins.com:8080'
     */
    readonly serverUrl: string;
    /**
     * (experimental) The version of your provider.
     *
     * @default '1'
     * @experimental
     */
    readonly version?: string;
    /**
     * (experimental) Whether to immediately register a Jenkins Provider for the build category.
     *
     * The Provider will always be registered if you create a {@link JenkinsAction}.
     *
     * @default false
     * @experimental
     */
    readonly forBuild?: boolean;
    /**
     * (experimental) Whether to immediately register a Jenkins Provider for the test category.
     *
     * The Provider will always be registered if you create a {@link JenkinsTestAction}.
     *
     * @default false
     * @experimental
     */
    readonly forTest?: boolean;
}
/**
 * @experimental
 */
export declare abstract class BaseJenkinsProvider extends cdk.Construct implements IJenkinsProvider {
    /**
     * @experimental
     */
    abstract readonly providerName: string;
    /**
     * @experimental
     */
    abstract readonly serverUrl: string;
    /**
     * @experimental
     */
    readonly version: string;
    /**
     * @experimental
     */
    protected constructor(scope: Construct, id: string, version?: string);
    /**
     * @internal
     */
    abstract _registerBuildProvider(): void;
    /**
     * @internal
     */
    abstract _registerTestProvider(): void;
}
/**
 * (experimental) A class representing Jenkins providers.
 *
 * @see #import
 * @experimental
 */
export declare class JenkinsProvider extends BaseJenkinsProvider {
    /**
     * (experimental) Import a Jenkins provider registered either outside the CDK, or in a different CDK Stack.
     *
     * @param scope the parent Construct for the new provider.
     * @param id the identifier of the new provider Construct.
     * @param attrs the properties used to identify the existing provider.
     * @returns a new Construct representing a reference to an existing Jenkins provider
     * @experimental
     */
    static fromJenkinsProviderAttributes(scope: Construct, id: string, attrs: JenkinsProviderAttributes): IJenkinsProvider;
    /**
     * @experimental
     */
    readonly providerName: string;
    /**
     * @experimental
     */
    readonly serverUrl: string;
    private buildIncluded;
    private testIncluded;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: JenkinsProviderProps);
    /**
     * @internal
     */
    _registerBuildProvider(): void;
    /**
     * @internal
     */
    _registerTestProvider(): void;
    private registerJenkinsCustomAction;
}
export declare const jenkinsArtifactsBounds: codepipeline.ActionArtifactBounds;
