import * as codepipeline from "../../../aws-codepipeline";
import { Construct, SecretValue } from "../../../core";
import { Action } from '../action';
/**
 * (experimental) If and how the GitHub source action should be triggered.
 *
 * @experimental
 */
export declare enum GitHubTrigger {
    /**
     * @experimental
     */
    NONE = "None",
    /**
     * @experimental
     */
    POLL = "Poll",
    /**
     * @experimental
     */
    WEBHOOK = "WebHook"
}
/**
 * (experimental) The CodePipeline variables emitted by GitHub source Action.
 *
 * @experimental
 */
export interface GitHubSourceVariables {
    /**
     * (experimental) The name of the repository this action points to.
     *
     * @experimental
     */
    readonly repositoryName: string;
    /**
     * (experimental) The name of the branch this action tracks.
     *
     * @experimental
     */
    readonly branchName: string;
    /**
     * (experimental) The date the currently last commit on the tracked branch was authored, in ISO-8601 format.
     *
     * @experimental
     */
    readonly authorDate: string;
    /**
     * (experimental) The date the currently last commit on the tracked branch was committed, in ISO-8601 format.
     *
     * @experimental
     */
    readonly committerDate: string;
    /**
     * (experimental) The SHA1 hash of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitId: string;
    /**
     * (experimental) The message of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitMessage: string;
    /**
     * (experimental) The GitHub API URL of the currently last commit on the tracked branch.
     *
     * @experimental
     */
    readonly commitUrl: string;
}
/**
 * (experimental) Construction properties of the {@link GitHubSourceAction GitHub source action}.
 *
 * @experimental
 */
export interface GitHubSourceActionProps extends codepipeline.CommonActionProps {
    /**
     * @experimental
     */
    readonly output: codepipeline.Artifact;
    /**
     * (experimental) The GitHub account/user that owns the repo.
     *
     * @experimental
     */
    readonly owner: string;
    /**
     * (experimental) The name of the repo, without the username.
     *
     * @experimental
     */
    readonly repo: string;
    /**
     * (experimental) The branch to use.
     *
     * @default "master"
     * @experimental
     */
    readonly branch?: string;
    /**
     * (experimental) A GitHub OAuth token to use for authentication.
     *
     * It is recommended to use a Secrets Manager `Secret` to obtain the token:
     *
     *    const oauth = cdk.SecretValue.secretsManager('my-github-token');
     *    new GitHubSource(this, 'GitHubAction', { oauthToken: oauth, ... });
     *
     * The GitHub Personal Access Token should have these scopes:
     *
     * * **repo** - to read the repository
     * * **admin:repo_hook** - if you plan to use webhooks (true by default)
     *
     * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/GitHub-create-personal-token-CLI.html
     * @experimental
     */
    readonly oauthToken: SecretValue;
    /**
     * (experimental) How AWS CodePipeline should be triggered.
     *
     * With the default value "WEBHOOK", a webhook is created in GitHub that triggers the action
     * With "POLL", CodePipeline periodically checks the source for changes
     * With "None", the action is not triggered through changes in the source
     *
     * To use `WEBHOOK`, your GitHub Personal Access Token should have
     * **admin:repo_hook** scope (in addition to the regular **repo** scope).
     *
     * @default GitHubTrigger.WEBHOOK
     * @experimental
     */
    readonly trigger?: GitHubTrigger;
}
/**
 * (experimental) Source that is provided by a GitHub repository.
 *
 * @experimental
 */
export declare class GitHubSourceAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: GitHubSourceActionProps);
    /**
     * (experimental) The variables emitted by this action.
     *
     * @experimental
     */
    get variables(): GitHubSourceVariables;
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(scope: Construct, stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
