import * as codepipeline from "../../../aws-codepipeline";
import { Construct, SecretValue } from "../../../core";
import { Action } from '../action';
/**
 * (experimental) Construction properties of the {@link AlexaSkillDeployAction Alexa deploy Action}.
 *
 * @experimental
 */
export interface AlexaSkillDeployActionProps extends codepipeline.CommonActionProps {
    /**
     * (experimental) The client id of the developer console token.
     *
     * @experimental
     */
    readonly clientId: string;
    /**
     * (experimental) The client secret of the developer console token.
     *
     * @experimental
     */
    readonly clientSecret: SecretValue;
    /**
     * (experimental) The refresh token of the developer console token.
     *
     * @experimental
     */
    readonly refreshToken: SecretValue;
    /**
     * (experimental) The Alexa skill id.
     *
     * @experimental
     */
    readonly skillId: string;
    /**
     * (experimental) The source artifact containing the voice model and skill manifest.
     *
     * @experimental
     */
    readonly input: codepipeline.Artifact;
    /**
     * (experimental) An optional artifact containing overrides for the skill manifest.
     *
     * @experimental
     */
    readonly parameterOverridesArtifact?: codepipeline.Artifact;
}
/**
 * (experimental) Deploys the skill to Alexa.
 *
 * @experimental
 */
export declare class AlexaSkillDeployAction extends Action {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: AlexaSkillDeployActionProps);
    /**
     * (experimental) The method called when an Action is attached to a Pipeline.
     *
     * This method is guaranteed to be called only once for each Action instance.
     *
     * @experimental
     */
    protected bound(_scope: Construct, _stage: codepipeline.IStage, _options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
