import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::CodeGuruProfiler::ProfilingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html
 * @external
 */
export interface CfnProfilingGroupProps {
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.ProfilingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-profilinggroupname
     * @external
     */
    readonly profilingGroupName: string;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.AgentPermissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-agentpermissions
     * @external
     */
    readonly agentPermissions?: any | cdk.IResolvable;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.AnomalyDetectionNotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-anomalydetectionnotificationconfiguration
     * @external
     */
    readonly anomalyDetectionNotificationConfiguration?: Array<CfnProfilingGroup.ChannelProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.ComputePlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-computeplatform
     * @external
     */
    readonly computePlatform?: string;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodeGuruProfiler::ProfilingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html
 * @external
 * @cloudformationResource AWS::CodeGuruProfiler::ProfilingGroup
 */
export declare class CfnProfilingGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeGuruProfiler::ProfilingGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProfilingGroup;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.ProfilingGroupName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-profilinggroupname
     * @external
     */
    profilingGroupName: string;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.AgentPermissions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-agentpermissions
     * @external
     */
    agentPermissions: any | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.AnomalyDetectionNotificationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-anomalydetectionnotificationconfiguration
     * @external
     */
    anomalyDetectionNotificationConfiguration: Array<CfnProfilingGroup.ChannelProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.ComputePlatform`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-computeplatform
     * @external
     */
    computePlatform: string | undefined;
    /**
     * `AWS::CodeGuruProfiler::ProfilingGroup.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html#cfn-codeguruprofiler-profilinggroup-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodeGuruProfiler::ProfilingGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProfilingGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CodeGuruProfiler::ProfilingGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeguruprofiler-profilinggroup.html
 * @external
 * @cloudformationResource AWS::CodeGuruProfiler::ProfilingGroup
 */
export declare namespace CfnProfilingGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeguruprofiler-profilinggroup-channel.html
     * @external
     */
    interface ChannelProperty {
        /**
         * `CfnProfilingGroup.ChannelProperty.channelId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeguruprofiler-profilinggroup-channel.html#cfn-codeguruprofiler-profilinggroup-channel-channelid
         * @external
         */
        readonly channelId?: string;
        /**
         * `CfnProfilingGroup.ChannelProperty.channelUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codeguruprofiler-profilinggroup-channel.html#cfn-codeguruprofiler-profilinggroup-channel-channeluri
         * @external
         */
        readonly channelUri: string;
    }
}
