"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAutoRollbackConfiguration = exports.renderAlarmConfiguration = exports.arnForDeploymentConfig = exports.arnForDeploymentGroup = exports.arnForApplication = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function arnForApplication(applicationName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:application:${applicationName}`;
}
exports.arnForApplication = arnForApplication;
function arnForDeploymentGroup(applicationName, deploymentGroupName) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentgroup:${applicationName}/${deploymentGroupName}`;
}
exports.arnForDeploymentGroup = arnForDeploymentGroup;
function arnForDeploymentConfig(name) {
    return `arn:${core_1.Aws.PARTITION}:codedeploy:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:deploymentconfig:${name}`;
}
exports.arnForDeploymentConfig = arnForDeploymentConfig;
function renderAlarmConfiguration(alarms, ignorePollAlarmFailure) {
    return alarms.length === 0
        ? undefined
        : {
            alarms: alarms.map(a => ({ name: a.alarmName })),
            enabled: true,
            ignorePollAlarmFailure,
        };
}
exports.renderAlarmConfiguration = renderAlarmConfiguration;
var AutoRollbackEvent;
(function (AutoRollbackEvent) {
    AutoRollbackEvent["DEPLOYMENT_FAILURE"] = "DEPLOYMENT_FAILURE";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_ALARM"] = "DEPLOYMENT_STOP_ON_ALARM";
    AutoRollbackEvent["DEPLOYMENT_STOP_ON_REQUEST"] = "DEPLOYMENT_STOP_ON_REQUEST";
})(AutoRollbackEvent || (AutoRollbackEvent = {}));
function renderAutoRollbackConfiguration(alarms, autoRollbackConfig = {}) {
    const events = new Array();
    // we roll back failed deployments by default
    if (autoRollbackConfig.failedDeployment !== false) {
        events.push(AutoRollbackEvent.DEPLOYMENT_FAILURE);
    }
    // we _do not_ roll back stopped deployments by default
    if (autoRollbackConfig.stoppedDeployment === true) {
        events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_REQUEST);
    }
    // we _do not_ roll back alarm-triggering deployments by default
    // unless the Deployment Group has at least one alarm
    if (autoRollbackConfig.deploymentInAlarm !== false) {
        if (alarms.length > 0) {
            events.push(AutoRollbackEvent.DEPLOYMENT_STOP_ON_ALARM);
        }
        else if (autoRollbackConfig.deploymentInAlarm === true) {
            throw new Error("The auto-rollback setting 'deploymentInAlarm' does not have any effect unless you associate " +
                'at least one CloudWatch alarm with the Deployment Group');
        }
    }
    return events.length > 0
        ? {
            enabled: true,
            events,
        }
        : undefined;
}
exports.renderAutoRollbackConfiguration = renderAutoRollbackConfiguration;
//# sourceMappingURL=data:application/json;base64,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