"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = exports.LoadBalancerGeneration = void 0;
/**
 * (experimental) The generations of AWS load balancing solutions.
 *
 * @experimental
 */
var LoadBalancerGeneration;
(function (LoadBalancerGeneration) {
    LoadBalancerGeneration[LoadBalancerGeneration["FIRST"] = 0] = "FIRST";
    LoadBalancerGeneration[LoadBalancerGeneration["SECOND"] = 1] = "SECOND";
})(LoadBalancerGeneration = exports.LoadBalancerGeneration || (exports.LoadBalancerGeneration = {}));
/**
 * (experimental) An interface of an abstract load balancer, as needed by CodeDeploy.
 *
 * Create instances using the static factory methods:
 * {@link #classic}, {@link #application} and {@link #network}.
 *
 * @experimental
 */
class LoadBalancer {
    /**
     * (experimental) Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     *
     * @param loadBalancer a classic ELB Load Balancer.
     * @experimental
     */
    static classic(loadBalancer) {
        class ClassicLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.FIRST;
                this.name = loadBalancer.loadBalancerName;
            }
        }
        return new ClassicLoadBalancer();
    }
    /**
     * (experimental) Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     *
     * @param albTargetGroup an ALB Target Group.
     * @experimental
     */
    static application(albTargetGroup) {
        class AlbLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.SECOND;
                this.name = albTargetGroup.targetGroupName;
            }
        }
        return new AlbLoadBalancer();
    }
    /**
     * (experimental) Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     *
     * @param nlbTargetGroup an NLB Target Group.
     * @experimental
     */
    static network(nlbTargetGroup) {
        class NlbLoadBalancer extends LoadBalancer {
            constructor() {
                super(...arguments);
                this.generation = LoadBalancerGeneration.SECOND;
                this.name = nlbTargetGroup.targetGroupName;
            }
        }
        return new NlbLoadBalancer();
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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