import * as elb from "../../../aws-elasticloadbalancing";
import * as elbv2 from "../../../aws-elasticloadbalancingv2";
/**
 * (experimental) The generations of AWS load balancing solutions.
 *
 * @experimental
 */
export declare enum LoadBalancerGeneration {
    /**
     * (experimental) The first generation (ELB Classic).
     *
     * @experimental
     */
    FIRST = 0,
    /**
     * (experimental) The second generation (ALB and NLB).
     *
     * @experimental
     */
    SECOND = 1
}
/**
 * (experimental) An interface of an abstract load balancer, as needed by CodeDeploy.
 *
 * Create instances using the static factory methods:
 * {@link #classic}, {@link #application} and {@link #network}.
 *
 * @experimental
 */
export declare abstract class LoadBalancer {
    /**
     * (experimental) Creates a new CodeDeploy load balancer from a Classic ELB Load Balancer.
     *
     * @param loadBalancer a classic ELB Load Balancer.
     * @experimental
     */
    static classic(loadBalancer: elb.LoadBalancer): LoadBalancer;
    /**
     * (experimental) Creates a new CodeDeploy load balancer from an Application Load Balancer Target Group.
     *
     * @param albTargetGroup an ALB Target Group.
     * @experimental
     */
    static application(albTargetGroup: elbv2.ApplicationTargetGroup): LoadBalancer;
    /**
     * (experimental) Creates a new CodeDeploy load balancer from a Network Load Balancer Target Group.
     *
     * @param nlbTargetGroup an NLB Target Group.
     * @experimental
     */
    static network(nlbTargetGroup: elbv2.NetworkTargetGroup): LoadBalancer;
    /**
     * @experimental
     */
    abstract readonly generation: LoadBalancerGeneration;
    /**
     * @experimental
     */
    abstract readonly name: string;
}
