import * as cdk from "../../../core";
import { Construct } from 'constructs';
import { CfnDeploymentConfig } from '../codedeploy.generated';
/**
 * (experimental) The Deployment Configuration of an EC2/on-premise Deployment Group.
 *
 * The default, pre-defined Configurations are available as constants on the {@link ServerDeploymentConfig} class
 * (`ServerDeploymentConfig.HalfAtATime`, `ServerDeploymentConfig.AllAtOnce`, etc.).
 * To create a custom Deployment Configuration,
 * instantiate the {@link ServerDeploymentConfig} Construct.
 *
 * @experimental
 */
export interface IServerDeploymentConfig {
    /**
     * @experimental
     * @attribute true
     */
    readonly deploymentConfigName: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly deploymentConfigArn: string;
}
/**
 * (experimental) Minimum number of healthy hosts for a server deployment.
 *
 * @experimental
 */
export declare class MinimumHealthyHosts {
    private readonly json;
    /**
     * (experimental) The minimum healhty hosts threshold expressed as an absolute number.
     *
     * @experimental
     */
    static count(value: number): MinimumHealthyHosts;
    /**
     * (experimental) The minmum healhty hosts threshold expressed as a percentage of the fleet.
     *
     * @experimental
     */
    static percentage(value: number): MinimumHealthyHosts;
    private constructor();
    /**
     * @internal
     */
    get _json(): CfnDeploymentConfig.MinimumHealthyHostsProperty;
}
/**
 * (experimental) Construction properties of {@link ServerDeploymentConfig}.
 *
 * @experimental
 */
export interface ServerDeploymentConfigProps {
    /**
     * (experimental) The physical, human-readable name of the Deployment Configuration.
     *
     * @default a name will be auto-generated
     * @experimental
     */
    readonly deploymentConfigName?: string;
    /**
     * (experimental) Minimum number of healthy hosts.
     *
     * @experimental
     */
    readonly minimumHealthyHosts: MinimumHealthyHosts;
}
/**
 * (experimental) A custom Deployment Configuration for an EC2/on-premise Deployment Group.
 *
 * @experimental
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
export declare class ServerDeploymentConfig extends cdk.Resource implements IServerDeploymentConfig {
    /**
     * @experimental
     */
    static readonly ONE_AT_A_TIME: IServerDeploymentConfig;
    /**
     * @experimental
     */
    static readonly HALF_AT_A_TIME: IServerDeploymentConfig;
    /**
     * @experimental
     */
    static readonly ALL_AT_ONCE: IServerDeploymentConfig;
    /**
     * (experimental) Import a custom Deployment Configuration for an EC2/on-premise Deployment Group defined either outside the CDK app, or in a different region.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param serverDeploymentConfigName the properties of the referenced custom Deployment Configuration.
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     * @experimental
     */
    static fromServerDeploymentConfigName(scope: Construct, id: string, serverDeploymentConfigName: string): IServerDeploymentConfig;
    /**
     * @experimental
     */
    readonly deploymentConfigName: string;
    /**
     * @experimental
     */
    readonly deploymentConfigArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ServerDeploymentConfigProps);
}
