import { IResource, Resource } from "../../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents a reference to a CodeDeploy Application deploying to EC2/on-premise instances.
 *
 * If you're managing the Application alongside the rest of your CDK resources,
 * use the {@link ServerApplication} class.
 *
 * If you want to reference an already existing Application,
 * or one defined in a different CDK Stack,
 * use the {@link #fromServerApplicationName} method.
 *
 * @experimental
 */
export interface IServerApplication extends IResource {
    /**
     * @experimental
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * @experimental
     * @attribute true
     */
    readonly applicationName: string;
}
/**
 * (experimental) Construction properties for {@link ServerApplication}.
 *
 * @experimental
 */
export interface ServerApplicationProps {
    /**
     * (experimental) The physical, human-readable name of the CodeDeploy Application.
     *
     * @default an auto-generated name will be used
     * @experimental
     */
    readonly applicationName?: string;
}
/**
 * (experimental) A CodeDeploy Application that deploys to EC2/on-premise instances.
 *
 * @experimental
 * @resource AWS::CodeDeploy::Application
 */
export declare class ServerApplication extends Resource implements IServerApplication {
    /**
     * (experimental) Import an Application defined either outside the CDK app, or in a different region.
     *
     * @param scope the parent Construct for this new Construct.
     * @param id the logical ID of this new Construct.
     * @param serverApplicationName the name of the application to import.
     * @returns a Construct representing a reference to an existing Application
     * @experimental
     */
    static fromServerApplicationName(scope: Construct, id: string, serverApplicationName: string): IServerApplication;
    /**
     * @experimental
     */
    readonly applicationArn: string;
    /**
     * @experimental
     */
    readonly applicationName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ServerApplicationProps);
}
