import { Duration, Resource } from "../../../core";
import { Construct } from 'constructs';
import { ILambdaDeploymentConfig } from './deployment-config';
/**
 * (experimental) Lambda Deployment config type.
 *
 * @experimental
 */
export declare enum CustomLambdaDeploymentConfigType {
    /**
     * (experimental) Canary deployment type.
     *
     * @experimental
     */
    CANARY = "Canary",
    /**
     * (experimental) Linear deployment type.
     *
     * @experimental
     */
    LINEAR = "Linear"
}
/**
 * (experimental) Properties of a reference to a CodeDeploy Lambda Deployment Configuration.
 *
 * @experimental
 */
export interface CustomLambdaDeploymentConfigProps {
    /**
     * (experimental) The type of deployment config, either CANARY or LINEAR.
     *
     * @experimental
     */
    readonly type: CustomLambdaDeploymentConfigType;
    /**
     * (experimental) The integer percentage of traffic to shift: - For LINEAR, the percentage to shift every interval - For CANARY, the percentage to shift until the interval passes, before the full deployment.
     *
     * @experimental
     */
    readonly percentage: number;
    /**
     * (experimental) The interval, in number of minutes: - For LINEAR, how frequently additional traffic is shifted - For CANARY, how long to shift traffic before the full deployment.
     *
     * @experimental
     */
    readonly interval: Duration;
    /**
     * (experimental) The verbatim name of the deployment config.
     *
     * Must be unique per account/region.
     * Other parameters cannot be updated if this name is provided.
     *
     * @default - automatically generated name
     * @experimental
     */
    readonly deploymentConfigName?: string;
}
/**
 * (experimental) A custom Deployment Configuration for a Lambda Deployment Group.
 *
 * @experimental
 * @resource AWS::CodeDeploy::DeploymentGroup
 */
export declare class CustomLambdaDeploymentConfig extends Resource implements ILambdaDeploymentConfig {
    /**
     * (experimental) The name of the deployment config.
     *
     * @experimental
     * @attribute true
     */
    readonly deploymentConfigName: string;
    /**
     * (experimental) The arn of the deployment config.
     *
     * @experimental
     * @attribute true
     */
    readonly deploymentConfigArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: CustomLambdaDeploymentConfigProps);
    private validateParameters;
}
